/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.util.Stack;

public class ThreadPool {
    private Stack pool = new Stack();
    private int maxSize = 10;

    private synchronized void returnWorker(Worker w) {
        if (this.pool.size() < this.maxSize) {
            this.pool.push(w);
        } else {
            w.die();
        }
    }

    public synchronized void run(Runnable work) {
        if (this.pool.size() == 0) {
            new Worker(work);
        } else {
            Worker w = (Worker)this.pool.pop();
            w.run(work);
        }
    }

    public void setMaximumSize(int size) {
        this.maxSize = size;
    }

    class Worker
    extends Thread {
        boolean running = true;
        Runnable work;

        Worker(Runnable work) {
            this.work = work;
            this.setDaemon(true);
            this.start();
        }

        public synchronized void die() {
            this.running = false;
            this.notify();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block7: while (this.running) {
                if (this.work != null) {
                    try {
                        this.work.run();
                    }
                    catch (Exception exception) {}
                    this.work = null;
                }
                ThreadPool.this.returnWorker(this);
                Worker worker = this;
                synchronized (worker) {
                    while (true) {
                        if (!this.running || this.work != null) {
                            continue block7;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        public synchronized void run(Runnable work) {
            if (this.work != null) {
                throw new IllegalStateException("Worker already has work to do.");
            }
            this.work = work;
            this.notify();
        }
    }
}

