/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier.event;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EventObject;
import org.jboss.verifier.Section;
import org.jboss.verifier.event.VerificationEventGenerator;

public class VerificationEvent
extends EventObject {
    public static final String WARNING = "WARNING";
    public static final String OK = "OK";
    private boolean isOk = false;
    private boolean isWarning = false;
    private String message = "<undefined>";
    private String beanName = "<unnamed>";
    private Method method = null;
    private String section = null;
    private static final String STATE_NOT_RECOGNIZED = "Unknown event state";

    public VerificationEvent(VerificationEventGenerator source) {
        super(source);
    }

    public VerificationEvent(VerificationEventGenerator source, String message) {
        this(source);
        this.setMessage(message);
    }

    private String getCommaSeparatedList(Object[] list) {
        if (list == null || list.length <= 0) {
            return "";
        }
        if (list.length == 1) {
            return list[0].toString();
        }
        StringBuffer buf = new StringBuffer(256);
        buf.append(list[0]);
        int i = 1;
        while (i < list.length) {
            buf.append(", ").append(list[i]);
            ++i;
        }
        return buf.toString();
    }

    public String getMessage() {
        return String.valueOf(this.beanName) + ": " + this.message;
    }

    public String getName() {
        return this.beanName;
    }

    private String getShortClassName(Class c) {
        String className = c.getName();
        int len = className.length();
        int offset = className.lastIndexOf(".");
        String name = "";
        name = offset == -1 ? className : className.substring(offset + 1, len);
        return name;
    }

    private String[] getShortClassNames(Class[] c) {
        String[] names = new String[c.length];
        int i = 0;
        while (i < c.length) {
            names[i] = this.getShortClassName(c[i]);
            ++i;
        }
        return names;
    }

    public String getVerbose() {
        int offset;
        StringBuffer buf = new StringBuffer(512);
        String linebreak = System.getProperty("line.separator");
        buf.append(String.valueOf(linebreak) + "Bean   : " + this.beanName + linebreak);
        if (this.method != null) {
            String returnType = this.getShortClassName(this.method.getReturnType());
            Class[] arguments = this.method.getParameterTypes();
            String arglist = this.getCommaSeparatedList(this.getShortClassNames(arguments));
            Class[] exceptions = this.method.getExceptionTypes();
            String exclist = this.getCommaSeparatedList(this.getShortClassNames(exceptions));
            buf.append("Method : " + Modifier.toString(this.method.getModifiers()) + " " + returnType + " " + this.method.getName() + "(" + arglist + ")");
            if (exclist.length() > 0) {
                buf.append(" throws " + exclist.toString());
            }
            buf.append(linebreak);
        }
        if (!Character.isDigit(this.section.charAt((offset = this.section.lastIndexOf(".")) + 1))) {
            buf.append("Section: " + this.section.substring(0, offset) + linebreak);
        } else {
            buf.append("Section: " + this.section + linebreak);
        }
        buf.append("Warning: " + this.message + linebreak);
        return buf.toString();
    }

    public boolean isOk() {
        return this.isOk;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public void setMethod(Method method) {
        if (method == null) {
            return;
        }
        this.method = method;
    }

    public void setName(String name) {
        this.beanName = name;
    }

    public void setSection(Section section) {
        this.section = section.getSection();
    }

    public void setState(String state) {
        if (WARNING.equalsIgnoreCase(state)) {
            this.isWarning = true;
            this.isOk = false;
        } else if (OK.equalsIgnoreCase(state)) {
            this.isOk = true;
            this.isWarning = false;
        } else {
            throw new IllegalArgumentException("Unknown event state: " + state);
        }
    }
}

