/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.timeout;

import org.jboss.logging.Logger;
import org.jboss.util.timeout.Timeout;
import org.jboss.util.timeout.TimeoutTarget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TimeoutFactory {
    static Logger log = Logger.getLogger(class$org$jboss$util$timeout$TimeoutFactory != null ? class$org$jboss$util$timeout$TimeoutFactory : (class$org$jboss$util$timeout$TimeoutFactory = TimeoutFactory.class$("org.jboss.util.timeout.TimeoutFactory")));
    private TimeoutImpl freeList = null;
    private int size = 0;
    private TimeoutImpl[] q = new TimeoutImpl[16];
    private static TimeoutFactory singleton = new TimeoutFactory();
    static /* synthetic */ Class class$org$jboss$util$timeout$TimeoutFactory;

    static {
        Thread thread = new Thread(){

            public void run() {
                singleton.doWork();
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private TimeoutFactory() {
    }

    private void assert(boolean expr) {
        block2: {
            if (expr) break block2;
            log.error("***** assert failed *****", new RuntimeException("trace"));
            try {
                Thread.sleep(30000L);
            }
            catch (Exception exception) {}
        }
    }

    private void checkFreeList() {
        TimeoutImpl to = this.freeList;
        while (to != null) {
            this.assert(to.index == -1);
            to = to.nextFree;
        }
    }

    private void checkTree() {
        this.assert(this.size >= 0);
        this.assert(this.size < this.q.length);
        this.assert(this.q[0] == null);
        if (this.size > 0) {
            this.assert(this.q[1] != null);
            this.assert(this.q[1].index == 1);
            int i = 2;
            while (i <= this.size) {
                this.assert(this.q[i] != null);
                this.assert(this.q[i].index == i);
                this.assert(this.q[i >> 1].time <= this.q[i].time);
                ++i;
            }
            int i2 = this.size + 1;
            while (i2 < this.q.length) {
                this.assert(this.q[i2] == null);
                ++i2;
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static Timeout createTimeout(long time, TimeoutTarget target) {
        if (time <= 0L) {
            throw new IllegalArgumentException("Time not positive");
        }
        if (target == null) {
            throw new IllegalArgumentException("Null target");
        }
        return singleton.newTimeout(time, target);
    }

    private void doWork() {
        while (true) {
            TimeoutImpl work = null;
            TimeoutFactory timeoutFactory = this;
            synchronized (timeoutFactory) {
                if (this.size == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    long now = System.currentTimeMillis();
                    if (this.q[1].time > now) {
                        try {
                            this.wait(this.q[1].time - now);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.size > 0 && this.q[1].time <= System.currentTimeMillis()) {
                        work = this.removeNode(1);
                        work.index = -2;
                    }
                }
            }
            if (work == null) continue;
            TimeoutWorker worker = new TimeoutWorker(work);
            worker.start();
        }
    }

    private void dropTimeout(TimeoutImpl timeout) {
        Object object = this;
        synchronized (object) {
            if (timeout.index > 0) {
                this.removeNode(timeout.index);
                timeout.index = -1;
                timeout.nextFree = this.freeList;
                this.freeList = timeout;
                Object var3_3 = null;
                return;
            }
        }
        object = timeout;
        synchronized (object) {
            if (timeout.index == -2 || timeout.index == -3) {
                timeout.index = -3;
                while (timeout.index == -3) {
                    try {
                        timeout.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private synchronized Timeout newTimeout(long time, TimeoutTarget target) {
        TimeoutImpl timeout;
        if (++this.size == this.q.length) {
            TimeoutImpl[] newQ = new TimeoutImpl[2 * this.q.length];
            System.arraycopy(this.q, 0, newQ, 0, this.q.length);
            this.q = newQ;
        }
        if (this.freeList != null) {
            timeout = this.q[this.size] = this.freeList;
            this.freeList = timeout.nextFree;
        } else {
            timeout = this.q[this.size] = new TimeoutImpl();
        }
        timeout.index = this.size;
        timeout.time = time;
        timeout.target = target;
        this.normalizeUp(this.size);
        if (timeout.index == 1) {
            this.notify();
        }
        return timeout;
    }

    private boolean normalizeUp(int index) {
        if (index == 1) {
            return false;
        }
        boolean ret = false;
        long t = this.q[index].time;
        int p = index >> 1;
        while (this.q[p].time > t) {
            this.swap(p, index);
            ret = true;
            if (p == 1) break;
            index = p;
            p >>= 1;
        }
        return ret;
    }

    private TimeoutImpl removeNode(int index) {
        TimeoutImpl res = this.q[index];
        if (index == this.size) {
            --this.size;
            this.q[index] = null;
            return res;
        }
        this.swap(index, this.size);
        --this.size;
        this.q[res.index] = null;
        if (this.normalizeUp(index)) {
            return res;
        }
        long t = this.q[index].time;
        int c = index << 1;
        while (c <= this.size) {
            TimeoutImpl l = this.q[c];
            if (c + 1 <= this.size) {
                TimeoutImpl r = this.q[c + 1];
                if (l.time <= r.time) {
                    if (t <= l.time) break;
                    this.swap(index, c);
                    index = c;
                } else {
                    if (t <= r.time) break;
                    this.swap(index, c + 1);
                    index = c + 1;
                }
            } else {
                if (t <= l.time) break;
                this.swap(index, c);
                index = c;
            }
            c = index << 1;
        }
        return res;
    }

    private void swap(int a, int b) {
        TimeoutImpl temp = this.q[a];
        this.q[a] = this.q[b];
        this.q[a].index = a;
        this.q[b] = temp;
        this.q[b].index = b;
    }

    private class TimeoutImpl
    implements Timeout {
        static final int DONE = -1;
        static final int TIMEOUT = -2;
        static final int CWAIT = -3;
        int index;
        long time;
        TimeoutTarget target;
        TimeoutImpl nextFree;

        TimeoutImpl() {
        }

        public void cancel() {
            TimeoutFactory.this.dropTimeout(this);
        }
    }

    private static class TimeoutWorker
    extends Thread {
        private TimeoutImpl work;

        TimeoutWorker(TimeoutImpl work) {
            this.work = work;
            this.setDaemon(false);
        }

        public void run() {
            try {
                this.work.target.timedOut(this.work);
            }
            catch (Throwable t) {
                log.error("timedOut exception", t);
            }
            TimeoutImpl t = this.work;
            synchronized (t) {
                if (this.work.index == -3) {
                    this.work.index = -1;
                    this.work.notifyAll();
                } else {
                    this.work.index = -1;
                }
            }
        }
    }
}

