/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.util.Enumeration;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.util.InfoMBean;

public class Info
implements InfoMBean,
MBeanRegistration {
    public static final String OBJECT_NAME = ":service=Info";
    private static Logger log = Logger.getLogger(class$org$jboss$util$Info != null ? class$org$jboss$util$Info : (class$org$jboss$util$Info = Info.class$("org.jboss.util.Info")));
    static /* synthetic */ Class class$org$jboss$util$Info;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String displayPackageInfo(String pkgName) {
        Package pkg = Package.getPackage(pkgName);
        if (pkg == null) {
            return "<h2>Package:" + pkgName + " Not Found!</h2>";
        }
        StringBuffer info = new StringBuffer("<h2>Package: " + pkgName + "</h2>");
        info.append("<pre>\n");
        info.append("SpecificationTitle: " + pkg.getSpecificationTitle());
        info.append("\nSpecificationVersion: " + pkg.getSpecificationVersion());
        info.append("\nSpecificationVendor: " + pkg.getSpecificationVendor());
        info.append("\nImplementationTitle: " + pkg.getImplementationTitle());
        info.append("\nImplementationVersion: " + pkg.getImplementationVersion());
        info.append("\nImplementationVendor: " + pkg.getImplementationVendor());
        info.append("\nisSealed: " + pkg.isSealed());
        info.append("</pre>\n");
        return info.toString();
    }

    public String getThreadGroupInfo(ThreadGroup group) {
        StringBuffer rc = new StringBuffer();
        rc.append("<BR><B>");
        rc.append("Thread Group: " + group.getName());
        rc.append("</B> : ");
        rc.append("max priority:" + group.getMaxPriority() + ", demon:" + group.isDaemon());
        rc.append("<blockquote>");
        Thread[] threads = new Thread[group.activeCount()];
        group.enumerate(threads, false);
        int i = 0;
        while (i < threads.length && threads[i] != null) {
            rc.append("<B>");
            rc.append("Thread: " + threads[i].getName());
            rc.append("</B> : ");
            rc.append("priority:" + threads[i].getPriority() + ", demon:" + threads[i].isDaemon());
            rc.append("<BR>");
            ++i;
        }
        ThreadGroup[] groups = new ThreadGroup[group.activeGroupCount()];
        group.enumerate(groups, false);
        int i2 = 0;
        while (i2 < groups.length && groups[i2] != null) {
            rc.append(this.getThreadGroupInfo(groups[i2]));
            ++i2;
        }
        rc.append("</blockquote>");
        return rc.toString();
    }

    public String listMemoryUsage() {
        String rc = "<P><B>Total Memory: </B>" + Runtime.getRuntime().totalMemory() + " </P>" + "<P><B>Free Memory: </B>" + Runtime.getRuntime().freeMemory() + " </P>";
        return rc;
    }

    public String listSystemInfo() {
        StringBuffer rc = new StringBuffer();
        rc.append("<pre>");
        rc.append("Java version: " + System.getProperty("java.version") + "," + System.getProperty("java.vendor"));
        rc.append("\n");
        rc.append("Java VM: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "," + System.getProperty("java.vm.vendor"));
        rc.append("\n");
        rc.append("System: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "," + System.getProperty("os.arch"));
        rc.append("\n");
        rc.append("</pre>");
        return rc.toString();
    }

    public String listThreadDump() {
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        int activeThreads = root.activeCount() - 1;
        int activeGroups = root.activeGroupCount() + 1;
        String rc = "<b>Total Threads:</b> " + activeThreads + "<br>" + "<b>Total Thread Groups:</b> " + activeGroups + "<br>" + this.getThreadGroupInfo(root);
        return rc;
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        log.info("Java version: " + System.getProperty("java.version") + "," + System.getProperty("java.vendor"));
        log.info("Java VM: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "," + System.getProperty("java.vm.vendor"));
        log.info("System: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "," + System.getProperty("os.arch"));
        if (log.isDebugEnabled()) {
            log.debug("+++ Full System Properties Dump");
            Enumeration<?> names = System.getProperties().propertyNames();
            while (names.hasMoreElements()) {
                String pname = (String)names.nextElement();
                log.debug(String.valueOf(pname) + ": " + System.getProperty(pname));
            }
        }
        name = name == null ? new ObjectName(OBJECT_NAME) : name;
        return name;
    }

    public String runGarbageCollector() {
        StringBuffer buff = new StringBuffer();
        buff.append("<h3>Before</h3>");
        buff.append(this.listMemoryUsage());
        buff.append("<h3>After</h3>");
        log.info("hinting the VM to run the garbage collector");
        System.gc();
        buff.append(this.listMemoryUsage());
        return buff.toString();
    }

    public void traceInstructions(boolean flag) {
        Runtime.getRuntime().traceInstructions(flag);
    }

    public void traceMethodCalls(boolean flag) {
        Runtime.getRuntime().traceMethodCalls(flag);
    }
}

