/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    public static final int JBOSS_FORMAT_ID = 257;
    private int hash;
    private byte[] globalId;
    private byte[] branchId;
    private static String hostName;
    private static int nextId;
    private static byte[] noBranchQualifier;

    static {
        nextId = 0;
        noBranchQualifier = new byte[0];
        try {
            hostName = String.valueOf(InetAddress.getLocalHost().getHostName()) + "/";
            if (hostName.length() > 49) {
                hostName = hostName.substring(0, 49);
            }
            hostName = String.valueOf(hostName) + "/";
        }
        catch (UnknownHostException unknownHostException) {
            hostName = "localhost/";
        }
    }

    public XidImpl() {
        this.hash = XidImpl.getNextId();
        this.globalId = (String.valueOf(hostName) + Integer.toString(this.hash)).getBytes();
        this.branchId = noBranchQualifier;
    }

    public XidImpl(XidImpl xid, int branchId) {
        this.hash = xid.hash;
        this.globalId = xid.globalId;
        this.branchId = Integer.toString(branchId).getBytes();
    }

    public boolean equals(Object obj) {
        if (obj instanceof XidImpl) {
            XidImpl other = (XidImpl)obj;
            if (this.globalId.length != other.globalId.length || this.branchId.length != other.branchId.length) {
                return false;
            }
            int i = 0;
            while (i < this.globalId.length) {
                if (this.globalId[i] != other.globalId[i]) {
                    return false;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.branchId.length) {
                if (this.branchId[i2] != other.branchId[i2]) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    public byte[] getBranchQualifier() {
        if (this.branchId.length == 0) {
            return this.branchId;
        }
        return (byte[])this.branchId.clone();
    }

    public int getFormatId() {
        return 257;
    }

    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalId.clone();
    }

    byte[] getInternalGlobalTransactionId() {
        return this.globalId;
    }

    private static synchronized int getNextId() {
        return nextId++;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return XidImpl.toString(this);
    }

    static String toString(Xid id) {
        if (id == null) {
            return "[NULL Xid]";
        }
        String s = id.getClass().getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        s = String.valueOf(s) + " [FormatId=" + id.getFormatId() + ", GlobalId=" + new String(id.getGlobalTransactionId()).trim() + ", BranchQual=" + new String(id.getBranchQualifier()).trim() + "]";
        return s;
    }
}

