/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.ejb.Application;
import org.jboss.ejb.Container;
import org.jboss.naming.JNDIViewMBean;
import org.jboss.util.ServiceMBeanSupport;

public class JNDIView
extends ServiceMBeanSupport
implements JNDIViewMBean {
    private MBeanServer server;
    static /* synthetic */ Class class$javax$naming$Context;
    static /* synthetic */ Class class$javax$naming$LinkRef;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void formatException(StringBuffer buffer, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        buffer.append("<pre>\n");
        t.printStackTrace(pw);
        buffer.append(sw.toString());
        buffer.append("</pre>\n");
    }

    public String getName() {
        return "JNDIView";
    }

    public ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.server = server;
        return new ObjectName(":service=JNDIView");
    }

    private void list(Context ctx, String indent, StringBuffer buffer, boolean verbose) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            NamingEnumeration<NameClassPair> ne = ctx.list("");
            while (ne.hasMore()) {
                Class<?> c;
                boolean isProxy;
                boolean isLinkRef;
                boolean recursive;
                String className;
                String name;
                NameClassPair pair;
                block21: {
                    pair = ne.next();
                    name = pair.getName();
                    className = pair.getClassName();
                    recursive = false;
                    isLinkRef = false;
                    isProxy = false;
                    c = null;
                    try {
                        c = loader.loadClass(className);
                        if ((class$javax$naming$Context != null ? class$javax$naming$Context : JNDIView.class$("javax.naming.Context")).isAssignableFrom(c)) {
                            recursive = true;
                        }
                        if ((class$javax$naming$LinkRef != null ? class$javax$naming$LinkRef : JNDIView.class$("javax.naming.LinkRef")).isAssignableFrom(c)) {
                            isLinkRef = true;
                        }
                        isProxy = Proxy.isProxyClass(c);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!className.startsWith("$Proxy")) break block21;
                        isProxy = true;
                        try {
                            Object p = ctx.lookup(name);
                            c = p.getClass();
                        }
                        catch (NamingException e) {
                            String msg;
                            Throwable t = e.getRootCause();
                            if (!(t instanceof ClassNotFoundException) || (msg = t.getMessage()) == null) break block21;
                            className = msg;
                        }
                    }
                }
                buffer.append(String.valueOf(indent) + " +- " + name);
                if (isLinkRef) {
                    try {
                        LinkRef link = (LinkRef)ctx.lookupLink(name);
                        buffer.append("[link -> ");
                        buffer.append(link.getLinkName());
                        buffer.append(']');
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        buffer.append("[invalid]");
                    }
                }
                if (isProxy) {
                    buffer.append(" (proxy: " + pair.getClassName());
                    if (c != null) {
                        Class<?>[] ifaces = c.getInterfaces();
                        buffer.append(" implements ");
                        int i = 0;
                        while (i < ifaces.length) {
                            buffer.append(ifaces[i]);
                            buffer.append(',');
                            ++i;
                        }
                        buffer.setCharAt(buffer.length() - 1, ')');
                    } else {
                        buffer.append(" implements " + className + ")");
                    }
                } else if (verbose) {
                    buffer.append(" (class: " + pair.getClassName() + ")");
                }
                buffer.append('\n');
                if (!recursive) continue;
                try {
                    Object value = ctx.lookup(name);
                    if (value instanceof Context) {
                        Context subctx = (Context)value;
                        this.list(subctx, String.valueOf(indent) + " |  ", buffer, verbose);
                        continue;
                    }
                    buffer.append(String.valueOf(indent) + " |   NonContext: " + value);
                    buffer.append('\n');
                }
                catch (Throwable t) {
                    buffer.append("Failed to lookup: " + name + ", errmsg=" + t.getMessage());
                    buffer.append('\n');
                }
            }
            ne.close();
        }
        catch (NamingException ne) {
            buffer.append("error while listing context " + ctx.toString() + ": " + ne.toString(true));
            this.formatException(buffer, ne);
        }
    }

    /*
     * Unable to fully structure code
     */
    public String list(boolean verbose) {
        buffer = new StringBuffer();
        applications = null;
        context = null;
        currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            applications = (Iterator)this.server.invoke(new ObjectName(":service=ContainerFactory"), "getDeployedApplications", new Object[0], new String[0]);
            if (true) ** GOTO lbl44
        }
        catch (Exception e) {
            this.log.warn("Failed to getDeployedApplications", e);
            buffer.append("Failed to getDeployedApplications\n");
            this.formatException(buffer, e);
            buffer.insert(0, "<pre>");
            buffer.append("</pre>");
            return buffer.toString();
        }
        do {
            app = (Application)applications.next();
            iter = app.getContainers().iterator();
            buffer.append("<h1>Application: " + app.getName() + "</h1>\n");
            while (iter.hasNext()) {
                con = (Container)iter.next();
                Thread.currentThread().setContextClassLoader(con.getClassLoader());
                bean = con.getBeanMetaData().getEjbName();
                buffer.append("<h2>java:comp namespace of the " + bean + " bean:</h2>\n");
                try {
                    context = new InitialContext();
                    context = (Context)context.lookup("java:comp");
                }
                catch (NamingException e) {
                    buffer.append("Failed on lookup, " + e.toString(true));
                    this.formatException(buffer, e);
                    continue;
                }
                buffer.append("<pre>\n");
                this.list(context, " ", buffer, verbose);
                buffer.append("</pre>\n");
            }
lbl44:
            // 2 sources

        } while (applications.hasNext());
        Thread.currentThread().setContextClassLoader(currentLoader);
        try {
            context = new InitialContext();
            context = (Context)context.lookup("java:");
            buffer.append("<h1>java: Namespace</h1>\n");
            buffer.append("<pre>\n");
            this.list(context, " ", buffer, verbose);
            buffer.append("</pre>\n");
        }
        catch (NamingException e) {
            this.log.warn("Failed to InitialContext", e);
            buffer.append("Failed to get InitialContext, " + e.toString(true));
            this.formatException(buffer, e);
        }
        try {
            context = new InitialContext();
            buffer.append("<h1>Global JNDI Namespace</h1>\n");
            buffer.append("<pre>\n");
            this.list(context, " ", buffer, verbose);
            buffer.append("</pre>\n");
        }
        catch (NamingException e) {
            this.log.warn("Failed to InitialContext", e);
            buffer.append("Failed to get InitialContext, " + e.toString(true));
            this.formatException(buffer, e);
        }
        return buffer.toString();
    }

    public String listXML() {
        StringBuffer buffer = new StringBuffer();
        Iterator applications = null;
        Context context = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            applications = (Iterator)this.server.invoke(new ObjectName(":service=ContainerFactory"), "getDeployedApplications", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.log.warn("Failed to getDeployedApplications", e);
            buffer.append("<jndi>");
            buffer.append("<error>");
            buffer.append('\n');
            buffer.append("<message>Failed to getDeployedApplications " + e.toString() + "</message>");
            buffer.append('\n');
            buffer.append("</error>");
            buffer.append('\n');
            buffer.append("</jndi>");
            buffer.append('\n');
            return buffer.toString();
        }
        buffer.append("<jndi>");
        buffer.append('\n');
        while (applications.hasNext()) {
            Application app = (Application)applications.next();
            Iterator iter = app.getContainers().iterator();
            buffer.append("<application>");
            buffer.append('\n');
            buffer.append("<file>" + app.getName() + "</file>");
            buffer.append('\n');
            while (iter.hasNext()) {
                Container con = (Container)iter.next();
                Thread.currentThread().setContextClassLoader(con.getClassLoader());
                String bean = con.getBeanMetaData().getEjbName();
                buffer.append("<context>");
                buffer.append('\n');
                buffer.append("<name>java:comp</name>");
                buffer.append('\n');
                buffer.append("<attribute name=\"bean\">" + bean + "</attribute>");
                buffer.append('\n');
                try {
                    context = new InitialContext();
                    context = (Context)context.lookup("java:comp");
                }
                catch (NamingException e) {
                    buffer.append("<error>");
                    buffer.append('\n');
                    buffer.append("<message>Failed on lookup, " + e.toString(true) + "</message>");
                    buffer.append('\n');
                    buffer.append("</error>");
                    buffer.append('\n');
                    continue;
                }
                this.listXML(context, buffer);
                buffer.append("</context>");
                buffer.append('\n');
            }
            buffer.append("</application>");
            buffer.append('\n');
        }
        Thread.currentThread().setContextClassLoader(currentLoader);
        try {
            context = new InitialContext();
            context = (Context)context.lookup("java:");
            buffer.append("<context>");
            buffer.append('\n');
            buffer.append("<name>java:</name>");
            buffer.append('\n');
            this.listXML(context, buffer);
            buffer.append("</context>");
            buffer.append('\n');
        }
        catch (NamingException e) {
            this.log.warn("Failed to get getDeployedApplications", e);
            buffer.append("<error>");
            buffer.append('\n');
            buffer.append("<message>Failed to get InitialContext, " + e.toString(true) + "</message>");
            buffer.append('\n');
            buffer.append("</error>");
            buffer.append('\n');
        }
        try {
            context = new InitialContext();
            buffer.append("<context>");
            buffer.append('\n');
            buffer.append("<name>Global</name>");
            buffer.append('\n');
            this.listXML(context, buffer);
            buffer.append("</context>");
            buffer.append('\n');
        }
        catch (NamingException e) {
            this.log.warn("Failed to get InitialContext", e);
            buffer.append("<error>");
            buffer.append('\n');
            buffer.append("<message>Failed to get InitialContext, " + e.toString(true) + "</message>");
            buffer.append('\n');
            buffer.append("</error>");
            buffer.append('\n');
        }
        buffer.append("</jndi>");
        buffer.append('\n');
        return buffer.toString();
    }

    private void listXML(Context ctx, StringBuffer buffer) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            NamingEnumeration<NameClassPair> ne = ctx.list("");
            while (ne.hasMore()) {
                NameClassPair pair = ne.next();
                boolean recursive = false;
                boolean isLinkRef = false;
                try {
                    Class<?> c = loader.loadClass(pair.getClassName());
                    if ((class$javax$naming$Context != null ? class$javax$naming$Context : JNDIView.class$("javax.naming.Context")).isAssignableFrom(c)) {
                        recursive = true;
                    }
                    if ((class$javax$naming$LinkRef != null ? class$javax$naming$LinkRef : JNDIView.class$("javax.naming.LinkRef")).isAssignableFrom(c)) {
                        isLinkRef = true;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
                String name = pair.getName();
                if (isLinkRef) {
                    try {
                        LinkRef link = (LinkRef)ctx.lookupLink(name);
                        buffer.append("<link-ref>");
                        buffer.append('\n');
                        buffer.append("<name>" + pair.getName() + "</name>");
                        buffer.append('\n');
                        buffer.append("<link>" + link.getLinkName() + "</link>");
                        buffer.append('\n');
                        buffer.append("<attribute name=\"class\">" + pair.getClassName() + "</attribute>");
                        buffer.append('\n');
                        buffer.append("</link-ref>");
                        buffer.append('\n');
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        buffer.append("<link-ref>");
                        buffer.append('\n');
                        buffer.append("<name>Invalid</name>");
                        buffer.append('\n');
                        buffer.append("</link-ref>");
                        buffer.append('\n');
                    }
                    continue;
                }
                if (recursive) {
                    try {
                        Object value = ctx.lookup(name);
                        if (value instanceof Context) {
                            Context subctx = (Context)value;
                            buffer.append("<context>");
                            buffer.append('\n');
                            buffer.append("<name>" + pair.getName() + "</name>");
                            buffer.append('\n');
                            buffer.append("<attribute name=\"class\">" + pair.getClassName() + "</attribute>");
                            buffer.append('\n');
                            this.listXML(subctx, buffer);
                            buffer.append("</context>");
                            buffer.append('\n');
                            continue;
                        }
                        buffer.append("<non-context>");
                        buffer.append('\n');
                        buffer.append("<name>" + pair.getName() + "</name>");
                        buffer.append('\n');
                        buffer.append("<attribute name=\"value\">" + value + "</attribute>");
                        buffer.append('\n');
                        buffer.append("</non-context>");
                        buffer.append('\n');
                    }
                    catch (Throwable t) {
                        buffer.append("<error>");
                        buffer.append('\n');
                        buffer.append("<message>Failed to lookup: " + name + ", errmsg=" + t.getMessage() + "</message>");
                        buffer.append('\n');
                        buffer.append("</error>");
                        buffer.append('\n');
                    }
                    continue;
                }
                buffer.append("<leaf>");
                buffer.append('\n');
                buffer.append("<name>" + pair.getName() + "</name>");
                buffer.append('\n');
                buffer.append("<attribute name=\"class\">" + pair.getClassName() + "</attribute>");
                buffer.append('\n');
                buffer.append("</leaf>");
                buffer.append('\n');
            }
            ne.close();
        }
        catch (NamingException ne) {
            buffer.append("<error>");
            buffer.append('\n');
            buffer.append("<message>error while listing context " + ctx.toString() + ": " + ne.toString(true) + "</message>");
            buffer.append('\n');
            buffer.append("</error>");
            buffer.append('\n');
        }
    }
}

