/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor;

import java.util.ArrayList;
import java.util.Iterator;
import javax.management.JMException;
import javax.management.ObjectName;
import org.jboss.ejb.Application;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.InstanceCache;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.monitor.BeanCacheMonitorMBean;
import org.jboss.monitor.Monitorable;
import org.jboss.monitor.client.BeanCacheSnapshot;
import org.jboss.util.ServiceMBeanSupport;

public class BeanCacheMonitor
extends ServiceMBeanSupport
implements BeanCacheMonitorMBean {
    public String getName() {
        return "BeanCacheMonitor";
    }

    public BeanCacheSnapshot[] getSnapshots() {
        Iterator applications = null;
        try {
            applications = (Iterator)this.server.invoke(new ObjectName(":service=ContainerFactory"), "getDeployedApplications", new Object[0], new String[0]);
        }
        catch (JMException x) {
            this.log.warn("getDeployedApplications", x);
            return null;
        }
        ArrayList<BeanCacheSnapshot> cacheSnapshots = new ArrayList<BeanCacheSnapshot>();
        while (applications.hasNext()) {
            Application app = (Application)applications.next();
            String name = app.getName();
            Iterator containers = app.getContainers().iterator();
            while (containers.hasNext()) {
                InstanceCache cache = null;
                Object container = containers.next();
                if (container instanceof EntityContainer) {
                    cache = ((EntityContainer)container).getInstanceCache();
                } else if (container instanceof StatefulSessionContainer) {
                    cache = ((StatefulSessionContainer)container).getInstanceCache();
                }
                if (!(cache instanceof Monitorable)) continue;
                BeanCacheSnapshot snapshot = new BeanCacheSnapshot();
                snapshot.m_application = name;
                snapshot.m_container = ((Container)container).getBeanMetaData().getEjbName();
                ((Monitorable)((Object)cache)).sample(snapshot);
                cacheSnapshots.add(snapshot);
            }
        }
        return cacheSnapshots.toArray(new BeanCacheSnapshot[0]);
    }
}

