/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class MessageDrivenMetaData
extends BeanMetaData {
    public static final int AUTO_ACKNOWLEDGE_MODE = 1;
    public static final int DUPS_OK_ACKNOWLEDGE_MODE = 3;
    public static final int CLIENT_ACKNOWLEDGE_MODE = 2;
    public static final byte DURABLE_SUBSCRIPTION = 0;
    public static final byte NON_DURABLE_SUBSCRIPTION = 1;
    public static final byte TX_UNSET = 9;
    private int acknowledgeMode = 1;
    private String destinationType;
    private byte subscriptionDurability = 1;
    private byte methodTransactionType = (byte)9;
    private String messageSelector = null;
    private String destinationJndiName;
    private String user = null;
    private String passwd = null;
    private String clientId = null;

    public MessageDrivenMetaData(ApplicationMetaData app) {
        super(app, 'M');
    }

    public int getAcknowledgeMode() {
        if (this.getMethodTransactionType() == 1) {
            return 2;
        }
        return this.acknowledgeMode;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getDefaultConfigurationName() {
        return this.jdk13Enabled() ? "Standard Message Driven Bean" : "jdk1.2.2 Message Driven Bean";
    }

    public String getDestinationJndiName() {
        return this.destinationJndiName;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public byte getMethodTransactionType() {
        if (this.methodTransactionType == 9) {
            Class[] empty;
            this.methodTransactionType = this.isContainerManagedTx() ? (super.getMethodTransactionType("onMessage", empty = new Class[0], true) == 1 ? (byte)1 : 0) : (byte)6;
        }
        return this.methodTransactionType;
    }

    public byte getMethodTransactionType(String methodName, Class[] params, boolean remote) {
        return this.getMethodTransactionType();
    }

    public String getPasswd() {
        return this.passwd;
    }

    public byte getSubscriptionDurability() {
        return this.subscriptionDurability;
    }

    public String getUser() {
        return this.user;
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        String transactionType;
        super.importEjbJarXml(element);
        this.messageSelector = MetaData.getElementContent(MetaData.getOptionalChild(element, "message-selector"));
        if (this.messageSelector != null) {
            int i = -1;
            while ((i = this.messageSelector.indexOf("\r\n")) >= 0) {
                this.messageSelector = String.valueOf(i == 0 ? "" : this.messageSelector.substring(0, i)) + " " + (i >= this.messageSelector.length() - 2 ? "" : this.messageSelector.substring(i + 2));
            }
            i = -1;
            while ((i = this.messageSelector.indexOf("\r")) >= 0) {
                this.messageSelector = String.valueOf(i == 0 ? "" : this.messageSelector.substring(0, i)) + " " + (i >= this.messageSelector.length() - 1 ? "" : this.messageSelector.substring(i + 1));
            }
            i = -1;
            while ((i = this.messageSelector.indexOf("\n")) >= 0) {
                this.messageSelector = String.valueOf(i == 0 ? "" : this.messageSelector.substring(0, i)) + " " + (i >= this.messageSelector.length() - 1 ? "" : this.messageSelector.substring(i + 1));
            }
            this.messageSelector = this.messageSelector.trim();
            if ("".equals(this.messageSelector)) {
                this.messageSelector = null;
            }
        }
        Element destination = MetaData.getUniqueChild(element, "message-driven-destination");
        this.destinationType = MetaData.getElementContent(MetaData.getUniqueChild(destination, "destination-type"));
        if (this.destinationType.equals("javax.jms.Topic")) {
            String subscr = MetaData.getElementContent(MetaData.getOptionalChild(destination, "subscription-durability"));
            this.subscriptionDurability = subscr.equals("Durable") ? (byte)0 : 1;
        }
        if ((transactionType = MetaData.getElementContent(MetaData.getUniqueChild(element, "transaction-type"))).equals("Bean")) {
            this.containerManagedTx = false;
            String ack = MetaData.getElementContent(MetaData.getUniqueChild(element, "acknowledge-mode"));
            this.acknowledgeMode = ack.equals("Auto-acknowledge") || ack.equals("AUTO_ACKNOWLEDGE") ? 1 : 3;
        } else if (transactionType.equals("Container")) {
            this.containerManagedTx = true;
        } else {
            throw new DeploymentException("transaction type should be 'Bean' or 'Container'");
        }
    }

    public void importJbossXml(Element element) throws DeploymentException {
        super.importJbossXml(element);
        this.destinationJndiName = MetaData.getElementContent(MetaData.getUniqueChild(element, "destination-jndi-name"));
        this.user = MetaData.getElementContent(MetaData.getOptionalChild(element, "mdb-user"));
        this.passwd = MetaData.getElementContent(MetaData.getOptionalChild(element, "mdb-passwd"));
        this.clientId = MetaData.getElementContent(MetaData.getOptionalChild(element, "mdb-client-id"));
    }
}

