/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.client;

import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import org.jboss.jmx.client.RMIClientConnectorImpl;
import org.jboss.jmx.interfaces.JMXConnector;

public class ConnectorFactoryImpl {
    private MBeanServer mServer;

    public ConnectorFactoryImpl(MBeanServer pServer) {
        this.mServer = pServer;
    }

    public JMXConnector createConnection(ConnectorName pConnector) {
        RMIClientConnectorImpl lConnector;
        block2: {
            lConnector = null;
            if (!pConnector.getProtocol().equals("rmi")) break block2;
            try {
                lConnector = new RMIClientConnectorImpl(pConnector.getServer());
                this.mServer.registerMBean(lConnector, new ObjectName("DefaultDomain:name=RMIConnectorTo" + pConnector.getServer()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return lConnector;
    }

    public Iterator getConnectors(Hashtable pProperties, IConnectorTester pTester) {
        Vector<ConnectorName> lConnectors = new Vector<ConnectorName>();
        try {
            InitialContext lNamingServer = new InitialContext(pProperties);
            NamingEnumeration<NameClassPair> namingEnumeration = lNamingServer.list("");
            while (namingEnumeration.hasMore()) {
                NameClassPair lItem = namingEnumeration.next();
                ConnectorName lName = pTester.check(lItem.getName(), lItem.getClass());
                if (lName == null) continue;
                lConnectors.add(lName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((AbstractList)lConnectors).iterator();
    }

    public void removeConnection(ConnectorName pConnector) {
        block4: {
            if (!pConnector.getProtocol().equals("rmi")) break block4;
            try {
                Set<ObjectInstance> lConnectors = this.mServer.queryMBeans(new ObjectName("DefaultDomain:name=RMIConnectorTo" + pConnector.getServer()), null);
                if (!lConnectors.isEmpty()) {
                    Iterator<ObjectInstance> i = lConnectors.iterator();
                    while (i.hasNext()) {
                        ObjectInstance lConnector = i.next();
                        this.mServer.invoke(lConnector.getObjectName(), "stop", new Object[0], new String[0]);
                        this.mServer.unregisterMBean(lConnector.getObjectName());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface IConnectorTester {
        public ConnectorName check(String var1, Class var2);
    }

    public static class JBossConnectorTester
    implements IConnectorTester {
        public ConnectorName check(String pName, Class pClass) {
            StringTokenizer lName;
            ConnectorName lConnector = null;
            if ((pName != null || pName.length() > 0) && (lName = new StringTokenizer(pName, ":")).hasMoreTokens() && lName.nextToken().equals("jmx") && lName.hasMoreTokens()) {
                String lServer = lName.nextToken();
                if (lName.hasMoreTokens()) {
                    lConnector = new ConnectorName(lServer, lName.nextToken(), pName);
                }
            }
            return lConnector;
        }
    }

    public static class ConnectorName {
        private String mServer;
        private String mProtocol;
        private String mJNDIName;

        public ConnectorName(String pServer, String pProtocol, String pJNDIName) {
            this.mServer = pServer;
            this.mProtocol = pProtocol;
            this.mJNDIName = pJNDIName;
        }

        public String getJNDIName() {
            return this.mJNDIName;
        }

        public String getProtocol() {
            return this.mProtocol;
        }

        public String getServer() {
            return this.mServer;
        }

        public String toString() {
            return "ConnectorName [ server: " + this.mServer + ", protocol: " + this.mProtocol + ", JNDI name: " + this.mJNDIName + " ]";
        }
    }
}

