/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.jndi;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.configuration.ConfigurationException;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.jms.jndi.JMSProviderLoaderMBean;
import org.jboss.naming.Util;
import org.jboss.util.ServiceMBeanSupport;

public class JMSProviderLoader
extends ServiceMBeanSupport
implements JMSProviderLoaderMBean {
    protected JMSProviderAdapter providerAdapter;
    protected String url;
    protected String providerName;
    protected String providerAdapterClass;
    protected String queueFactoryRef;
    protected String topicFactoryRef;

    public String getName() {
        return this.providerName;
    }

    public ObjectName getObjectName(MBeanServer parm1, ObjectName parm2) throws MalformedObjectNameException {
        return parm2 == null ? new ObjectName(":service=JMSProviderLoader") : parm2;
    }

    public String getProviderAdapterClass() {
        return this.providerAdapterClass;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getProviderUrl() {
        return this.url;
    }

    public String getQueueFactoryRef() {
        return this.queueFactoryRef;
    }

    public String getTopicFactoryRef() {
        return this.topicFactoryRef;
    }

    public void initService() throws Exception {
        if (this.queueFactoryRef == null) {
            throw new ConfigurationException("missing required attribute: QueueFactoryRef");
        }
        if (this.topicFactoryRef == null) {
            throw new ConfigurationException("missing required attribute: TopicFactoryRef");
        }
        Class<?> cls = Class.forName(this.providerAdapterClass);
        this.providerAdapter = (JMSProviderAdapter)cls.newInstance();
        this.providerAdapter.setName(this.providerName);
        this.providerAdapter.setProviderUrl(this.url);
        this.providerAdapter.setQueueFactoryRef(this.queueFactoryRef);
        this.providerAdapter.setTopicFactoryRef(this.topicFactoryRef);
    }

    public void setProviderAdapterClass(String clazz) {
        this.providerAdapterClass = clazz;
    }

    public void setProviderName(String name) {
        this.providerName = name;
    }

    public void setProviderUrl(String url) {
        this.url = url;
    }

    public void setQueueFactoryRef(String newQueueFactoryRef) {
        this.queueFactoryRef = newQueueFactoryRef;
    }

    public void setTopicFactoryRef(String newTopicFactoryRef) {
        this.topicFactoryRef = newTopicFactoryRef;
    }

    public void startService() throws Exception {
        InitialContext context = new InitialContext();
        try {
            String name = this.providerAdapter.getName();
            String jndiname = "java:/" + name;
            Util.bind((Context)context, jndiname, (Object)this.providerAdapter);
            this.log.info("bound adapter " + name + " to " + jndiname);
        }
        finally {
            Object var3_4 = null;
            context.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopService() {
        InitialContext context = null;
        try {
            try {
                context = new InitialContext();
                String name = this.providerAdapter.getName();
                String jndiname = "java:/" + name;
                context.unbind(jndiname);
                this.log.info("unbound adapter " + name + " from " + jndiname);
            }
            catch (Exception e) {
                this.log.warn("failed to unbind; ignoring", e);
            }
            Object var3_5 = null;
            if (context == null) return;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            if (context == null) throw throwable;
            try {
                context.close();
                throw throwable;
            }
            catch (NamingException namingException) {}
            throw throwable;
        }
        try {
            context.close();
            return;
        }
        catch (NamingException namingException) {}
    }
}

