/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.asf;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.jms.XASession;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.jms.asf.StdServerSessionPool;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionManagerService;
import org.jboss.tm.XidImpl;

public class StdServerSession
implements Runnable,
ServerSession,
MessageListener {
    static Logger log = Logger.getLogger(class$org$jboss$jms$asf$StdServerSession != null ? class$org$jboss$jms$asf$StdServerSession : (class$org$jboss$jms$asf$StdServerSession = StdServerSession.class$("org.jboss.jms.asf.StdServerSession")));
    private StdServerSessionPool serverSessionPool;
    private Session session;
    private XASession xaSession;
    private TransactionManager tm;
    private boolean useLocalTX;
    private MessageListener delegateListener;
    static /* synthetic */ Class class$org$jboss$jms$asf$StdServerSession;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    StdServerSession(StdServerSessionPool pool, Session session, XASession xaSession, MessageListener delegateListener, boolean useLocalTX) throws JMSException {
        this.serverSessionPool = pool;
        this.session = session;
        this.xaSession = xaSession;
        this.delegateListener = delegateListener;
        if (xaSession == null) {
            useLocalTX = false;
        }
        this.useLocalTX = useLocalTX;
        log.debug("initializing (pool, session, xaSession, useLocalTX): " + pool + ", " + session + ", " + xaSession + ", " + useLocalTX);
        if (xaSession != null) {
            xaSession.setMessageListener((MessageListener)this);
        } else {
            session.setMessageListener((MessageListener)this);
        }
        InitialContext ctx = null;
        try {
            try {
                ctx = new InitialContext();
                this.tm = (TransactionManager)ctx.lookup(TransactionManagerService.JNDI_NAME);
            }
            catch (Exception exception) {
                throw new JMSException("Transation manager was not found");
            }
            Object var8_7 = null;
            if (ctx == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (ctx == null) throw throwable;
            try {
                ctx.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            ctx.close();
            return;
        }
        catch (Exception exception) {}
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {}
            this.session = null;
        }
        if (this.xaSession != null) {
            try {
                this.xaSession.close();
            }
            catch (Exception exception) {}
            this.xaSession = null;
        }
        log.debug("closed");
    }

    public Session getSession() throws JMSException {
        if (this.xaSession != null) {
            return this.xaSession;
        }
        return this.session;
    }

    public void onMessage(Message msg) {
        XAResource res;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("onMessage running (pool, session, xaSession, useLocalTX): , " + this.session + ", " + this.xaSession + ", " + this.useLocalTX);
        }
        XidImpl localXid = null;
        boolean localRollbackFlag = false;
        Transaction trans = null;
        try {
            try {
                if (this.useLocalTX) {
                    localXid = new XidImpl();
                    res = this.xaSession.getXAResource();
                    res.start(localXid, 0);
                    if (trace) {
                        log.trace("Using optimized 1p commit to control TX.");
                    }
                } else {
                    this.tm.begin();
                    trans = this.tm.getTransaction();
                    if (this.xaSession != null) {
                        res = this.xaSession.getXAResource();
                        trans.enlistResource(res);
                        if (trace) {
                            log.trace("XAResource '" + res + "' enlisted.");
                        }
                    }
                }
                this.delegateListener.onMessage(msg);
            }
            catch (Exception e) {
                log.error("session failed to run; setting rollback only", e);
                if (this.useLocalTX) {
                    localRollbackFlag = true;
                }
                try {
                    if (trace) {
                        log.trace("Using TM to mark TX for rollback.");
                    }
                    trans.setRollbackOnly();
                }
                catch (Exception x) {
                    log.error("failed to set rollback only", x);
                }
            }
            Object var7_12 = null;
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            try {
                if (this.useLocalTX) {
                    if (localRollbackFlag) {
                        if (trace) {
                            log.trace("Using optimized 1p commit to rollback TX.");
                        }
                        XAResource res2 = this.xaSession.getXAResource();
                        res2.end(localXid, 0x4000000);
                        res2.rollback(localXid);
                    } else {
                        if (trace) {
                            log.trace("Using optimized 1p commit to commit TX.");
                        }
                        XAResource res3 = this.xaSession.getXAResource();
                        res3.end(localXid, 0x4000000);
                        res3.commit(localXid, true);
                    }
                } else if (trans.getStatus() == 1) {
                    if (trace) {
                        log.trace("Rolling back JMS transaction");
                    }
                    trans.rollback();
                    if (this.xaSession == null && this.serverSessionPool.isTransacted()) {
                        this.session.rollback();
                    }
                } else if (trans.getStatus() == 0) {
                    if (trace) {
                        log.trace("Commiting the JMS transaction");
                    }
                    trans.commit();
                    if (this.xaSession == null && this.serverSessionPool.isTransacted()) {
                        this.session.commit();
                    }
                }
            }
            catch (Exception e) {
                log.error("failed to commit/rollback", e);
            }
            this.recycle();
            throw throwable;
        }
        try {
            if (this.useLocalTX) {
                if (localRollbackFlag) {
                    if (trace) {
                        log.trace("Using optimized 1p commit to rollback TX.");
                    }
                    res = this.xaSession.getXAResource();
                    res.end(localXid, 0x4000000);
                    res.rollback(localXid);
                } else {
                    if (trace) {
                        log.trace("Using optimized 1p commit to commit TX.");
                    }
                    res = this.xaSession.getXAResource();
                    res.end(localXid, 0x4000000);
                    res.commit(localXid, true);
                }
            } else if (trans.getStatus() == 1) {
                if (trace) {
                    log.trace("Rolling back JMS transaction");
                }
                trans.rollback();
                if (this.xaSession == null && this.serverSessionPool.isTransacted()) {
                    this.session.rollback();
                }
            } else if (trans.getStatus() == 0) {
                if (trace) {
                    log.trace("Commiting the JMS transaction");
                }
                trans.commit();
                if (this.xaSession == null && this.serverSessionPool.isTransacted()) {
                    this.session.commit();
                }
            }
        }
        catch (Exception e) {
            log.error("failed to commit/rollback", e);
        }
        this.recycle();
        if (trace) {
            log.trace("onMessage done");
        }
    }

    void recycle() {
        this.serverSessionPool.recycle(this);
    }

    public void run() {
        if (log.isTraceEnabled()) {
            log.trace("running...");
        }
        if (this.xaSession != null) {
            this.xaSession.run();
        } else {
            this.session.run();
        }
    }

    public void start() throws JMSException {
        if (log.isTraceEnabled()) {
            log.trace("starting invokes on server session");
        }
        if (this.session != null) {
            try {
                this.serverSessionPool.getExecutor().execute((Runnable)this);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            throw new JMSException("No listener has been specified");
        }
    }
}

