/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.asf;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.jms.asf.ServerSessionPoolFactory;
import org.jboss.jms.asf.ServerSessionPoolLoaderMBean;
import org.jboss.naming.Util;
import org.jboss.util.ServiceMBeanSupport;

public class ServerSessionPoolLoader
extends ServiceMBeanSupport
implements ServerSessionPoolLoaderMBean {
    private ServerSessionPoolFactory poolFactory;
    private String name;
    private String poolFactoryClass;

    public String getName() {
        return this.name;
    }

    public ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? new ObjectName(":service=ServerSessionPoolMBean") : name;
    }

    public String getPoolFactoryClass() {
        return this.poolFactoryClass;
    }

    public String getPoolName() {
        return this.name;
    }

    public void setPoolFactoryClass(String classname) {
        this.poolFactoryClass = classname;
    }

    public void setPoolName(String name) {
        this.name = name;
    }

    protected void startService() throws Exception {
        Class<?> cls = Class.forName(this.poolFactoryClass);
        this.poolFactory = (ServerSessionPoolFactory)cls.newInstance();
        this.poolFactory.setName(this.name);
        this.log.debug("initialized with pool factory: " + this.poolFactory);
        InitialContext ctx = new InitialContext();
        String name = this.poolFactory.getName();
        String jndiname = "java:/" + name;
        try {
            Util.bind((Context)ctx, jndiname, (Object)this.poolFactory);
            this.log.info("pool factory " + name + " bound to " + jndiname);
        }
        finally {
            Object var6_5 = null;
            ctx.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void stopService() {
        InitialContext ctx = null;
        try {
            try {
                ctx = new InitialContext();
                String name = this.poolFactory.getName();
                String jndiname = "java:/" + name;
                ctx.unbind(jndiname);
                this.log.info("pool factory " + name + " unbound from " + jndiname);
            }
            catch (NamingException namingException) {
            }
            Object var3_4 = null;
            if (ctx == null) return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (ctx == null) throw throwable;
            try {
                ctx.close();
                throw throwable;
            }
            catch (NamingException namingException) {}
            throw throwable;
        }
        try {
            ctx.close();
            return;
        }
        catch (NamingException namingException) {}
    }
}

