/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdbc;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.jdbc.JDBCDataSourceLoaderMBean;
import org.jboss.logging.log4j.CategoryWriter;
import org.jboss.pool.jdbc.JDBCPoolDataSource;
import org.jboss.util.ServiceMBeanSupport;

public class JDBCDataSourceLoader
extends ServiceMBeanSupport
implements JDBCDataSourceLoaderMBean {
    private JDBCPoolDataSource source = new JDBCPoolDataSource();

    public JDBCDataSourceLoader() {
    }

    public JDBCDataSourceLoader(String poolName) {
        this.source.setPoolName(poolName);
    }

    private static void addProperty(Properties props, String property) {
        int pos = property.indexOf("=");
        if (pos < 0) {
            System.err.println("Unable to parse property '" + property + "' - please use 'name=value'");
            return;
        }
        props.setProperty(property.substring(0, pos), property.substring(pos + 1));
    }

    private void bind(Context ctx, String name, Object val) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException nameNotFoundException) {
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        ctx.bind(n.get(0), val);
    }

    private static String buildProperties(Properties props) {
        StringBuffer buf = new StringBuffer();
        Iterator it = ((Hashtable)props).keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (buf.length() > 0) {
                buf.append(';');
            }
            buf.append(key).append('=').append(((Hashtable)props).get(key));
        }
        return buf.toString();
    }

    public long getGCInterval() {
        return this.source.getGCInterval();
    }

    public long getGCMinIdleTime() {
        return this.source.getGCMinIdleTime();
    }

    public long getIdleTimeout() {
        return this.source.getIdleTimeout();
    }

    public String getJDBCUser() {
        return this.source.getJDBCUser();
    }

    public float getMaxIdleTimeoutPercent() {
        return this.source.getMaxIdleTimeoutPercent();
    }

    public int getMaxSize() {
        return this.source.getMaxSize();
    }

    public int getMinSize() {
        return this.source.getMinSize();
    }

    public String getName() {
        return "JDBCDataSource";
    }

    public ObjectName getObjectName(MBeanServer parm1, ObjectName parm2) throws MalformedObjectNameException {
        return new ObjectName(":service=JDBCDataSource,name=" + this.source.getJNDIName());
    }

    public String getPassword() {
        return this.source.getJDBCPassword();
    }

    public String getPoolName() {
        return this.source.getPoolName();
    }

    public String getProperties() {
        Properties props = this.source.getJDBCProperties();
        return props == null ? null : JDBCDataSourceLoader.buildProperties(props);
    }

    public String getURL() {
        return this.source.getJDBCURL();
    }

    private void initializePool() throws NamingException, SQLException {
        this.source.initialize();
        this.bind(new InitialContext(), "java:/" + this.source.getPoolName(), this.source);
        this.log.info("JDBC Connection pool " + this.source.getPoolName() + " bound to java:/" + this.source.getPoolName());
        this.source.getConnection().close();
    }

    public boolean isBlocking() {
        return this.source.isBlocking();
    }

    public boolean isGCEnabled() {
        return this.source.isGCEnabled();
    }

    public boolean isIdleTimeoutEnabled() {
        return this.source.isIdleTimeoutEnabled();
    }

    public boolean isInvalidateOnError() {
        return this.source.isInvalidateOnError();
    }

    public boolean isLoggingEnabled() {
        try {
            return this.source.getLogWriter() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isTimestampUsed() {
        return this.source.isTimestampUsed();
    }

    private static Properties parseProperties(String string) {
        Properties props = new Properties();
        if (string == null || string.length() == 0) {
            return props;
        }
        int lastPos = -1;
        int pos = string.indexOf(";");
        while (pos > -1) {
            JDBCDataSourceLoader.addProperty(props, string.substring(lastPos + 1, pos));
            lastPos = pos;
            pos = string.indexOf(";", lastPos + 1);
        }
        JDBCDataSourceLoader.addProperty(props, string.substring(lastPos + 1));
        return props;
    }

    public void setBlocking(boolean blocking) {
        this.source.setBlocking(blocking);
    }

    public void setGCEnabled(boolean gcEnabled) {
        this.source.setGCEnabled(gcEnabled);
    }

    public void setGCInterval(long interval) {
        this.source.setGCInterval(interval);
    }

    public void setGCMinIdleTime(long idleMillis) {
        this.source.setGCMinIdleTime(idleMillis);
    }

    public void setIdleTimeout(long idleMillis) {
        this.source.setIdleTimeout(idleMillis);
    }

    public void setIdleTimeoutEnabled(boolean enabled) {
        this.source.setIdleTimeoutEnabled(enabled);
    }

    public void setInvalidateOnError(boolean invalidate) {
        this.source.setInvalidateOnError(invalidate);
    }

    public void setJDBCUser(String userName) {
        if (userName != null && userName.length() > 0) {
            this.source.setJDBCUser(userName);
        }
    }

    public void setLoggingEnabled(boolean enabled) {
        CategoryWriter writer = enabled ? new CategoryWriter(this.log.getCategory()) : null;
        try {
            this.source.setLogWriter((PrintWriter)writer);
        }
        catch (Exception exception) {
            System.out.println("Unable to set logger for Minerva JDBC Pool!");
        }
    }

    public void setMaxIdleTimeoutPercent(float percent) {
        this.source.setMaxIdleTimeoutPercent(percent);
    }

    public void setMaxSize(int maxSize) {
        this.source.setMaxSize(maxSize);
    }

    public void setMinSize(int minSize) {
        this.source.setMinSize(minSize);
    }

    public void setPassword(String password) {
        if (password != null && password.length() > 0) {
            this.source.setJDBCPassword(password);
        }
    }

    public void setPoolName(String name) {
        this.source.setPoolName(name);
    }

    public void setProperties(String properties) {
        Properties props = JDBCDataSourceLoader.parseProperties(properties);
        this.source.setJDBCProperties(props);
    }

    public void setTimestampUsed(boolean timestamp) {
        this.source.setTimestampUsed(timestamp);
    }

    public void setURL(String jdbcURL) {
        this.source.setJDBCURL(jdbcURL);
    }

    public void startService() throws Exception {
        this.initializePool();
    }

    public void stopService() {
        try {
            String name = this.source.getPoolName();
            new InitialContext().unbind("java:/" + name);
            this.log.info("JDBC Connection pool " + name + " removed from JNDI");
            this.source.close();
            this.log.info("JDBC Connection pool " + name + " shut down");
        }
        catch (NamingException namingException) {}
    }
}

