/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.lock;

import java.util.HashMap;
import java.util.LinkedList;
import javax.transaction.Transaction;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.plugins.lock.BeanLockSupport;

public class QueuedPessimisticEJBLock
extends BeanLockSupport {
    private Object methodLock = new Object();
    private HashMap txLocks = new HashMap();
    private LinkedList txWaitQueue = new LinkedList();
    private int txIdGen = 0;

    protected boolean attemptMethodLock(MethodInvocation mi, boolean trace) throws Exception {
        if (this.isMethodLocked()) {
            if (!this.isCallAllowed(mi)) {
                if (trace) {
                    BeanLockSupport.log.trace("Thread contention on methodLock, Begin lock.wait(), id=" + mi.getId());
                }
                Object object = this.methodLock;
                synchronized (object) {
                    this.releaseSync();
                    try {
                        this.methodLock.wait(this.txTimeout);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.sync();
                if (trace) {
                    BeanLockSupport.log.trace("End lock.wait(), id=" + mi.getId() + ", isLocked=" + this.isMethodLocked());
                }
                return false;
            }
            this.addMethodLock();
        } else {
            this.addMethodLock();
        }
        return true;
    }

    protected boolean doSchedule(MethodInvocation mi) throws Exception {
        boolean wasThreadScheduled = false;
        Transaction miTx = mi.getTransaction();
        boolean trace = BeanLockSupport.log.isTraceEnabled();
        this.sync();
        try {
            if (trace) {
                BeanLockSupport.log.trace("Begin schedule, key=" + mi.getId());
            }
            if (this.isTxExpired(miTx)) {
                BeanLockSupport.log.error("Saw rolled back tx=" + miTx);
                throw new RuntimeException("Transaction marked for rollback, possibly a timeout");
            }
            wasThreadScheduled = this.waitForTx(miTx, trace);
            try {
                boolean acquiredMethodLock = false;
                while (!acquiredMethodLock) {
                    acquiredMethodLock = this.attemptMethodLock(mi, trace);
                    if (acquiredMethodLock) continue;
                    if (miTx != null) {
                        if (!this.isTxExpired(miTx)) continue;
                        BeanLockSupport.log.error("Saw rolled back tx=" + miTx + " waiting for methodLock.");
                        throw new RuntimeException("Transaction marked for rollback, possibly a timeout");
                    }
                    boolean bl = false;
                    Object var7_8 = null;
                    if (miTx == null && wasThreadScheduled) {
                        this.nextTransaction();
                    }
                    this.releaseSync();
                    return bl;
                }
            }
            catch (Exception ex) {
                if (miTx != null) {
                    this.nextTransaction();
                }
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (miTx == null && wasThreadScheduled) {
                this.nextTransaction();
            }
            this.releaseSync();
            throw throwable;
        }
        Object var7_9 = null;
        if (miTx == null && wasThreadScheduled) {
            this.nextTransaction();
        }
        this.releaseSync();
        return true;
    }

    public void endTransaction(Transaction transaction) {
        this.nextTransaction();
    }

    protected TxLock getTxLock(Transaction miTx) {
        TxLock lock = null;
        if (miTx == null) {
            lock = new TxLock(null);
            this.txWaitQueue.addLast(lock);
        } else {
            TxLock key = new TxLock(miTx);
            lock = (TxLock)this.txLocks.get(key);
            if (lock == null) {
                this.txLocks.put(key, key);
                this.txWaitQueue.addLast(key);
                lock = key;
            }
        }
        return lock;
    }

    protected boolean isTxExpired(Transaction miTx) throws Exception {
        return miTx != null && miTx.getStatus() == 1;
    }

    protected void nextTransaction() {
        if (!this.synched) {
            throw new IllegalStateException("do not call nextTransaction while not synched!");
        }
        this.tx = null;
        if (!this.txWaitQueue.isEmpty()) {
            TxLock thelock = (TxLock)this.txWaitQueue.removeFirst();
            this.txLocks.remove(thelock);
            thelock.isQueued = false;
            if (thelock.tx != null) {
                this.removeWaiting(thelock.tx);
            }
            this.tx = thelock.tx;
            TxLock txLock = thelock;
            synchronized (txLock) {
                thelock.notifyAll();
            }
        }
    }

    public void releaseMethodLock() {
        --this.numMethodLocks;
        if (this.numMethodLocks == 0) {
            Object object = this.methodLock;
            synchronized (object) {
                this.methodLock.notify();
            }
        }
    }

    public void removeRef() {
        --this.refs;
        if (this.refs == 0 && this.txWaitQueue.size() > 0) {
            BeanLockSupport.log.error("removing bean lock and it has tx's in QUEUE! " + this.toString());
            throw new IllegalStateException("removing bean lock and it has tx's in QUEUE!");
        }
        if (this.refs == 0 && this.tx != null) {
            BeanLockSupport.log.error("removing bean lock and it has tx set! " + this.toString());
            throw new IllegalStateException("removing bean lock and it has tx set!");
        }
    }

    public void schedule(MethodInvocation mi) throws Exception {
        boolean threadScheduled = false;
        while (!threadScheduled) {
            threadScheduled = this.doSchedule(mi);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("QPL id=").append(this.id);
        buffer.append(" tx=").append(this.tx);
        buffer.append(" synched=").append(this.synched);
        buffer.append(" timeout=").append(this.txTimeout);
        buffer.append(" queue=").append(this.txWaitQueue);
        return buffer.toString();
    }

    protected boolean waitForTx(Transaction miTx, boolean trace) throws Exception {
        boolean wasScheduled = false;
        TxLock txLock = null;
        while (this.tx != null && !this.tx.equals(miTx)) {
            try {
                this.deadlockDetection(miTx);
            }
            catch (Exception e) {
                if (txLock != null && txLock.isQueued) {
                    this.txLocks.remove(txLock);
                    this.txWaitQueue.remove(txLock);
                }
                throw e;
            }
            wasScheduled = true;
            if (trace) {
                BeanLockSupport.log.trace("Transactional contention on context" + this.id);
            }
            if (txLock == null) {
                txLock = this.getTxLock(miTx);
            }
            if (trace) {
                BeanLockSupport.log.trace("Begin wait on Tx=" + this.tx);
            }
            Object object = txLock;
            synchronized (object) {
                this.releaseSync();
                try {
                    txLock.wait(this.txTimeout);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.sync();
            if (trace) {
                BeanLockSupport.log.trace("End wait on TxLock=" + this.tx);
            }
            if (!this.isTxExpired(miTx)) continue;
            BeanLockSupport.log.error(String.valueOf(String.valueOf(Thread.currentThread())) + "Saw rolled back tx=" + miTx + " waiting for txLock");
            if (txLock.isQueued) {
                this.txLocks.remove(txLock);
                this.txWaitQueue.remove(txLock);
            } else if (this.tx != null && this.tx.equals(miTx)) {
                this.nextTransaction();
            }
            if (miTx != null) {
                object = BeanLockSupport.waiting;
                synchronized (object) {
                    BeanLockSupport.waiting.remove(miTx);
                }
            }
            throw new RuntimeException("Transaction marked for rollback, possibly a timeout");
        }
        this.tx = miTx;
        return wasScheduled;
    }

    public void wontSynchronize(Transaction trasaction) {
        this.nextTransaction();
    }

    private class TxLock {
        public Transaction tx = null;
        public int id = 0;
        public String threadName = Thread.currentThread().toString();
        public boolean isQueued;

        public TxLock(Transaction tx) {
            this.tx = tx;
            if (tx == null) {
                if (QueuedPessimisticEJBLock.this.txIdGen < 0) {
                    QueuedPessimisticEJBLock.this.txIdGen = 0;
                }
                QueuedPessimisticEJBLock queuedPessimisticEJBLock = QueuedPessimisticEJBLock.this;
                int n = queuedPessimisticEJBLock.txIdGen;
                queuedPessimisticEJBLock.txIdGen = n + 1;
                this.id = n;
            }
            this.isQueued = true;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            TxLock lock = (TxLock)obj;
            if (lock.tx == null && this.tx == null) {
                return lock.id == this.id;
            }
            if (lock.tx != null && this.tx != null) {
                return lock.tx.equals(this.tx);
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append("TXLOCK waitingTx=").append(this.tx);
            buffer.append(" id=").append(this.id);
            buffer.append(" thread=").append(this.threadName);
            buffer.append(" queued=").append(this.isQueued);
            return buffer.toString();
        }
    }
}

