/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.lock;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import javax.transaction.Transaction;
import org.jboss.ejb.BeanLock;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.plugins.lock.ApplicationDeadlockException;
import org.jboss.logging.Logger;

public abstract class BeanLockSupport
implements BeanLock {
    protected int numMethodLocks = 0;
    protected int refs = 0;
    protected Object id = null;
    protected boolean reentrant;
    static Logger log = Logger.getLogger(class$org$jboss$ejb$BeanLock != null ? class$org$jboss$ejb$BeanLock : (class$org$jboss$ejb$BeanLock = BeanLockSupport.class$("org.jboss.ejb.BeanLock")));
    protected Transaction tx = null;
    protected boolean synched = false;
    protected int txTimeout;
    private static final Method getEJBHome;
    private static final Method getHandle;
    private static final Method getPrimaryKey;
    private static final Method isIdentical;
    private static final Method remove;
    protected static HashMap waiting;
    static /* synthetic */ Class class$org$jboss$ejb$BeanLock;
    static /* synthetic */ Class class$javax$ejb$EJBObject;

    static {
        try {
            Class[] noArg = new Class[]{};
            getEJBHome = (class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = BeanLockSupport.class$("javax.ejb.EJBObject"))).getMethod("getEJBHome", noArg);
            getHandle = (class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = BeanLockSupport.class$("javax.ejb.EJBObject"))).getMethod("getHandle", noArg);
            getPrimaryKey = (class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = BeanLockSupport.class$("javax.ejb.EJBObject"))).getMethod("getPrimaryKey", noArg);
            isIdentical = (class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = BeanLockSupport.class$("javax.ejb.EJBObject"))).getMethod("isIdentical", class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = BeanLockSupport.class$("javax.ejb.EJBObject")));
            remove = (class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = BeanLockSupport.class$("javax.ejb.EJBObject"))).getMethod("remove", noArg);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
        waiting = new HashMap();
    }

    public void addMethodLock() {
        ++this.numMethodLocks;
    }

    public void addRef() {
        ++this.refs;
    }

    public void addWaiting(Transaction tx) {
        if (tx == null) {
            throw new IllegalArgumentException("Attempt to addWaiting with a null transaction");
        }
        HashMap hashMap = waiting;
        synchronized (hashMap) {
            waiting.put(tx, this);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void deadlockDetection(Transaction miTx) throws ApplicationDeadlockException {
        if (miTx == null) {
            return;
        }
        HashSet<Object> set = new HashSet<Object>();
        set.add(miTx);
        Object checkTx = this.tx;
        HashMap hashMap = waiting;
        synchronized (hashMap) {
            this.addWaiting(miTx);
            while (checkTx != null) {
                Object waitingFor = waiting.get(checkTx);
                if (waitingFor != null) {
                    waitingFor = ((BeanLock)waitingFor).getTransaction();
                }
                if (waitingFor != null) {
                    if (set.contains(waitingFor)) {
                        log.error("Application deadlock detected: " + miTx + " has deadlock conditions.  Two or more transactions contending for same resources and each have locks each other need.");
                        this.removeWaiting(miTx);
                        throw new ApplicationDeadlockException("Application deadlock detected: Two or more transactions contention.");
                    }
                    set.add(waitingFor);
                }
                checkTx = waitingFor;
            }
        }
    }

    public abstract void endTransaction(Transaction var1);

    public Object getId() {
        return this.id;
    }

    public int getNumMethodLocks() {
        return this.numMethodLocks;
    }

    public int getRefs() {
        return this.refs;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    protected boolean isCallAllowed(MethodInvocation mi) {
        if (this.reentrant) {
            return true;
        }
        Method m = mi.getMethod();
        return m.equals(getEJBHome) || m.equals(getHandle) || m.equals(getPrimaryKey) || m.equals(isIdentical) || m.equals(remove);
    }

    public boolean isMethodLocked() {
        return this.numMethodLocks > 0;
    }

    public abstract void releaseMethodLock();

    public void releaseSync() {
        BeanLockSupport beanLockSupport = this;
        synchronized (beanLockSupport) {
            this.synched = false;
            this.notify();
        }
    }

    public void removeRef() {
        --this.refs;
    }

    public void removeWaiting(Transaction tx) {
        if (tx == null) {
            throw new IllegalArgumentException("Attempt to removeWaiting with a null transaction");
        }
        HashMap hashMap = waiting;
        synchronized (hashMap) {
            waiting.remove(tx);
        }
    }

    public abstract void schedule(MethodInvocation var1) throws Exception;

    public void setId(Object id) {
        this.id = id;
    }

    public void setReentrant(boolean reentrant) {
        this.reentrant = reentrant;
    }

    public void setTimeout(int timeout) {
        this.txTimeout = timeout;
    }

    public void setTransaction(Transaction tx) {
        this.tx = tx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sync() {
        BeanLockSupport beanLockSupport = this;
        synchronized (beanLockSupport) {
            while (true) {
                if (!this.synched) {
                    this.synched = true;
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public abstract void wontSynchronize(Transaction var1);
}

