/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jms;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.AbstractList;
import java.util.Collection;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Container;
import org.jboss.ejb.ContainerInvoker;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.plugins.jms.DLQHandler;
import org.jboss.jms.ConnectionFactoryHelper;
import org.jboss.jms.asf.ServerSessionPoolFactory;
import org.jboss.jms.asf.StdServerSessionPool;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.logging.Logger;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.w3c.dom.Element;

public class JMSContainerInvoker
implements ContainerInvoker,
XmlLoadable {
    protected static Method ON_MESSAGE;
    protected static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Topic";
    protected boolean optimize;
    protected int maxMessagesNr = 1;
    protected int maxPoolSize = 15;
    protected long reconnectInterval = 10000L;
    protected boolean useDLQ = false;
    protected String providerAdapterJNDI;
    protected String serverSessionPoolFactoryJNDI;
    protected int acknowledgeMode;
    protected boolean isContainerManagedTx;
    protected boolean isNotSupportedTx;
    protected Container container;
    protected Connection connection;
    protected ConnectionConsumer connectionConsumer;
    protected TransactionManager tm;
    protected ServerSessionPool pool;
    protected ExceptionListenerImpl exListener;
    protected String beanName;
    protected DLQHandler dlqHandler;
    protected Element dlqConfig;
    private final Logger log = Logger.getLogger(this.getClass());
    static /* synthetic */ Class class$javax$jms$MessageListener;
    static /* synthetic */ Class class$javax$jms$Message;
    static /* synthetic */ Class class$javax$jms$Topic;
    static /* synthetic */ Class class$javax$jms$Queue;

    static {
        try {
            Class type = class$javax$jms$MessageListener != null ? class$javax$jms$MessageListener : (class$javax$jms$MessageListener = JMSContainerInvoker.class$("javax.jms.MessageListener"));
            Class arg = class$javax$jms$Message != null ? class$javax$jms$Message : (class$javax$jms$Message = JMSContainerInvoker.class$("javax.jms.Message"));
            ON_MESSAGE = type.getMethod("onMessage", arg);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected Destination createDestination(Class type, Context ctx, String jndiName, String jndiSuffix) throws Exception {
        try {
            return (Destination)ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            String methodName;
            this.log.warn("destination not found: " + jndiName + " reason: " + e);
            this.log.warn("creating a new temporary destination: " + jndiName);
            MBeanServer server = (MBeanServer)((AbstractList)MBeanServerFactory.findMBeanServer(null)).iterator().next();
            if (type == (class$javax$jms$Topic != null ? class$javax$jms$Topic : (class$javax$jms$Topic = JMSContainerInvoker.class$(DEFAULT_DESTINATION_TYPE)))) {
                methodName = "createTopic";
            } else if (type == (class$javax$jms$Queue != null ? class$javax$jms$Queue : (class$javax$jms$Queue = JMSContainerInvoker.class$("javax.jms.Queue")))) {
                methodName = "createQueue";
            } else {
                throw new IllegalArgumentException("expected javax.jms.Queue or javax.jms.Topic: " + type);
            }
            server.invoke(new ObjectName("JBossMQ", "service", "Server"), methodName, new Object[]{jndiSuffix}, new String[]{"java.lang.String"});
            return (Destination)ctx.lookup(jndiName);
        }
    }

    protected ServerSessionPool createSessionPool(Connection connection, int maxSession, boolean isTransacted, int ack, MessageListener listener) throws NamingException, JMSException {
        ServerSessionPool pool;
        InitialContext context = new InitialContext();
        try {
            this.log.debug("looking up session pool factory: " + this.serverSessionPoolFactoryJNDI);
            ServerSessionPoolFactory factory = (ServerSessionPoolFactory)context.lookup(this.serverSessionPoolFactoryJNDI);
            pool = factory.getServerSessionPool(connection, maxSession, isTransacted, ack, !this.isContainerManagedTx || this.isNotSupportedTx, listener);
        }
        finally {
            Object var9_9 = null;
            context.close();
        }
        return pool;
    }

    public void destroy() {
        block9: {
            this.log.debug("Destroying JMSContainerInvoker for bean " + this.beanName);
            if (this.dlqHandler != null) {
                this.dlqHandler.destroy();
            }
            try {
                if (this.connectionConsumer != null) {
                    this.connectionConsumer.close();
                }
            }
            catch (Exception e) {
                this.log.error("Could not close consumer", e);
            }
            try {
                if (this.pool instanceof StdServerSessionPool) {
                    StdServerSessionPool p = (StdServerSessionPool)this.pool;
                    p.clear();
                }
            }
            catch (Exception e) {
                this.log.error("Could not clear ServerSessionPool", e);
            }
            if (this.connection == null) break block9;
            try {
                this.connection.close();
            }
            catch (Exception e) {
                this.log.error("Could not close connection", e);
            }
        }
    }

    protected String getDestinationType(Context ctx, String destinationJNDI) {
        String destType = null;
        if (destinationJNDI != null) {
            try {
                Destination dest = (Destination)ctx.lookup(destinationJNDI);
                if (dest instanceof Topic) {
                    destType = DEFAULT_DESTINATION_TYPE;
                } else if (dest instanceof Queue) {
                    destType = "javax.jms.Queue";
                }
            }
            catch (NamingException ex) {
                this.log.debug("Could not do heristic lookup of destination ", ex);
            }
        }
        if (destType == null) {
            this.log.info("WARNING Could not determine destination type, defaults to: javax.jms.Topic");
            destType = DEFAULT_DESTINATION_TYPE;
        }
        return destType;
    }

    public EJBHome getEJBHome() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public EJBMetaData getEJBMetaData() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Collection getEntityCollection(Collection ids) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public EJBObject getEntityEJBObject(Object id) {
        throw new Error("Not valid for MessageDriven beans");
    }

    protected JMSProviderAdapter getJMSProviderAdapter() throws NamingException {
        JMSProviderAdapter jMSProviderAdapter;
        InitialContext context = new InitialContext();
        try {
            this.log.debug("looking up provider adapter: " + this.providerAdapterJNDI);
            jMSProviderAdapter = (JMSProviderAdapter)context.lookup(this.providerAdapterJNDI);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return jMSProviderAdapter;
    }

    public EJBObject getStatefulSessionEJBObject(Object id) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public EJBObject getStatelessSessionEJBObject() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public void importXml(Element element) throws DeploymentException {
        try {
            String maxMessages = MetaData.getElementContent(MetaData.getUniqueChild(element, "MaxMessages"));
            this.maxMessagesNr = Integer.parseInt(maxMessages);
            String maxSize = MetaData.getElementContent(MetaData.getUniqueChild(element, "MaximumSize"));
            this.maxPoolSize = Integer.parseInt(maxSize);
            Element mdbConfig = MetaData.getUniqueChild(element, "MDBConfig");
            String reconnect = MetaData.getElementContent(MetaData.getUniqueChild(mdbConfig, "ReconnectIntervalSec"));
            this.reconnectInterval = Long.parseLong(reconnect) * 1000L;
            Element dlqEl = MetaData.getOptionalChild(mdbConfig, "DLQConfig");
            if (dlqEl != null) {
                this.dlqConfig = (Element)dlqEl.cloneNode(true);
                this.useDLQ = true;
            } else {
                this.useDLQ = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (DeploymentException deploymentException) {}
        this.providerAdapterJNDI = MetaData.getElementContent(MetaData.getUniqueChild(element, "JMSProviderAdapterJNDI"));
        this.serverSessionPoolFactoryJNDI = MetaData.getElementContent(MetaData.getUniqueChild(element, "ServerSessionPoolFactoryJNDI"));
        if (!this.providerAdapterJNDI.startsWith("java:/")) {
            this.providerAdapterJNDI = "java:/" + this.providerAdapterJNDI;
        }
        if (!this.serverSessionPoolFactoryJNDI.startsWith("java:/")) {
            this.serverSessionPoolFactoryJNDI = "java:/" + this.serverSessionPoolFactoryJNDI;
        }
    }

    public void init() throws Exception {
        this.log.debug("initializing");
        if (this.useDLQ) {
            this.dlqHandler = new DLQHandler();
            this.dlqHandler.importXml(this.dlqConfig);
            this.dlqHandler.init();
        }
        this.tm = this.container.getTransactionManager();
        MessageDrivenMetaData config = (MessageDrivenMetaData)this.container.getBeanMetaData();
        String messageSelector = config.getMessageSelector();
        String destinationType = config.getDestinationType();
        this.beanName = config.getEjbName();
        this.isContainerManagedTx = config.isContainerManagedTx();
        this.acknowledgeMode = config.getAcknowledgeMode();
        this.isNotSupportedTx = config.getMethodTransactionType("onMessage", new Class[]{class$javax$jms$Message != null ? class$javax$jms$Message : (class$javax$jms$Message = JMSContainerInvoker.class$("javax.jms.Message"))}, false) == 0;
        String destinationJNDI = config.getDestinationJndiName();
        String user = config.getUser();
        String password = config.getPasswd();
        JMSProviderAdapter adapter = this.getJMSProviderAdapter();
        this.log.debug("provider adapter: " + adapter);
        Context context = adapter.getInitialContext();
        this.log.debug("context: " + context);
        if (context == null) {
            throw new RuntimeException("Failed to get the root context");
        }
        String jndiSuffix = this.parseJndiSuffix(destinationJNDI, config.getEjbName());
        this.log.debug("jndiSuffix: " + jndiSuffix);
        if (destinationType == null) {
            this.log.info("No message-driven-destination given, guessing type");
            destinationType = this.getDestinationType(context, destinationJNDI);
        }
        if (destinationType.equals(DEFAULT_DESTINATION_TYPE)) {
            this.log.debug("Got destination type Topic for " + config.getEjbName());
            Object factory = context.lookup(adapter.getTopicFactoryRef());
            TopicConnection tConnection = ConnectionFactoryHelper.createTopicConnection(factory, user, password);
            this.connection = tConnection;
            Topic topic = (Topic)this.createDestination(class$javax$jms$Topic != null ? class$javax$jms$Topic : (class$javax$jms$Topic = JMSContainerInvoker.class$(DEFAULT_DESTINATION_TYPE)), context, "topic/" + jndiSuffix, jndiSuffix);
            this.pool = this.createSessionPool((Connection)tConnection, this.maxPoolSize, true, this.acknowledgeMode, new MessageListenerImpl(this));
            if (config.getSubscriptionDurability() != 0) {
                this.connectionConsumer = tConnection.createConnectionConsumer(topic, messageSelector, this.pool, this.maxMessagesNr);
            } else {
                String clientId = config.getClientId();
                String durableName = clientId != null ? clientId : config.getEjbName();
                this.connectionConsumer = tConnection.createDurableConnectionConsumer(topic, durableName, messageSelector, this.pool, this.maxMessagesNr);
            }
            this.log.debug("Topic connectionConsumer set up");
        } else if (destinationType.equals("javax.jms.Queue")) {
            this.log.debug("Got destination type Queue for " + config.getEjbName());
            Object qFactory = context.lookup(adapter.getQueueFactoryRef());
            QueueConnection qConnection = ConnectionFactoryHelper.createQueueConnection(qFactory, user, password);
            this.connection = qConnection;
            Queue queue = (Queue)this.createDestination(class$javax$jms$Queue != null ? class$javax$jms$Queue : (class$javax$jms$Queue = JMSContainerInvoker.class$("javax.jms.Queue")), context, "queue/" + jndiSuffix, jndiSuffix);
            this.pool = this.createSessionPool((Connection)qConnection, this.maxPoolSize, true, this.acknowledgeMode, new MessageListenerImpl(this));
            this.log.debug("server session pool: " + this.pool);
            this.connectionConsumer = qConnection.createConnectionConsumer(queue, messageSelector, this.pool, this.maxMessagesNr);
            this.log.debug("connection consumer: " + this.connectionConsumer);
        }
        this.log.debug("initialized with config " + this.toString());
    }

    protected void innerStop() {
        try {
            if (this.connection != null) {
                this.connection.setExceptionListener(null);
                this.log.debug("unset exception listener");
            }
        }
        catch (Exception e) {
            this.log.error("Could not set ExceptionListener to null", e);
        }
        try {
            if (this.connection != null) {
                this.connection.stop();
                this.log.debug("connection stopped");
            }
        }
        catch (Exception e) {
            this.log.error("Could not stop JMS connection", e);
        }
    }

    public Object invoke(Object id, Method m, Object[] args, Transaction tx, Principal identity, Object credential) throws Exception {
        MethodInvocation mi = new MethodInvocation(id, m, args, tx, identity, credential);
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.container.getClassLoader());
        try {
            Object object = this.container.invoke(mi);
            Object var11_10 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            return object;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            throw throwable;
        }
    }

    public boolean isOptimized() {
        this.log.debug("Optimize in action: " + this.optimize);
        return this.optimize;
    }

    protected String parseJndiSuffix(String jndiname, String defautSuffix) {
        int indexOfSlash;
        String jndiSuffix = "";
        jndiSuffix = jndiname != null ? ((indexOfSlash = jndiname.indexOf("/")) != -1 ? jndiname.substring(indexOfSlash + 1) : jndiname) : defautSuffix;
        return jndiSuffix;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setOptimized(boolean optimize) {
        this.log.debug("Container Invoker optimize set to " + optimize);
        this.optimize = optimize;
    }

    public void start() throws Exception {
        this.log.debug("Starting JMSContainerInvoker for bean " + this.beanName);
        this.exListener = new ExceptionListenerImpl(this);
        this.connection.setExceptionListener((ExceptionListener)this.exListener);
        this.connection.start();
    }

    public void stop() {
        this.log.debug("Stopping JMSContainerInvoker for bean " + this.beanName);
        if (this.exListener != null) {
            this.exListener.stop();
        }
        this.innerStop();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("JMSContainerInvoker: {");
        buff.append("beanName=").append(this.beanName);
        buff.append(";maxMessagesNr=").append(this.maxMessagesNr);
        buff.append(";maxPoolSize=").append(this.maxPoolSize);
        buff.append(";reconnectInterval=").append(this.reconnectInterval);
        buff.append(";providerAdapterJNDI=").append(this.providerAdapterJNDI);
        buff.append(";serverSessionPoolFactoryJNDI=").append(this.serverSessionPoolFactoryJNDI);
        buff.append(";acknowledgeMode=").append(this.acknowledgeMode);
        buff.append(";isContainerManagedTx=").append(this.isContainerManagedTx);
        buff.append(";isNotSupportedTx=").append(this.isNotSupportedTx);
        buff.append(";useDLQ=").append(this.useDLQ);
        if (this.dlqHandler != null) {
            buff.append(";dlqHandler=").append(this.dlqHandler.toString());
        }
        buff.append("}");
        return buff.toString();
    }

    class MessageListenerImpl
    implements MessageListener {
        JMSContainerInvoker invoker;

        MessageListenerImpl(JMSContainerInvoker invoker) {
            this.invoker = invoker;
        }

        public void onMessage(Message message) {
            String id;
            if (JMSContainerInvoker.this.log.isTraceEnabled()) {
                JMSContainerInvoker.this.log.trace("processing message: " + message);
            }
            try {
                id = message.getJMSMessageID();
            }
            catch (JMSException jMSException) {
                id = "JMSContainerInvoker";
            }
            try {
                if (JMSContainerInvoker.this.useDLQ && message.getJMSRedelivered() && JMSContainerInvoker.this.dlqHandler.handleRedeliveredMessage(message)) {
                    return;
                }
                this.invoker.invoke(id, ON_MESSAGE, new Object[]{message}, JMSContainerInvoker.this.tm.getTransaction(), null, null);
            }
            catch (Exception e) {
                JMSContainerInvoker.this.log.error("Exception in JMSCI message listener", e);
            }
        }
    }

    class ExceptionListenerImpl
    implements ExceptionListener {
        JMSContainerInvoker invoker;
        Thread currentThread;
        boolean notStoped = true;

        ExceptionListenerImpl(JMSContainerInvoker invoker) {
            this.invoker = invoker;
        }

        public void onException(JMSException ex) {
            this.currentThread = Thread.currentThread();
            JMSContainerInvoker.this.log.warn("MDB lost connection to provider", ex);
            boolean tryIt = true;
            while (tryIt && this.notStoped) {
                JMSContainerInvoker.this.log.info("MDB Trying to reconnect...");
                try {
                    try {
                        Thread.sleep(JMSContainerInvoker.this.reconnectInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        tryIt = false;
                        return;
                    }
                    this.invoker.innerStop();
                    this.invoker.destroy();
                    this.invoker.init();
                    this.invoker.start();
                    tryIt = false;
                    JMSContainerInvoker.this.log.info("OK - reconnected");
                }
                catch (Exception e) {
                    JMSContainerInvoker.this.log.error("MDB error reconnecting", e);
                }
            }
            this.currentThread = null;
        }

        void stop() {
            JMSContainerInvoker.this.log.debug("stop requested");
            this.notStoped = false;
            if (this.currentThread != null) {
                this.currentThread.interrupt();
                JMSContainerInvoker.this.log.debug("current thread interrupted");
            }
        }
    }
}

