/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.jdbc;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.jaws.JAWSPersistenceManager;
import org.jboss.ejb.plugins.jaws.JPMLoadEntityCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCCommandFactory;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCQueryCommand;
import org.jboss.ejb.plugins.jaws.metadata.CMPFieldMetaData;
import org.jboss.ejb.plugins.jaws.metadata.PkFieldMetaData;

public class JDBCLoadEntityCommand
extends JDBCQueryCommand
implements JPMLoadEntityCommand {
    int[] cmpFieldPositionInSelect = null;
    private static final int JDBC_WART_OFFSET = 1;

    public JDBCLoadEntityCommand(JDBCCommandFactory factory) {
        super(factory, "Load");
        String sql = String.valueOf(this.createSelectClause()) + " FROM " + this.jawsEntity.getTableName() + " WHERE " + this.getPkColumnWhereList();
        if (this.jawsEntity.hasSelectForUpdate()) {
            sql = String.valueOf(sql) + " FOR UPDATE";
        }
        this.setSQL(sql);
    }

    protected String createSelectClause() {
        String sql = "SELECT ";
        HashMap<String, PkFieldMetaData> alreadyListed = new HashMap<String, PkFieldMetaData>();
        String[] pkColumnNames = new String[this.jawsEntity.getNumberOfPkFields()];
        Iterator keyIt = this.jawsEntity.getPkFields();
        int fieldCount = 0;
        while (keyIt.hasNext()) {
            PkFieldMetaData pkField = (PkFieldMetaData)keyIt.next();
            sql = String.valueOf(sql) + (fieldCount == 0 ? "" : ",") + this.jawsEntity.getTableName() + "." + pkField.getColumnName();
            alreadyListed.put(pkField.getColumnName().toUpperCase(), pkField);
            pkColumnNames[fieldCount] = pkField.getColumnName();
            ++fieldCount;
        }
        this.cmpFieldPositionInSelect = new int[this.jawsEntity.getNumberOfCMPFields()];
        Iterator it = this.jawsEntity.getCMPFields();
        int cmpFieldCount = 0;
        while (it.hasNext()) {
            CMPFieldMetaData cmpField = (CMPFieldMetaData)it.next();
            if (alreadyListed.get(cmpField.getColumnName().toUpperCase()) == null) {
                sql = String.valueOf(sql) + "," + this.jawsEntity.getTableName() + "." + cmpField.getColumnName();
                this.cmpFieldPositionInSelect[cmpFieldCount] = fieldCount + 1;
                ++fieldCount;
            } else {
                int i = 0;
                while (i < pkColumnNames.length) {
                    if (pkColumnNames[i].equalsIgnoreCase(cmpField.getColumnName())) {
                        this.cmpFieldPositionInSelect[cmpFieldCount] = i + 1;
                        break;
                    }
                    ++i;
                }
                if (this.cmpFieldPositionInSelect[cmpFieldCount] < 1) {
                    this.log.error("Error: Can't find first occurence of repeated column " + cmpField.getName() + " when building CMP load SQL for " + this.jawsEntity.getName());
                }
            }
            ++cmpFieldCount;
        }
        return sql;
    }

    public void execute(EntityEnterpriseContext ctx) throws RemoteException {
        if (!this.jawsEntity.isReadOnly() || this.isTimedOut(ctx)) {
            try {
                Object[] data = this.factory.getPreloadData(ctx.getId());
                if (data != null) {
                    this.loadFromPreload(data, ctx);
                } else {
                    this.jdbcExecute(ctx);
                }
            }
            catch (Exception e) {
                throw new ServerException("Load failed", e);
            }
        }
    }

    protected Object handleResult(ResultSet rs, Object argOrArgs) throws Exception {
        EntityEnterpriseContext ctx = (EntityEnterpriseContext)argOrArgs;
        if (!rs.next()) {
            throw new NoSuchObjectException("Entity " + ctx.getId() + " not found");
        }
        this.loadOneEntity(rs, ctx);
        return null;
    }

    protected boolean isTimedOut(EntityEnterpriseContext ctx) {
        JAWSPersistenceManager.PersistenceContext pCtx = (JAWSPersistenceManager.PersistenceContext)ctx.getPersistenceContext();
        return System.currentTimeMillis() - pCtx.lastRead > (long)this.jawsEntity.getReadOnlyTimeOut();
    }

    protected void loadFromPreload(Object[] data, EntityEnterpriseContext ctx) throws Exception {
        int fieldCount = 0;
        Iterator iter = this.jawsEntity.getCMPFields();
        while (iter.hasNext()) {
            CMPFieldMetaData cmpField = (CMPFieldMetaData)iter.next();
            this.setCMPFieldValue(ctx.getInstance(), cmpField, data[fieldCount]);
            ++fieldCount;
        }
        JAWSPersistenceManager.PersistenceContext pCtx = (JAWSPersistenceManager.PersistenceContext)ctx.getPersistenceContext();
        if (this.jawsEntity.isReadOnly()) {
            pCtx.lastRead = System.currentTimeMillis();
        }
        pCtx.state = this.getState(ctx);
    }

    protected void loadOneEntity(ResultSet rs, EntityEnterpriseContext ctx) throws Exception {
        CMPFieldMetaData cmpField;
        int idx = 1;
        Iterator keyIt = this.jawsEntity.getPkFields();
        LinkedList<String> pkList = new LinkedList<String>();
        while (keyIt.hasNext()) {
            PkFieldMetaData pkField = (PkFieldMetaData)keyIt.next();
            cmpField = new CMPFieldMetaData(pkField.getName(), pkField.getJawsEntity());
            this.setCMPFieldValue(ctx.getInstance(), cmpField, this.getResultObject(rs, idx, cmpField));
            pkList.add(pkField.getName());
            ++idx;
        }
        Iterator iter = this.jawsEntity.getCMPFields();
        while (iter.hasNext()) {
            cmpField = (CMPFieldMetaData)iter.next();
            if (pkList.contains(cmpField.getName())) continue;
            this.setCMPFieldValue(ctx.getInstance(), cmpField, this.getResultObject(rs, idx, cmpField));
            ++idx;
        }
        JAWSPersistenceManager.PersistenceContext pCtx = (JAWSPersistenceManager.PersistenceContext)ctx.getPersistenceContext();
        if (this.jawsEntity.isReadOnly()) {
            pCtx.lastRead = System.currentTimeMillis();
        }
        pCtx.state = this.getState(ctx);
    }

    protected void setParameters(PreparedStatement stmt, Object argOrArgs) throws Exception {
        EntityEnterpriseContext ctx = (EntityEnterpriseContext)argOrArgs;
        this.setPrimaryKeyParameters(stmt, 1, ctx.getId());
    }
}

