/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.jdbc;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.FinderException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.jaws.JPMFindEntitiesCommand;
import org.jboss.ejb.plugins.jaws.bmp.CustomFindByEntitiesCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCCommandFactory;
import org.jboss.ejb.plugins.jaws.metadata.FinderMetaData;
import org.jboss.util.FinderResults;

public class JDBCFindEntitiesCommand
implements JPMFindEntitiesCommand {
    private JDBCCommandFactory factory;
    private HashMap knownFinderCommands = new HashMap();

    public JDBCFindEntitiesCommand(JDBCCommandFactory factory) {
        this.factory = factory;
        Class<?> ejbClass = null;
        try {
            ejbClass = factory.getContainer().getClassLoader().loadClass(factory.getMetaData().getEntity().getEjbClass());
            Method[] customMethods = ejbClass.getMethods();
            int i = 0;
            while (i < customMethods.length) {
                Method m = customMethods[i];
                String name = m.getName();
                if (name.startsWith("ejbFindBy")) {
                    String remoteName = "f" + name.substring(4);
                    try {
                        this.knownFinderCommands.put(remoteName, new CustomFindByEntitiesCommand(m));
                        factory.getLog().debug("Added custom finder " + remoteName + ".");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        factory.getLog().error("Could not create the custom finder " + remoteName + ".");
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            factory.getLog().warn("Error initializing custom finder ", e);
        }
        Iterator definedFinders = factory.getMetaData().getFinders();
        while (definedFinders.hasNext()) {
            FinderMetaData f = (FinderMetaData)definedFinders.next();
            if (this.knownFinderCommands.containsKey(f.getName())) continue;
            JPMFindEntitiesCommand finderCommand = null;
            finderCommand = factory.createDefinedFinderCommand(f);
            this.knownFinderCommands.put(f.getName(), finderCommand);
        }
        factory.getLog().debug("AutoGenerated finders  - Home=" + factory.getContainer().getHomeClass() + " -- LocalHome=" + factory.getContainer().getLocalHomeClass());
        Method[] homeMethods = factory.getContainer().getHomeClass() != null ? factory.getContainer().getHomeClass().getMethods() : new Method[]{};
        Method[] localHomeMethods = factory.getContainer().getLocalHomeClass() != null ? factory.getContainer().getLocalHomeClass().getMethods() : new Method[]{};
        Method[] allHomeMethods = new Method[homeMethods.length + localHomeMethods.length];
        int i = 0;
        while (i < homeMethods.length) {
            allHomeMethods[i] = homeMethods[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < localHomeMethods.length) {
            allHomeMethods[homeMethods.length + i2] = localHomeMethods[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < allHomeMethods.length) {
            Method m = allHomeMethods[i3];
            String name = m.getName();
            if (!this.knownFinderCommands.containsKey(name)) {
                FinderMetaData f;
                if (name.equals("findAll")) {
                    factory.getLog().debug("Save AutoGenerated " + name + "  " + m);
                    f = new FinderMetaData("findAll");
                    this.knownFinderCommands.put(name, factory.createFindAllCommand(f));
                } else if (name.startsWith("findBy") && !name.equals("findByPrimaryKey")) {
                    try {
                        factory.getLog().debug("Save AutoGenerated " + name + "  " + m);
                        f = new FinderMetaData(name);
                        this.knownFinderCommands.put(name, factory.createFindByCommand(m, f));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        factory.getLog().debug("Could not create the finder " + name + ", because no matching CMP field was found.");
                    }
                }
            }
            ++i3;
        }
    }

    public FinderResults execute(Method finderMethod, Object[] args, EntityEnterpriseContext ctx) throws RemoteException, FinderException {
        String finderName = finderMethod.getName();
        JPMFindEntitiesCommand finderCommand = null;
        finderCommand = (JPMFindEntitiesCommand)this.knownFinderCommands.get(finderName);
        return finderCommand != null ? finderCommand.execute(finderMethod, args, ctx) : new FinderResults(new ArrayList(), null, null, null);
    }
}

