/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.jdbc;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.plugins.jaws.JPMActivateEntityCommand;
import org.jboss.ejb.plugins.jaws.JPMCommandFactory;
import org.jboss.ejb.plugins.jaws.JPMCreateEntityCommand;
import org.jboss.ejb.plugins.jaws.JPMDestroyCommand;
import org.jboss.ejb.plugins.jaws.JPMFindEntitiesCommand;
import org.jboss.ejb.plugins.jaws.JPMFindEntityCommand;
import org.jboss.ejb.plugins.jaws.JPMInitCommand;
import org.jboss.ejb.plugins.jaws.JPMLoadEntitiesCommand;
import org.jboss.ejb.plugins.jaws.JPMLoadEntityCommand;
import org.jboss.ejb.plugins.jaws.JPMPassivateEntityCommand;
import org.jboss.ejb.plugins.jaws.JPMRemoveEntityCommand;
import org.jboss.ejb.plugins.jaws.JPMStartCommand;
import org.jboss.ejb.plugins.jaws.JPMStopCommand;
import org.jboss.ejb.plugins.jaws.JPMStoreEntityCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCActivateEntityCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCBeanExistsCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCCreateEntityCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCDefinedFinderCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCDestroyCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCFindAllCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCFindByCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCFindEntitiesCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCFindEntityCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCInitCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCLoadEntitiesCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCLoadEntityCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCPassivateEntityCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCRemoveEntityCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCStartCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCStopCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCStoreEntityCommand;
import org.jboss.ejb.plugins.jaws.metadata.FinderMetaData;
import org.jboss.ejb.plugins.jaws.metadata.JawsApplicationMetaData;
import org.jboss.ejb.plugins.jaws.metadata.JawsEntityMetaData;
import org.jboss.ejb.plugins.jaws.metadata.JawsXmlFileLoader;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.util.TimerQueue;
import org.jboss.util.TimerTask;

public class JDBCCommandFactory
implements JPMCommandFactory {
    private EntityContainer container;
    private Context javaCtx;
    private JawsEntityMetaData metadata;
    private Logger log;
    private boolean debug = false;
    private static TimerQueue softRefHandler = new TimerQueue("JAWS Preload reference handler");
    private ReferenceQueue preloadRefQueue = new ReferenceQueue();
    private Map preloadedData = new HashMap();
    private Map nonTransactionalPreloadData = new HashMap();
    private TransactionManager tm;
    private JDBCBeanExistsCommand beanExistsCommand;
    private JPMFindEntitiesCommand findEntitiesCommand;

    static {
        softRefHandler.start();
    }

    public JDBCCommandFactory(EntityContainer container, Logger log) throws Exception {
        this.container = container;
        this.log = log;
        this.javaCtx = (Context)new InitialContext().lookup("java:comp/env");
        String ejbName = container.getBeanMetaData().getEjbName();
        ApplicationMetaData amd = container.getBeanMetaData().getApplicationMetaData();
        JawsApplicationMetaData jamd = (JawsApplicationMetaData)amd.getPluginData("JAWS");
        if (jamd == null) {
            JawsXmlFileLoader jfl = new JawsXmlFileLoader(amd, container.getClassLoader(), container.getLocalClassLoader(), log);
            jamd = jfl.load();
            amd.addPluginData("JAWS", jamd);
        }
        this.debug = jamd.getDebug();
        this.metadata = jamd.getBeanByEjbName(ejbName);
        if (this.metadata == null) {
            throw new DeploymentException("No metadata found for bean " + ejbName);
        }
        this.tm = container.getTransactionManager();
        PreloadRefQueueHandlerTask reqQue = new PreloadRefQueueHandlerTask(this.preloadRefQueue, this.preloadedData, this.nonTransactionalPreloadData);
        softRefHandler.schedule(reqQue);
    }

    void addPreloadData(Object entityKey, Object[] entityData) {
        Transaction trans = null;
        try {
            trans = this.tm.getTransaction();
        }
        catch (SystemException systemException) {
            this.log.warn("System exception getting transaction for preload - can't preload data for " + entityKey);
            return;
        }
        if (trans != null) {
            Map map = this.preloadedData;
            synchronized (map) {
                HashMap<Object, PreloadData> entitiesInTransaction = (HashMap<Object, PreloadData>)this.preloadedData.get(trans);
                if (entitiesInTransaction == null) {
                    try {
                        trans.registerSynchronization((Synchronization)new PreloadClearSynch(trans));
                    }
                    catch (SystemException systemException) {
                        this.log.warn("System exception getting transaction for preload - can't get preloaded data for " + entityKey);
                        Object var5_8 = null;
                        return;
                    }
                    catch (RollbackException rollbackException) {
                        this.log.warn("Rollback exception getting transaction for preload - can't get preloaded data for " + entityKey);
                        Object var5_9 = null;
                        return;
                    }
                    entitiesInTransaction = new HashMap<Object, PreloadData>();
                    this.preloadedData.put(trans, entitiesInTransaction);
                }
                PreloadData preloadData = new PreloadData(trans, entityKey, entityData, this.preloadRefQueue);
                entitiesInTransaction.put(entityKey, preloadData);
            }
        }
        Map map = this.nonTransactionalPreloadData;
        synchronized (map) {
            PreloadData preloadData = new PreloadData(null, entityKey, entityData, this.preloadRefQueue);
            this.nonTransactionalPreloadData.put(entityKey, preloadData);
        }
    }

    void clearPreloadForTrans(Transaction trans) {
        Map map = this.preloadedData;
        synchronized (map) {
            this.preloadedData.remove(trans);
        }
    }

    public JPMActivateEntityCommand createActivateEntityCommand() {
        return new JDBCActivateEntityCommand(this);
    }

    public JDBCBeanExistsCommand createBeanExistsCommand() {
        if (this.beanExistsCommand == null) {
            this.beanExistsCommand = new JDBCBeanExistsCommand(this);
        }
        return this.beanExistsCommand;
    }

    public JPMCreateEntityCommand createCreateEntityCommand() {
        return new JDBCCreateEntityCommand(this);
    }

    public JPMFindEntitiesCommand createDefinedFinderCommand(FinderMetaData f) {
        return new JDBCDefinedFinderCommand(this, f);
    }

    public JPMDestroyCommand createDestroyCommand() {
        return new JDBCDestroyCommand(this);
    }

    public JPMFindEntitiesCommand createFindAllCommand(FinderMetaData f) {
        return new JDBCFindAllCommand(this, f);
    }

    public JPMFindEntitiesCommand createFindByCommand(Method finderMethod, FinderMetaData f) throws IllegalArgumentException {
        return new JDBCFindByCommand(this, finderMethod, f);
    }

    public JPMFindEntitiesCommand createFindEntitiesCommand() {
        if (this.findEntitiesCommand == null) {
            this.findEntitiesCommand = new JDBCFindEntitiesCommand(this);
        }
        return this.findEntitiesCommand;
    }

    public JPMFindEntityCommand createFindEntityCommand() {
        return new JDBCFindEntityCommand(this);
    }

    public JPMInitCommand createInitCommand() {
        return new JDBCInitCommand(this);
    }

    public JPMLoadEntitiesCommand createLoadEntitiesCommand() {
        return new JDBCLoadEntitiesCommand(this);
    }

    public JPMLoadEntityCommand createLoadEntityCommand() {
        return new JDBCLoadEntityCommand(this);
    }

    public JPMPassivateEntityCommand createPassivateEntityCommand() {
        return new JDBCPassivateEntityCommand(this);
    }

    public JPMRemoveEntityCommand createRemoveEntityCommand() {
        return new JDBCRemoveEntityCommand(this);
    }

    public JPMStartCommand createStartCommand() {
        return new JDBCStartCommand(this);
    }

    public JPMStopCommand createStopCommand() {
        return new JDBCStopCommand(this);
    }

    public JPMStoreEntityCommand createStoreEntityCommand() {
        return new JDBCStoreEntityCommand(this);
    }

    public EntityContainer getContainer() {
        return this.container;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public Context getJavaCtx() {
        return this.javaCtx;
    }

    public Logger getLog() {
        return this.log;
    }

    public JawsEntityMetaData getMetaData() {
        return this.metadata;
    }

    Object[] getPreloadData(Object entityKey) {
        Transaction trans = null;
        try {
            trans = this.tm.getTransaction();
        }
        catch (SystemException systemException) {
            this.log.warn("System exception getting transaction for preload - not preloading " + entityKey);
            return null;
        }
        Object[] result = null;
        PreloadData preloadData = null;
        if (trans != null) {
            Map entitiesInTransaction = null;
            entitiesInTransaction = (Map)this.preloadedData.get(trans);
            if (entitiesInTransaction != null) {
                Map map = entitiesInTransaction;
                synchronized (map) {
                    preloadData = (PreloadData)entitiesInTransaction.get(entityKey);
                    entitiesInTransaction.remove(entityKey);
                }
            }
        } else {
            Map map = this.nonTransactionalPreloadData;
            synchronized (map) {
                preloadData = (PreloadData)this.nonTransactionalPreloadData.get(entityKey);
                this.nonTransactionalPreloadData.remove(entityKey);
            }
        }
        if (preloadData != null) {
            result = preloadData.getData();
        }
        return result;
    }

    private static class PreloadRefQueueHandlerTask
    extends TimerTask {
        ReferenceQueue preloadRefQueue;
        Map preloadedData;
        Map nonTransactionalPreloadData;

        PreloadRefQueueHandlerTask(ReferenceQueue preloadRefQueue, Map preloadedData, Map nonTransactionalPreloadData) {
            super(50L);
            this.preloadRefQueue = preloadRefQueue;
            this.preloadedData = preloadedData;
            this.nonTransactionalPreloadData = nonTransactionalPreloadData;
        }

        public void execute() throws Exception {
            PreloadData preloadData = (PreloadData)this.preloadRefQueue.poll();
            int handled = 0;
            while (preloadData != null && handled < 10) {
                if (preloadData.getTransaction() != null) {
                    Map entitiesInTransaction = null;
                    entitiesInTransaction = (Map)this.preloadedData.get(preloadData.getTransaction());
                    if (entitiesInTransaction != null) {
                        Map map = entitiesInTransaction;
                        synchronized (map) {
                            entitiesInTransaction.remove(preloadData.getKey());
                        }
                    }
                } else {
                    Map map = this.nonTransactionalPreloadData;
                    synchronized (map) {
                        this.nonTransactionalPreloadData.remove(preloadData.getKey());
                    }
                }
                preloadData.empty();
                ++handled;
                preloadData = (PreloadData)this.preloadRefQueue.poll();
            }
        }
    }

    private class PreloadData
    extends SoftReference {
        private Object key;
        private Transaction trans;

        PreloadData(Transaction trans, Object key, Object[] data, ReferenceQueue queue) {
            super(data, queue);
            this.trans = trans;
            this.key = key;
        }

        public void empty() {
            this.key = null;
            this.trans = null;
        }

        Object[] getData() {
            return (Object[])this.get();
        }

        Object getKey() {
            return this.key;
        }

        Transaction getTransaction() {
            return this.trans;
        }
    }

    private class PreloadClearSynch
    implements Synchronization {
        private Transaction forTrans;

        public PreloadClearSynch(Transaction forTrans) {
            this.forTrans = forTrans;
        }

        public void afterCompletion(int p0) {
            JDBCCommandFactory.this.clearPreloadForTrans(this.forTrans);
        }

        public void beforeCompletion() {
        }
    }
}

