/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.util.Hashtable;
import javax.ejb.EJBException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb.Container;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.StatefulSessionEnterpriseContext;
import org.jboss.ejb.StatelessSessionEnterpriseContext;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.metadata.SessionMetaData;

public class TxInterceptorBMT
extends AbstractInterceptor {
    protected TransactionManager tm;
    ThreadLocal userTransaction = new ThreadLocal();
    protected Container container;

    public Container getContainer() {
        return this.container;
    }

    public void init() throws Exception {
        this.tm = this.getContainer().getTransactionManager();
        RefAddr refAddr = new RefAddr("userTransaction"){

            public Object getContent() {
                return TxInterceptorBMT.this.userTransaction;
            }
        };
        Reference ref = new Reference("javax.transaction.UserTransaction", refAddr, new UserTxFactory().getClass().getName(), null);
        ((Context)new InitialContext().lookup("java:comp/")).bind("UserTransaction", (Object)ref);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(MethodInvocation mi) throws Exception {
        Object object;
        Object oldUserTx = this.userTransaction.get();
        if (((SessionMetaData)this.container.getBeanMetaData()).isStateful()) {
            this.userTransaction.set(((StatefulSessionEnterpriseContext)mi.getEnterpriseContext()).getSessionContext().getUserTransaction());
        } else {
            this.userTransaction.set(((StatelessSessionEnterpriseContext)mi.getEnterpriseContext()).getSessionContext().getUserTransaction());
        }
        Transaction t1 = this.tm.getTransaction();
        Transaction t2 = mi.getEnterpriseContext().getTransaction();
        mi.setTransaction(t2);
        try {
            try {
                if (t2 == null) {
                    this.tm.suspend();
                } else if (!t2.equals(t1)) {
                    this.tm.suspend();
                    this.tm.resume(t2);
                }
                object = this.getNext().invoke(mi);
                Object var7_6 = null;
            }
            catch (RuntimeException e) {
                if (mi.getEnterpriseContext().getTransaction() != null) {
                    try {
                        mi.getEnterpriseContext().getTransaction().setRollbackOnly();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                if (!(e instanceof EJBException)) throw new ServerException("Transaction rolled back", e);
                throw new ServerException("Transaction rolled back", ((EJBException)e).getCausedByException());
            }
            catch (RemoteException e) {
                if (mi.getEnterpriseContext().getTransaction() == null) throw new ServerException("Transaction rolled back", e);
                try {
                    mi.getEnterpriseContext().getTransaction().setRollbackOnly();
                    throw new ServerException("Transaction rolled back", e);
                }
                catch (IllegalStateException illegalStateException) {}
                throw new ServerException("Transaction rolled back", e);
            }
            catch (Error e) {
                if (mi.getEnterpriseContext().getTransaction() == null) throw new ServerError("Transaction rolled back", e);
                try {
                    mi.getEnterpriseContext().getTransaction().setRollbackOnly();
                    throw new ServerError("Transaction rolled back", e);
                }
                catch (IllegalStateException illegalStateException) {}
                throw new ServerError("Transaction rolled back", e);
            }
            this.userTransaction.set(oldUserTx);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.userTransaction.set(oldUserTx);
            Transaction currentTx = this.tm.getTransaction();
            if (t1 == null) {
                this.tm.suspend();
            } else if (!t1.equals(currentTx)) {
                this.tm.suspend();
                this.tm.resume(t1);
            }
            if (!((SessionMetaData)this.container.getBeanMetaData()).isStateless()) throw throwable;
            Transaction t3 = mi.getEnterpriseContext().getTransaction();
            if (t3 == null) throw throwable;
            switch (t3.getStatus()) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: {
                    t3.rollback();
                }
                case 2: {
                    this.log.error("Application error: BMT stateless bean " + this.container.getBeanMetaData().getEjbName() + " should complete transactions before returning (ejb1.1 spec, 11.6.1)");
                    throw new RemoteException("Application error: BMT stateless bean " + this.container.getBeanMetaData().getEjbName() + " should complete transactions before returning (ejb1.1 spec, 11.6.1)");
                }
            }
            throw throwable;
        }
        Transaction currentTx = this.tm.getTransaction();
        if (t1 == null) {
            this.tm.suspend();
        } else if (!t1.equals(currentTx)) {
            this.tm.suspend();
            this.tm.resume(t1);
        }
        if (!((SessionMetaData)this.container.getBeanMetaData()).isStateless()) return object;
        Transaction t3 = mi.getEnterpriseContext().getTransaction();
        if (t3 == null) return object;
        switch (t3.getStatus()) {
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                t3.rollback();
            }
            case 2: {
                this.log.error("Application error: BMT stateless bean " + this.container.getBeanMetaData().getEjbName() + " should complete transactions before returning (ejb1.1 spec, 11.6.1)");
                throw new RemoteException("Application error: BMT stateless bean " + this.container.getBeanMetaData().getEjbName() + " should complete transactions before returning (ejb1.1 spec, 11.6.1)");
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invokeHome(MethodInvocation mi) throws Exception {
        Object object;
        if (!((SessionMetaData)this.container.getBeanMetaData()).isStateful()) return this.getNext().invokeHome(mi);
        Object oldUserTx = this.userTransaction.get();
        this.userTransaction.set(((StatefulSessionEnterpriseContext)mi.getEnterpriseContext()).getSessionContext().getUserTransaction());
        Transaction t1 = this.tm.getTransaction();
        Transaction t2 = mi.getEnterpriseContext().getTransaction();
        try {
            try {
                if (t2 == null) {
                    this.tm.suspend();
                } else if (!t2.equals(t1)) {
                    this.tm.suspend();
                    this.tm.resume(t2);
                }
                object = this.getNext().invokeHome(mi);
                Object var7_6 = null;
            }
            catch (RuntimeException e) {
                if (mi.getEnterpriseContext().getTransaction() != null) {
                    try {
                        mi.getEnterpriseContext().getTransaction().setRollbackOnly();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                if (!(e instanceof EJBException)) throw new ServerException("Transaction rolled back", e);
                throw new ServerException("Transaction rolled back", ((EJBException)e).getCausedByException());
            }
            catch (RemoteException e) {
                if (mi.getEnterpriseContext().getTransaction() == null) throw new ServerException("Transaction rolled back", e);
                try {
                    mi.getEnterpriseContext().getTransaction().setRollbackOnly();
                    throw new ServerException("Transaction rolled back", e);
                }
                catch (IllegalStateException illegalStateException) {}
                throw new ServerException("Transaction rolled back", e);
            }
            catch (Error e) {
                if (mi.getEnterpriseContext().getTransaction() == null) throw new ServerException("Transaction rolled back:" + e.getMessage());
                try {
                    mi.getEnterpriseContext().getTransaction().setRollbackOnly();
                    throw new ServerException("Transaction rolled back:" + e.getMessage());
                }
                catch (IllegalStateException illegalStateException) {}
                throw new ServerException("Transaction rolled back:" + e.getMessage());
            }
            this.userTransaction.set(oldUserTx);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.userTransaction.set(oldUserTx);
            Transaction currentTx = this.tm.getTransaction();
            if (t1 == null) {
                this.tm.suspend();
                throw throwable;
            }
            if (t1.equals(currentTx)) throw throwable;
            this.tm.suspend();
            this.tm.resume(t1);
            throw throwable;
        }
        Transaction currentTx = this.tm.getTransaction();
        if (t1 == null) {
            this.tm.suspend();
            return object;
        }
        if (t1.equals(currentTx)) return object;
        this.tm.suspend();
        this.tm.resume(t1);
        return object;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void stop() {
        try {
            ((Context)new InitialContext().lookup("java:comp/")).unbind("UserTransaction");
        }
        catch (Exception exception) {}
    }

    public static class UserTxFactory
    implements ObjectFactory {
        public Object getObjectInstance(Object ref, Name name, Context nameCtx, Hashtable environment) throws Exception {
            ThreadLocal threadLocal = (ThreadLocal)((Reference)ref).get(0).getContent();
            return threadLocal.get();
        }
    }
}

