/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.StatelessSessionEnterpriseContext;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.w3c.dom.Element;

public class SingletonStatelessSessionInstancePool
implements InstancePool,
XmlLoadable {
    Container con;
    EnterpriseContext ctx;
    boolean inUse = false;
    boolean isSynchronized = true;

    public void add() throws Exception {
    }

    protected EnterpriseContext create(Object instance, Container con) throws Exception {
        return new StatelessSessionEnterpriseContext(instance, con);
    }

    public void destroy() {
    }

    public void discard(EnterpriseContext ctx) {
        try {
            ctx.discard();
        }
        catch (RemoteException remoteException) {}
        this.inUse = false;
        this.notifyAll();
    }

    public synchronized void free(EnterpriseContext ctx) {
        this.inUse = false;
        this.notifyAll();
    }

    public synchronized EnterpriseContext get() throws Exception {
        while (this.inUse && this.isSynchronized) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.ctx == null) {
            try {
                this.ctx = this.create(this.con.getBeanClass().newInstance(), this.con);
            }
            catch (InstantiationException e) {
                throw new ServerException("Could not instantiate bean", e);
            }
            catch (IllegalAccessException e) {
                throw new ServerException("Could not instantiate bean", e);
            }
        }
        this.inUse = true;
        return this.ctx;
    }

    public int getCurrentSize() {
        return 1;
    }

    public int getMaxSize() {
        return 1;
    }

    public void importXml(Element element) throws Exception {
        Element synch = MetaData.getUniqueChild(element, "Synchronized");
        this.isSynchronized = Boolean.valueOf(MetaData.getElementContent(synch));
    }

    public void init() throws Exception {
    }

    public void setContainer(Container c) {
        this.con = c;
    }

    public void start() throws Exception {
    }

    public void stop() {
    }
}

