/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Constructor;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.BeanLock;
import org.jboss.ejb.BeanLockManager;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.InstanceCache;
import org.jboss.ejb.plugins.AbstractInstanceCache;
import org.jboss.ejb.plugins.AbstractPassivationJob;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.jboss.monitor.MetricsConstants;
import org.jboss.monitor.Monitorable;
import org.jboss.monitor.client.BeanCacheSnapshot;
import org.jboss.util.CachePolicy;
import org.jboss.util.WorkerQueue;
import org.w3c.dom.Element;

public abstract class AbstractInstanceCache
implements InstanceCache,
XmlLoadable,
Monitorable,
MetricsConstants {
    private static WorkerQueue m_passivator = new WorkerQueue("EJB Passivator Thread", true);
    protected Logger log = Logger.getLogger(this.getClass());
    private CachePolicy m_cache;
    private Object m_cacheLock = new Object();
    private PassivationHelper m_passivationHelper;
    private boolean m_jmsMonitoring;
    private StringBuffer m_buffer = new StringBuffer();
    static /* synthetic */ Class class$org$jboss$ejb$plugins$AbstractInstanceCache;

    static {
        m_passivator.start();
    }

    protected abstract EnterpriseContext acquireContext() throws Exception;

    protected abstract void activate(EnterpriseContext var1) throws RemoteException;

    protected abstract boolean canPassivate(EnterpriseContext var1);

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void destroy() {
        Object object = this.getCacheLock();
        synchronized (object) {
            this.getCache().destroy();
            this.m_passivationHelper.clear();
        }
        this.m_cache = null;
        this.m_passivationHelper = null;
        this.m_buffer.setLength(0);
    }

    protected abstract void freeContext(EnterpriseContext var1);

    public EnterpriseContext get(Object id) throws RemoteException, NoSuchObjectException {
        if (id == null) {
            throw new IllegalArgumentException("Can't get an object with a null key");
        }
        EnterpriseContext ctx = null;
        Object object = this.getCacheLock();
        synchronized (object) {
            ctx = (EnterpriseContext)this.getCache().get(id);
            if (ctx == null) {
                ctx = this.unschedulePassivation(id);
                if (ctx != null && ctx.getId() == null) {
                    this.log.warn("unschedulePassivation returned a passivated object with a null getId(), this ctx will NOT be reused");
                    ctx = null;
                }
                if (ctx == null) {
                    try {
                        ctx = this.acquireContext();
                        this.setKey(id, ctx);
                        this.activate(ctx);
                        this.logActivation(id);
                        this.insert(ctx);
                    }
                    catch (Exception x) {
                        if (ctx != null) {
                            this.freeContext(ctx);
                        }
                        throw new NoSuchObjectException(x.getMessage());
                    }
                } else {
                    this.insert(ctx);
                }
            }
        }
        if (ctx == null) {
            throw new NoSuchObjectException("Can't find bean with id = " + id);
        }
        return ctx;
    }

    protected CachePolicy getCache() {
        return this.m_cache;
    }

    public Object getCacheLock() {
        return this.m_cacheLock;
    }

    protected abstract Container getContainer();

    protected abstract Object getKey(EnterpriseContext var1);

    public void importXml(Element element) throws DeploymentException {
        String p = MetaData.getElementContent(MetaData.getUniqueChild(element, "cache-policy"));
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(p);
            Constructor<?> ctor = cls.getConstructor(class$org$jboss$ejb$plugins$AbstractInstanceCache != null ? class$org$jboss$ejb$plugins$AbstractInstanceCache : (class$org$jboss$ejb$plugins$AbstractInstanceCache = AbstractInstanceCache.class$("org.jboss.ejb.plugins.AbstractInstanceCache")));
            this.m_cache = (CachePolicy)ctor.newInstance(this);
        }
        catch (Exception x) {
            throw new DeploymentException("Can't create cache policy", x);
        }
        Element policyConf = MetaData.getOptionalChild(element, "cache-policy-conf");
        if (policyConf != null && this.m_cache instanceof XmlLoadable) {
            try {
                ((XmlLoadable)((Object)this.m_cache)).importXml(policyConf);
            }
            catch (Exception x) {
                throw new DeploymentException("Can't import policy configuration", x);
            }
        }
    }

    public void init() throws Exception {
        this.getCache().init();
        this.m_passivationHelper = new PassivationHelper();
    }

    public void insert(EnterpriseContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Can't insert a null object in the cache");
        }
        CachePolicy cache = this.getCache();
        Object object = this.getCacheLock();
        synchronized (object) {
            Object key = this.getKey(ctx);
            if (cache.peek(key) != null) {
                throw new IllegalStateException("INSERTING AN ALREADY EXISTING BEAN, ID = " + key);
            }
            cache.insert(key, ctx);
        }
    }

    public boolean isActive(Object id) {
        return this.getCache().peek(id) != null;
    }

    public boolean isJMSMonitoringEnabled() {
        return this.m_jmsMonitoring;
    }

    protected void logActivation(Object id) {
        Container con = this.getContainer();
        if (this.log.isTraceEnabled() && con != null) {
            this.m_buffer.setLength(0);
            this.m_buffer.append("Activated bean ");
            this.m_buffer.append(con.getBeanMetaData().getEjbName());
            this.m_buffer.append(" with id = ");
            this.m_buffer.append(id);
            this.log.trace(this.m_buffer.toString());
        }
    }

    protected void logPassivation(Object id) {
        Container con = this.getContainer();
        if (this.log.isTraceEnabled() && con != null) {
            this.m_buffer.setLength(0);
            this.m_buffer.append("Passivated bean ");
            this.m_buffer.append(con.getBeanMetaData().getEjbName());
            this.m_buffer.append(" with id = ");
            this.m_buffer.append(id);
            this.log.trace(this.m_buffer.toString());
        }
    }

    protected void logPassivationPostponed(Object id) {
        Container con = this.getContainer();
        if (this.log.isTraceEnabled() && con != null) {
            this.m_buffer.setLength(0);
            this.m_buffer.append("Postponed passivation of bean ");
            this.m_buffer.append(con.getBeanMetaData().getEjbName());
            this.m_buffer.append(" with id = ");
            this.m_buffer.append(id);
            this.log.trace(this.m_buffer.toString());
        }
    }

    protected void logPassivationScheduled(Object id) {
        Container con = this.getContainer();
        if (this.log.isTraceEnabled() && con != null) {
            this.m_buffer.setLength(0);
            this.m_buffer.append("Scheduled passivation of bean ");
            this.m_buffer.append(con.getBeanMetaData().getEjbName());
            this.m_buffer.append(" with id = ");
            this.m_buffer.append(id);
            this.log.trace(this.m_buffer.toString());
        }
    }

    protected abstract void passivate(EnterpriseContext var1) throws RemoteException;

    public void release(EnterpriseContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Can't release a null object");
        }
        Object object = this.getCacheLock();
        synchronized (object) {
            Object id = this.getKey(ctx);
            if (this.getCache().peek(id) != null) {
                this.getCache().remove(id);
            }
            this.schedulePassivation(ctx);
        }
    }

    public void remove(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("Can't remove an object using a null key");
        }
        Object object = this.getCacheLock();
        synchronized (object) {
            if (this.getCache().peek(id) != null) {
                this.getCache().remove(id);
            }
        }
    }

    public void resetStatistic() {
    }

    public Map retrieveStatistic() {
        return null;
    }

    public void sample(Object s) {
        Object object = this.getCacheLock();
        synchronized (object) {
            BeanCacheSnapshot snapshot = (BeanCacheSnapshot)s;
            snapshot.m_passivatingBeans = this.m_passivationHelper.m_passivationJobs.size();
            CachePolicy policy = this.getCache();
            if (policy instanceof Monitorable) {
                ((Monitorable)((Object)policy)).sample(s);
            }
        }
    }

    protected void schedulePassivation(EnterpriseContext ctx) {
        this.m_passivationHelper.schedule(ctx);
        this.logPassivationScheduled(this.getKey(ctx));
    }

    public abstract void setContainer(Container var1);

    public void setJMSMonitoringEnabled(boolean enable) {
        this.m_jmsMonitoring = enable;
    }

    protected abstract void setKey(Object var1, EnterpriseContext var2);

    public void start() throws Exception {
        this.getCache().start();
    }

    public void stop() {
        Object object = this.getCacheLock();
        synchronized (object) {
            this.getCache().stop();
        }
    }

    protected EnterpriseContext unschedulePassivation(Object id) {
        return this.m_passivationHelper.unschedule(id);
    }

    protected class PassivationHelper {
        private Map m_passivationJobs = Collections.synchronizedMap(new HashMap());

        protected PassivationHelper() {
        }

        static /* synthetic */ AbstractInstanceCache access$1(PassivationHelper $0) {
            return $0.AbstractInstanceCache.this;
        }

        protected void clear() {
            AbstractInstanceCache.this.log.debug("Cancelling " + this.m_passivationJobs.size() + " passivation jobs");
            Iterator iter = this.m_passivationJobs.values().iterator();
            while (iter.hasNext()) {
                AbstractPassivationJob job = (AbstractPassivationJob)iter.next();
                job.cancel();
            }
            this.m_passivationJobs.clear();
        }

        protected void schedule(EnterpriseContext bean) {
            Object key = AbstractInstanceCache.this.getKey(bean);
            if (this.m_passivationJobs.get(key) == null) {
                AbstractPassivationJob job = new AbstractPassivationJob(this, bean, key){
                    private final /* synthetic */ PassivationHelper this$1;
                    {
                        this.this$1 = this$1;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void execute() throws Exception {
                        Logger theLog = PassivationHelper.access$1((PassivationHelper)this.this$1).log;
                        if (theLog.isTraceEnabled()) {
                            theLog.trace("AbstractPassivationJob.execute, key=" + this.key);
                        }
                        Container container = null;
                        BeanLockManager lockMgr = null;
                        BeanLock lock = null;
                        ClassLoader beanCL = null;
                        EnterpriseContext jobCtx = this.ctx;
                        Object id = this.getKey();
                        Object object = PassivationHelper.access$1(this.this$1).getCacheLock();
                        synchronized (object) {
                            container = PassivationHelper.access$1(this.this$1).getContainer();
                            if (container != null) {
                                lockMgr = container.getLockManager();
                                lock = lockMgr.getLock(id);
                                beanCL = container.getClassLoader();
                            }
                        }
                        if (container == null) {
                            return;
                        }
                        if (this.ctx == null || this.ctx.getId() == null) {
                            return;
                        }
                        lock.sync();
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(beanCL);
                            Object object2 = PassivationHelper.access$1(this.this$1).getCacheLock();
                            synchronized (object2) {
                                PassivationHelper.access$0(this.this$1).remove(id);
                                1 var13_10 = this;
                                synchronized (var13_10) {
                                    EntityEnterpriseContext entityCtx;
                                    if (jobCtx == null) {
                                        Object var14_11 = null;
                                        // MONITOREXIT @DISABLED, blocks:[1, 17, 2, 3, 6, 7] lbl42 : MonitorExitStatement: MONITOREXIT : var13_10
                                        Object var12_14 = null;
                                        // MONITOREXIT @DISABLED, blocks:[1, 17, 2, 3, 6] lbl45 : MonitorExitStatement: MONITOREXIT : var11_9
                                        Object var10_17 = null;
                                        Thread.currentThread().setContextClassLoader(cl);
                                        lock.releaseSync();
                                        lockMgr.removeLockRef(id);
                                        return;
                                    }
                                    if (jobCtx instanceof EntityEnterpriseContext && !(entityCtx = (EntityEnterpriseContext)jobCtx).getCacheKey().equals(id)) {
                                        entityCtx = null;
                                        Object var14_12 = null;
                                        // MONITOREXIT @DISABLED, blocks:[16, 1, 2, 3, 6, 7] lbl56 : MonitorExitStatement: MONITOREXIT : var13_10
                                        Object var12_15 = null;
                                        // MONITOREXIT @DISABLED, blocks:[16, 1, 2, 3, 6] lbl59 : MonitorExitStatement: MONITOREXIT : var11_9
                                        Object var10_18 = null;
                                        Thread.currentThread().setContextClassLoader(cl);
                                        lock.releaseSync();
                                        lockMgr.removeLockRef(id);
                                        return;
                                    }
                                    if (!PassivationHelper.access$1(this.this$1).canPassivate(jobCtx)) {
                                        if (PassivationHelper.access$1(this.this$1).getCache().peek(id) == null) {
                                            PassivationHelper.access$1(this.this$1).getCache().insert(id, jobCtx);
                                        }
                                        PassivationHelper.access$1(this.this$1).logPassivationPostponed(id);
                                        Object var14_13 = null;
                                        // MONITOREXIT @DISABLED, blocks:[1, 2, 3, 6, 7, 15] lbl72 : MonitorExitStatement: MONITOREXIT : var13_10
                                        Object var12_16 = null;
                                        // MONITOREXIT @DISABLED, blocks:[1, 2, 3, 6, 15] lbl75 : MonitorExitStatement: MONITOREXIT : var11_9
                                        Object var10_19 = null;
                                        Thread.currentThread().setContextClassLoader(cl);
                                        lock.releaseSync();
                                        lockMgr.removeLockRef(id);
                                        return;
                                    }
                                    if (!this.isCancelled()) {
                                        try {
                                            PassivationHelper.access$1(this.this$1).passivate(jobCtx);
                                            this.executed();
                                            PassivationHelper.access$1(this.this$1).freeContext(jobCtx);
                                            PassivationHelper.access$1(this.this$1).logPassivation(id);
                                        }
                                        catch (RemoteException x) {
                                            PassivationHelper.access$1(this.this$1).getCache().insert(id, jobCtx);
                                            throw x;
                                        }
                                    }
                                }
                            }
                            Object var10_20 = null;
                            Thread.currentThread().setContextClassLoader(cl);
                            lock.releaseSync();
                            lockMgr.removeLockRef(id);
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var10_21 = null;
                            Thread.currentThread().setContextClassLoader(cl);
                            lock.releaseSync();
                            lockMgr.removeLockRef(id);
                            container = null;
                            jobCtx = null;
                            throw throwable;
                        }
                    }
                };
                Map map = this.m_passivationJobs;
                synchronized (map) {
                    if (this.m_passivationJobs.get(key) != null) {
                        throw new IllegalStateException("Trying to schedule 2 passivation jobs for the same bean");
                    }
                    this.m_passivationJobs.put(key, job);
                    m_passivator.putJob(job);
                }
            }
        }

        protected EnterpriseContext unschedule(Object id) {
            AbstractPassivationJob job = (AbstractPassivationJob)this.m_passivationJobs.get(id);
            if (job != null) {
                job.cancel();
                AbstractPassivationJob abstractPassivationJob = job;
                synchronized (abstractPassivationJob) {
                    if (!job.isExecuted()) {
                        EnterpriseContext enterpriseContext = job.getEnterpriseContext();
                        Object var5_5 = null;
                        return enterpriseContext;
                    }
                }
            }
            return null;
        }
    }
}

