/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.util.HashMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.ejb.CacheKey;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;

public class TxEntityMap {
    protected HashMap m_map = new HashMap();

    public synchronized void associate(Transaction tx, EntityEnterpriseContext entity) throws RollbackException, SystemException {
        HashMap<CacheKey, EntityEnterpriseContext> entityMap = (HashMap<CacheKey, EntityEnterpriseContext>)this.m_map.get(tx);
        if (entityMap == null) {
            entityMap = new HashMap<CacheKey, EntityEnterpriseContext>();
            this.m_map.put(tx, entityMap);
            tx.registerSynchronization((Synchronization)new TxEntityMapCleanup(this, tx));
        }
        EntityContainer.getGlobalTxEntityMap().associate(tx, entity);
        entityMap.put(entity.getCacheKey(), entity);
    }

    public synchronized EntityEnterpriseContext getCtx(Transaction tx, CacheKey key) {
        HashMap entityMap = (HashMap)this.m_map.get(tx);
        if (entityMap == null) {
            return null;
        }
        return (EntityEnterpriseContext)entityMap.get(key);
    }

    private class TxEntityMapCleanup
    implements Synchronization {
        TxEntityMap map;
        Transaction tx;

        public TxEntityMapCleanup(TxEntityMap map, Transaction tx) {
            this.map = map;
            this.tx = tx;
        }

        public void afterCompletion(int status) {
            TxEntityMap txEntityMap = this.map;
            synchronized (txEntityMap) {
                HashMap entityMap = (HashMap)TxEntityMap.this.m_map.remove(this.tx);
                if (entityMap != null) {
                    entityMap.clear();
                }
            }
        }

        public void beforeCompletion() {
        }
    }
}

