/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import org.jboss.ejb.Container;
import org.jboss.ejb.ContainerInvoker;
import org.jboss.ejb.ContainerInvokerContainer;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.InstancePoolContainer;
import org.jboss.ejb.Interceptor;
import org.jboss.ejb.LocalContainerInvoker;
import org.jboss.ejb.MethodInvocation;

public class MessageDrivenContainer
extends Container
implements ContainerInvokerContainer,
InstancePoolContainer {
    protected Map beanMapping;
    protected ContainerInvoker containerInvoker;
    protected InstancePool instancePool;
    protected Interceptor interceptor;

    public void addInterceptor(Interceptor in) {
        if (this.interceptor == null) {
            this.interceptor = in;
        } else {
            Interceptor current = this.interceptor;
            while (current.getNext() != null) {
                current = current.getNext();
            }
            current.setNext(in);
        }
    }

    Interceptor createContainerInterceptor() {
        return new ContainerInterceptor();
    }

    public EJBObject createHome() throws RemoteException, CreateException {
        throw new Error("createHome not valid for MessageDriven beans");
    }

    public void destroy() {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        super.destroy();
        this.containerInvoker.destroy();
        this.instancePool.destroy();
        Interceptor in = this.interceptor;
        while (in != null) {
            in.destroy();
            in = in.getNext();
        }
        Thread.currentThread().setContextClassLoader(oldCl);
    }

    public ContainerInvoker getContainerInvoker() {
        return this.containerInvoker;
    }

    public EJBMetaData getEJBMetaDataHome() throws RemoteException {
        throw new Error("getEJBMetaDataHome not valid for MessageDriven beans");
    }

    public Class getHomeClass() {
        return null;
    }

    public HomeHandle getHomeHandleHome() throws RemoteException {
        throw new Error("getHomeHandleHome not valid for MessageDriven beans");
    }

    public InstancePool getInstancePool() {
        return this.instancePool;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Class getLocalClass() {
        return null;
    }

    public LocalContainerInvoker getLocalContainerInvoker() {
        return this.localContainerInvoker;
    }

    public Class getLocalHomeClass() {
        return null;
    }

    public Class getRemoteClass() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void init() throws Exception {
        try {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            super.init();
            this.setupBeanMapping();
            this.instancePool.init();
            this.containerInvoker.init();
            Interceptor in = this.interceptor;
            while (in != null) {
                in.setContainer(this);
                in.init();
                in = in.getNext();
            }
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        catch (Exception e) {
            void oldCl;
            this.log.error("Serious error in init: ", e);
            throw oldCl;
        }
    }

    public Object invoke(MethodInvocation mi) throws Exception {
        return this.getInterceptor().invoke(mi);
    }

    public Object invokeHome(MethodInvocation mi) throws Exception {
        throw new Error("invokeHome not valid for MessageDriven beans");
    }

    public void removeHome(Object primaryKey) throws RemoteException, RemoveException {
        throw new Error("removeHome not valid for MessageDriven beans");
    }

    public void removeHome(Handle handle) throws RemoteException, RemoveException {
        throw new Error("removeHome not valid for MessageDriven beans");
    }

    public void setContainerInvoker(ContainerInvoker ci) {
        if (ci == null) {
            throw new IllegalArgumentException("Null invoker");
        }
        this.containerInvoker = ci;
        ci.setContainer(this);
    }

    public void setInstancePool(InstancePool ip) {
        if (ip == null) {
            throw new IllegalArgumentException("Null pool");
        }
        this.instancePool = ip;
        ip.setContainer(this);
    }

    protected void setupBeanMapping() throws NoSuchMethodException {
        HashMap<Method, Method> map = new HashMap<Method, Method>();
        String msgInterface = "javax.jms.MessageListener";
        String msgMethod = "onMessage";
        String msgArgument = "javax.jms.Message";
        Class<?> msgInterfaceClass = null;
        Class<?> argumentClass = null;
        try {
            msgInterfaceClass = Class.forName(msgInterface);
            argumentClass = Class.forName(msgArgument);
        }
        catch (ClassNotFoundException ex) {
            this.log.error("Could not get the classes for message interface" + msgInterface, ex);
            throw new NoSuchMethodException("Could not get the classes for message interface" + msgInterface + ": " + ex);
        }
        Method m = msgInterfaceClass.getMethod(msgMethod, argumentClass);
        map.put(m, this.beanClass.getMethod(m.getName(), m.getParameterTypes()));
        this.beanMapping = map;
    }

    public void start() throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        super.start();
        this.containerInvoker.start();
        this.instancePool.start();
        Interceptor in = this.interceptor;
        while (in != null) {
            in.start();
            in = in.getNext();
        }
        Thread.currentThread().setContextClassLoader(oldCl);
    }

    public void stop() {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        super.stop();
        this.containerInvoker.stop();
        this.instancePool.stop();
        Interceptor in = this.interceptor;
        while (in != null) {
            in.stop();
            in = in.getNext();
        }
        Thread.currentThread().setContextClassLoader(oldCl);
    }

    class ContainerInterceptor
    implements Interceptor {
        ContainerInterceptor() {
        }

        public void destroy() {
        }

        public Interceptor getNext() {
            return null;
        }

        public void init() {
        }

        public Object invoke(MethodInvocation mi) throws Exception {
            if (mi.getEnterpriseContext().getTransaction() == null) {
                mi.getEnterpriseContext().setTransaction(mi.getTransaction());
            }
            Method m = (Method)MessageDrivenContainer.this.beanMapping.get(mi.getMethod());
            try {
                return m.invoke(mi.getEnterpriseContext().getInstance(), mi.getArguments());
            }
            catch (IllegalAccessException e) {
                throw new EJBException((Exception)e);
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getTargetException();
                if (ex instanceof EJBException) {
                    throw (EJBException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw new EJBException((Exception)ex);
                }
                if (ex instanceof Exception) {
                    throw (Exception)ex;
                }
                throw (Error)ex;
            }
        }

        public Object invokeHome(MethodInvocation mi) throws Exception {
            throw new Error("invokeHome not valid for MessageDriven beans");
        }

        public void resetStatistic() {
        }

        public Map retrieveStatistic() {
            return null;
        }

        public void sample(Object s) {
        }

        public void setContainer(Container con) {
        }

        public void setNext(Interceptor interceptor) {
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

