/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jboss.ejb.Application;
import org.jboss.ejb.Container;

public class LocalHomeObjectFactory
implements ObjectFactory {
    private static Map applicationMap = Collections.synchronizedMap(new HashMap());
    private static Map containerMap = Collections.synchronizedMap(new HashMap());

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Reference ref = (Reference)obj;
        RefAddr addr = ref.get("nns");
        String key = (String)addr.getContent();
        Object target = LocalHomeObjectFactory.lookup(key);
        return target;
    }

    public static Object lookup(String key) {
        Application app = (Application)applicationMap.get(key);
        Container container = (Container)containerMap.get(key);
        return app.getLocalHome(container);
    }

    public static synchronized void rebind(String key, Application application, Container container) {
        applicationMap.put(key, application);
        containerMap.put(key, container);
    }

    public static void unbind(String key) throws NameNotFoundException {
        if (applicationMap.remove(key) == null) {
            throw new NameNotFoundException(String.valueOf(key) + " was not found in the NonSerializableFactory map");
        }
        containerMap.remove(key);
    }
}

