/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.security.Identity;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.StatelessSessionContainer;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.SecurityRoleRefMetaData;
import org.jboss.security.RealmMapping;
import org.jboss.security.SimplePrincipal;

public abstract class EnterpriseContext {
    protected Logger log = Logger.getLogger(this.getClass());
    private Object instance;
    private WeakReference con;
    Synchronization synch;
    Transaction transaction;
    private Principal principal;
    private Principal beanPrincipal;
    Object id;
    int locked = 0;
    Object txLock = new Object();

    public EnterpriseContext(Object instance, Container con) {
        this.setInstance(instance);
        this.con = new WeakReference<Container>(con);
    }

    public void clear() {
        this.id = null;
        this.locked = 0;
        this.principal = null;
        this.beanPrincipal = null;
        this.synch = null;
        this.transaction = null;
    }

    public abstract void discard() throws RemoteException;

    public Container getContainer() {
        return (Container)this.con.get();
    }

    public abstract EJBContext getEJBContext();

    public Object getId() {
        return this.id;
    }

    public Object getInstance() {
        Object bean = this.instance;
        if (this.log.isTraceEnabled()) {
            this.log.trace("getInstance, ctx=" + this + "bean=" + this.instance);
        }
        return bean;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public Object getTxLock() {
        return this.txLock;
    }

    public boolean isLocked() {
        return this.locked != 0;
    }

    public void lock() {
        ++this.locked;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public void setInstance(Object instance) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("setInstance, ctx=" + this + "bean=" + instance);
        }
        this.instance = instance;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
        this.beanPrincipal = null;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public void unlock() {
        --this.locked;
        if (this.locked < 0) {
            this.log.error("locked < 0", new Throwable());
        }
    }

    protected class EJBContextImpl
    implements EJBContext {
        private UserTransactionImpl userTransaction = null;

        protected EJBContextImpl() {
        }

        public Identity getCallerIdentity() {
            throw new EJBException("Deprecated");
        }

        public Principal getCallerPrincipal() {
            Container container = EnterpriseContext.this.getContainer();
            if (EnterpriseContext.this.beanPrincipal == null) {
                RealmMapping rm = container.getRealmMapping();
                if (EnterpriseContext.this.principal != null) {
                    if (rm != null) {
                        EnterpriseContext.this.beanPrincipal = rm.getPrincipal(EnterpriseContext.this.principal);
                    } else {
                        EnterpriseContext.this.beanPrincipal = EnterpriseContext.this.principal;
                    }
                } else if (rm != null) {
                    EnterpriseContext.this.beanPrincipal = rm.getPrincipal(EnterpriseContext.this.principal);
                } else {
                    ApplicationMetaData appMetaData = container.getBeanMetaData().getApplicationMetaData();
                    String name = appMetaData.getUnauthenticatedPrincipal();
                    if (name != null) {
                        EnterpriseContext.this.beanPrincipal = (Principal)new SimplePrincipal(name);
                    }
                }
            }
            if (EnterpriseContext.this.beanPrincipal == null) {
                throw new IllegalStateException("No security context set");
            }
            return EnterpriseContext.this.beanPrincipal;
        }

        public EJBHome getEJBHome() {
            Container container = EnterpriseContext.this.getContainer();
            if (container instanceof EntityContainer) {
                if (((EntityContainer)container).getContainerInvoker() == null) {
                    throw new IllegalStateException("No remote home defined.");
                }
                return ((EntityContainer)container).getContainerInvoker().getEJBHome();
            }
            if (container instanceof StatelessSessionContainer) {
                if (((StatelessSessionContainer)container).getContainerInvoker() == null) {
                    throw new IllegalStateException("No remote home defined.");
                }
                return ((StatelessSessionContainer)container).getContainerInvoker().getEJBHome();
            }
            if (container instanceof StatefulSessionContainer) {
                if (((StatefulSessionContainer)container).getContainerInvoker() == null) {
                    throw new IllegalStateException("No remote home defined.");
                }
                return ((StatefulSessionContainer)container).getContainerInvoker().getEJBHome();
            }
            throw new EJBException("No EJBHome available (BUG!)");
        }

        public EJBLocalHome getEJBLocalHome() {
            Container container = EnterpriseContext.this.getContainer();
            if (container instanceof EntityContainer) {
                if (((EntityContainer)container).getLocalHomeClass() == null) {
                    throw new IllegalStateException("No local home defined.");
                }
                return ((EntityContainer)container).getLocalContainerInvoker().getEJBLocalHome();
            }
            if (container instanceof StatelessSessionContainer) {
                if (((StatelessSessionContainer)container).getLocalHomeClass() == null) {
                    throw new IllegalStateException("No local home defined.");
                }
                return ((StatelessSessionContainer)container).getLocalContainerInvoker().getEJBLocalHome();
            }
            if (container instanceof StatefulSessionContainer) {
                if (((StatefulSessionContainer)container).getLocalHomeClass() == null) {
                    throw new IllegalStateException("No local home defined.");
                }
                return ((StatefulSessionContainer)container).getLocalContainerInvoker().getEJBLocalHome();
            }
            throw new EJBException("No EJBLocalHome available (BUG!)");
        }

        public Properties getEnvironment() {
            throw new EJBException("Deprecated");
        }

        public boolean getRollbackOnly() {
            Container container = EnterpriseContext.this.getContainer();
            if (container.getBeanMetaData().isBeanManagedTx()) {
                throw new IllegalStateException("ctx.setRollbackOnly() not allowed for BMT beans.");
            }
            try {
                return container.getTransactionManager().getStatus() == 1;
            }
            catch (SystemException e) {
                EnterpriseContext.this.log.warn("failed to set get tx manager status; ignoring", e);
                return true;
            }
        }

        public UserTransaction getUserTransaction() {
            Container container = EnterpriseContext.this.getContainer();
            if (this.userTransaction == null) {
                if (container.getBeanMetaData().isContainerManagedTx()) {
                    throw new IllegalStateException("CMT beans are not allowed to get a UserTransaction");
                }
                this.userTransaction = new UserTransactionImpl();
            }
            return this.userTransaction;
        }

        public boolean isCallerInRole(String id) {
            if (EnterpriseContext.this.principal == null) {
                return false;
            }
            Container container = EnterpriseContext.this.getContainer();
            RealmMapping rm = container.getRealmMapping();
            if (rm == null) {
                String msg = "isCallerInRole() called with no security context. Check that a security-domain has been set for the application.";
                throw new IllegalStateException(msg);
            }
            Iterator it = container.getBeanMetaData().getSecurityRoleReferences();
            boolean matchFound = false;
            while (it.hasNext()) {
                SecurityRoleRefMetaData meta = (SecurityRoleRefMetaData)it.next();
                if (!meta.getName().equals(id)) continue;
                id = meta.getLink();
                matchFound = true;
                break;
            }
            if (!matchFound) {
                EnterpriseContext.this.log.warn("no match found for security role " + id + " in the deployment descriptor.");
            }
            HashSet<SimplePrincipal> set = new HashSet<SimplePrincipal>();
            set.add(new SimplePrincipal(id));
            return rm.doesUserHaveRole(EnterpriseContext.this.principal, set);
        }

        public boolean isCallerInRole(Identity id) {
            throw new EJBException("Deprecated");
        }

        public void setRollbackOnly() {
            Container container = EnterpriseContext.this.getContainer();
            if (container.getBeanMetaData().isBeanManagedTx()) {
                throw new IllegalStateException("ctx.setRollbackOnly() not allowed for BMT beans.");
            }
            try {
                container.getTransactionManager().setRollbackOnly();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SystemException e) {
                EnterpriseContext.this.log.warn("failed to set rollback only; ignoring", e);
            }
        }
    }

    protected class UserTransactionImpl
    implements UserTransaction {
        private int timeout = 0;

        protected UserTransactionImpl() {
        }

        public void begin() throws NotSupportedException, SystemException {
            TransactionManager tm = EnterpriseContext.this.getContainer().getTransactionManager();
            tm.setTransactionTimeout(this.timeout);
            tm.begin();
            EnterpriseContext.this.setTransaction(tm.getTransaction());
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            EnterpriseContext.this.getContainer().getTransactionManager().commit();
        }

        public int getStatus() throws SystemException {
            return EnterpriseContext.this.getContainer().getTransactionManager().getStatus();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            EnterpriseContext.this.getContainer().getTransactionManager().rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            EnterpriseContext.this.getContainer().getTransactionManager().setRollbackOnly();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.timeout = seconds;
        }
    }
}

