/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.scope;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployment.Deployment;
import org.jboss.deployment.J2eeDeploymentException;
import org.jboss.deployment.scope.Scope;

public class ScopedURLClassLoader
extends URLClassLoader {
    protected final Scope scope;
    protected final Deployment deployment;

    public ScopedURLClassLoader(URL[] urls, ClassLoader parent, Deployment deployment, Scope scope) {
        super(urls, parent);
        this.scope = scope;
        this.deployment = deployment;
        scope.registerClassLoader(this);
    }

    public String[] getDependingApplications() {
        try {
            Manifest manifest = this.deployment.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            StringTokenizer tok = new StringTokenizer(attributes.getValue(Attributes.Name.CLASS_PATH), " ");
            ArrayList<String> allDeps = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                allDeps.add(tok.nextToken());
            }
            return allDeps.toArray(new String[allDeps.size()]);
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public URL getResource(String name) {
        URL result = super.getResource(name);
        if (result == null) {
            result = this.scope.getResource(name, this);
        }
        return result;
    }

    protected URL getResourceProperly(String name) {
        return super.getResource(name);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.scope.loadClass(name, resolve, this);
        }
    }

    protected Class loadClassProperly(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    protected void onDeploy() throws J2eeDeploymentException {
    }

    protected void onUndeploy() throws J2eeDeploymentException {
    }
}

