/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.Serializable;
import java.net.URL;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.Manifest;
import org.jboss.deployment.J2eeDeployer;

public class Deployment
implements Serializable {
    public static final int EJB_MODULE = 0;
    public static final int WAR_MODULE = 1;
    public static final int EAR_MODULE = 2;
    public static final int RAR_MODULE = 3;
    protected String name;
    protected int type;
    protected Date date = new Date();
    protected URL localUrl;
    protected URL sourceUrl;
    protected Vector commonUrls;
    protected Vector ejbModules = new Vector();
    protected Vector webModules = new Vector();
    protected transient Manifest manifest;

    Deployment() {
        this.commonUrls = new Vector();
    }

    public void addCommonUrl(URL url) {
        this.commonUrls.add(url);
    }

    public void addEjbModule(String name, URL localJar, URL[] mfUrls) {
        Module m = new Module();
        m.name = name;
        int count = mfUrls != null ? mfUrls.length : 0;
        int u = 0;
        while (u < mfUrls.length) {
            this.commonUrls.add(mfUrls[u]);
            ++u;
        }
        m.localUrls.add(localJar);
        this.ejbModules.add(m);
    }

    public void addWebModule(String name, String webContext, URL localJar, URL[] mfUrls) {
        Module m = new Module();
        m.name = name;
        m.webContext = webContext;
        int count = mfUrls != null ? mfUrls.length : 0;
        int u = 0;
        while (u < mfUrls.length) {
            this.commonUrls.add(mfUrls[u]);
            ++u;
        }
        m.localUrls.add(localJar);
        this.webModules.add(m);
    }

    public Vector getAllFiles() {
        String s;
        Vector<String> result = new Vector<String>();
        Iterator it = ((AbstractList)this.commonUrls).iterator();
        while (it.hasNext()) {
            s = ((URL)it.next()).getFile();
            result.add(s.substring(s.lastIndexOf("/") + 1));
        }
        it = ((AbstractList)this.ejbModules).iterator();
        while (it.hasNext()) {
            s = ((URL)((Module)it.next()).localUrls.firstElement()).getFile();
            result.add(s.substring(s.lastIndexOf("/") + 1));
        }
        it = ((AbstractList)this.webModules).iterator();
        while (it.hasNext()) {
            s = ((URL)((Module)it.next()).localUrls.firstElement()).getFile();
            result.add(s.substring(s.lastIndexOf("/") + 1));
        }
        result.add(J2eeDeployer.CONFIG);
        return result;
    }

    public Vector getCommonUrls() {
        return this.commonUrls;
    }

    public Vector getEjbModules() {
        return this.ejbModules;
    }

    public URL getLocalUrl() {
        return this.localUrl;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public String getName() {
        return this.name;
    }

    public URL getSourceUrl() {
        return this.sourceUrl;
    }

    public Vector getWebModules() {
        return this.webModules;
    }

    public Module newModule() {
        return new Module();
    }

    public String toString() {
        URL u;
        Module m;
        StringBuffer result = new StringBuffer("Deployment, name=" + this.name + ", type=" + this.type + "\n");
        result.append("Date: " + this.date + "\n");
        result.append("LocalUrl: " + this.localUrl + "\n");
        result.append("SourceUrl: " + this.sourceUrl + "\n");
        result.append("CommonUrls: \n");
        Iterator it = ((AbstractList)this.commonUrls).iterator();
        while (it.hasNext()) {
            URL u2 = (URL)it.next();
            result.append(u2.getFile());
            result.append('\n');
        }
        result.append("EjbModules: \n");
        it = ((AbstractList)this.ejbModules).iterator();
        while (it.hasNext()) {
            m = (Module)it.next();
            u = (URL)m.localUrls.firstElement();
            result.append(u.getFile());
            result.append('\n');
        }
        result.append("WebModules: \n");
        it = ((AbstractList)this.webModules).iterator();
        while (it.hasNext()) {
            m = (Module)it.next();
            u = (URL)m.localUrls.firstElement();
            result.append("Context: " + m.webContext + ", ");
            result.append(u.getFile());
            result.append('\n');
        }
        return result.toString();
    }

    public class Module
    implements Serializable {
        protected String name;
        protected Vector localUrls = new Vector();
        protected String webContext;

        protected Module() {
        }

        public Vector getLocalUrls() {
            return this.localUrls;
        }

        public String getName() {
            return this.name;
        }

        public String getWebContext() {
            return this.webContext;
        }
    }
}

