/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlFileLoader {
    private static boolean defaultValidateDTDs = false;
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$metadata$XmlFileLoader != null ? class$org$jboss$metadata$XmlFileLoader : (class$org$jboss$metadata$XmlFileLoader = XmlFileLoader.class$("org.jboss.metadata.XmlFileLoader"))));
    private ClassLoader classLoader;
    private ApplicationMetaData metaData;
    private boolean validateDTDs;
    static /* synthetic */ Class class$org$jboss$metadata$XmlFileLoader;

    public XmlFileLoader() {
        this(defaultValidateDTDs);
    }

    public XmlFileLoader(boolean validateDTDs) {
        this.validateDTDs = validateDTDs;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static boolean getDefaultValidateDTDs() {
        return defaultValidateDTDs;
    }

    public Document getDocument(InputStream is, String inPath) throws DeploymentException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setValidating(this.validateDTDs);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            LocalResolver lr = new LocalResolver();
            LocalErrorHandler eh = new LocalErrorHandler(inPath, lr);
            docBuilder.setEntityResolver(lr);
            docBuilder.setErrorHandler(eh);
            Document doc = docBuilder.parse(is);
            if (this.validateDTDs && eh.hadError()) {
                throw new DeploymentException("Invalid XML: file=" + inPath);
            }
            return doc;
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (SAXParseException e) {
            log.error((Object)(String.valueOf(e.getMessage()) + ":" + e.getColumnNumber() + ":" + e.getLineNumber()), (Throwable)e);
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            System.out.println(e.getException());
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    public static Document getDocument(URL url) throws DeploymentException {
        return XmlFileLoader.getDocument(url, defaultValidateDTDs);
    }

    public static Document getDocument(URL url, boolean validateDTDs) throws DeploymentException {
        XmlFileLoader loader = new XmlFileLoader(validateDTDs);
        return loader.getDocumentFromURL(url);
    }

    public Document getDocumentFromURL(URL url) throws DeploymentException {
        try {
            InputStream is = url.openStream();
            String docPath = url.getPath();
            return this.getDocument(is, docPath);
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to obtain xml doc from URL", (Throwable)e);
        }
    }

    public ApplicationMetaData getMetaData() {
        return this.metaData;
    }

    public boolean getValidateDTDs() {
        return this.validateDTDs;
    }

    public ApplicationMetaData load() throws Exception {
        this.metaData = new ApplicationMetaData();
        URL ejbjarUrl = this.getClassLoader().getResource("META-INF/ejb-jar.xml");
        if (ejbjarUrl == null) {
            throw new DeploymentException("no ejb-jar.xml found");
        }
        Document ejbjarDocument = this.getDocumentFromURL(ejbjarUrl);
        this.metaData.setUrl(ejbjarUrl);
        this.metaData.importEjbJarXml(ejbjarDocument.getDocumentElement());
        URL defaultJbossUrl = Thread.currentThread().getContextClassLoader().getResource("standardjboss.xml");
        if (defaultJbossUrl == null) {
            throw new DeploymentException("no standardjboss.xml found");
        }
        Document defaultJbossDocument = null;
        try {
            defaultJbossDocument = this.getDocumentFromURL(defaultJbossUrl);
            this.metaData.setUrl(defaultJbossUrl);
            this.metaData.importJbossXml(defaultJbossDocument.getDocumentElement());
        }
        catch (Exception ex) {
            log.error((Object)"failed to load standardjboss.xml.  There could be a syntax error.", (Throwable)ex);
            throw ex;
        }
        try {
            URL jbossUrl = this.getClassLoader().getResource("META-INF/jboss.xml");
            if (jbossUrl != null) {
                Document jbossDocument = this.getDocumentFromURL(jbossUrl);
                this.metaData.setUrl(jbossUrl);
                this.metaData.importJbossXml(jbossDocument.getDocumentElement());
            }
        }
        catch (Exception ex) {
            log.error((Object)"failed to load jboss.xml.  There could be a syntax error.", (Throwable)ex);
            throw ex;
        }
        return this.metaData;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public static void setDefaultValidateDTDs(boolean validate) {
        defaultValidateDTDs = validate;
    }

    public void setValidateDTDs(boolean validate) {
        this.validateDTDs = validate;
    }

    private static class LocalResolver
    implements EntityResolver {
        private Hashtable dtds = new Hashtable();
        private boolean hasDTD = false;

        public LocalResolver() {
            this.registerDTD("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", "ejb-jar.dtd");
            this.registerDTD("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "ejb-jar_2_0.dtd");
            this.registerDTD("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "application_1_2.dtd");
            this.registerDTD("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "application_1_3.dtd");
            this.registerDTD("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "connector_1_0.dtd");
            this.registerDTD("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "web-app_2_2.dtd");
            this.registerDTD("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "web-app_2_3.dtd");
            this.registerDTD("-//JBoss//DTD JAWS//EN", "jaws.dtd");
            this.registerDTD("-//JBoss//DTD JAWS 2.4//EN", "jaws_2_4.dtd");
            this.registerDTD("-//JBoss//DTD JBOSS//EN", "jboss.dtd");
            this.registerDTD("-//JBoss//DTD JBOSS 2.4//EN", "jboss_2_4.dtd");
            this.registerDTD("-//JBoss//DTD Web Application 2.2//EN", "jboss-web.dtd");
        }

        public boolean hasDTD() {
            return this.hasDTD;
        }

        public void registerDTD(String publicId, String dtdFileName) {
            this.dtds.put(publicId, dtdFileName);
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            this.hasDTD = false;
            String dtd = (String)this.dtds.get(publicId);
            if (dtd != null) {
                this.hasDTD = true;
                try {
                    InputStream dtdStream = this.getClass().getResourceAsStream(dtd);
                    InputSource aInputSource = new InputSource(dtdStream);
                    return aInputSource;
                }
                catch (Exception exception) {
                }
            }
            return null;
        }
    }

    private static class LocalErrorHandler
    implements ErrorHandler {
        private String theFileName;
        private LocalResolver localResolver;
        private boolean error;

        public LocalErrorHandler(String inFileName, LocalResolver localResolver) {
            this.theFileName = inFileName;
            this.localResolver = localResolver;
            this.error = false;
        }

        public void error(SAXParseException exception) {
            if (this.localResolver.hasDTD()) {
                this.error = true;
                log.error((Object)("XmlFileLoader: File " + this.theFileName + " process error. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage()));
            }
        }

        public void fatalError(SAXParseException exception) {
            if (this.localResolver.hasDTD()) {
                this.error = true;
                log.error((Object)("XmlFileLoader: File " + this.theFileName + " process fatal error. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage()));
            }
        }

        public boolean hadError() {
            return this.error;
        }

        public void warning(SAXParseException exception) {
            if (this.localResolver.hasDTD()) {
                this.error = true;
                log.error((Object)("XmlFileLoader: File " + this.theFileName + " process warning. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage()));
            }
        }
    }
}

