/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.XmlLoadable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class MetaData
implements Cloneable,
XmlLoadable {
    public static final byte TX_NOT_SUPPORTED = 0;
    public static final byte TX_REQUIRED = 1;
    public static final byte TX_SUPPORTS = 2;
    public static final byte TX_REQUIRES_NEW = 3;
    public static final byte TX_MANDATORY = 4;
    public static final byte TX_NEVER = 5;
    public static final byte TX_UNKNOWN = 6;

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    public static Iterator getChildrenByTagName(Element element, String tagName) {
        if (element == null) {
            return null;
        }
        NodeList children = element.getChildNodes();
        ArrayList<Element> goodChildren = new ArrayList<Element>();
        int i = 0;
        while (i < children.getLength()) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeType() == 1 && ((Element)currentChild).getTagName().equals(tagName)) {
                goodChildren.add((Element)currentChild);
            }
            ++i;
        }
        return ((AbstractList)goodChildren).iterator();
    }

    public static String getElementContent(Element element) throws DeploymentException {
        return MetaData.getElementContent(element, null);
    }

    public static String getElementContent(Element element, String defaultStr) throws DeploymentException {
        if (element == null) {
            return defaultStr;
        }
        NodeList children = element.getChildNodes();
        String result = "";
        int i = 0;
        while (i < children.getLength()) {
            result = children.item(i).getNodeType() == 3 || children.item(i).getNodeType() == 4 ? String.valueOf(result) + children.item(i).getNodeValue() : String.valueOf(result) + children.item(i).getFirstChild();
            ++i;
        }
        return result.trim();
    }

    public static Element getOptionalChild(Element element, String tagName) throws DeploymentException {
        return MetaData.getOptionalChild(element, tagName, null);
    }

    public static Element getOptionalChild(Element element, String tagName, Element defaultElement) throws DeploymentException {
        Iterator goodChildren = MetaData.getChildrenByTagName(element, tagName);
        if (goodChildren != null && goodChildren.hasNext()) {
            Element child = (Element)goodChildren.next();
            if (goodChildren.hasNext()) {
                throw new DeploymentException("expected only one " + tagName + " tag");
            }
            return child;
        }
        return defaultElement;
    }

    public static Element getUniqueChild(Element element, String tagName) throws DeploymentException {
        Iterator goodChildren = MetaData.getChildrenByTagName(element, tagName);
        if (goodChildren != null && goodChildren.hasNext()) {
            Element child = (Element)goodChildren.next();
            if (goodChildren.hasNext()) {
                throw new DeploymentException("expected only one " + tagName + " tag");
            }
            return child;
        }
        throw new DeploymentException("expected one " + tagName + " tag");
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
    }

    public void importJbossXml(Element element) throws DeploymentException {
    }

    public void importXml(Element element) throws DeploymentException {
        String rootTag = element.getOwnerDocument().getDocumentElement().getTagName();
        if (rootTag.equals("jboss")) {
            this.importJbossXml(element);
        } else if (rootTag.equals("ejb-jar")) {
            this.importEjbJarXml(element);
        } else {
            throw new DeploymentException("Unrecognized root tag : " + rootTag);
        }
    }

    protected boolean jdk13Enabled() {
        String javaVersion = System.getProperty("java.vm.version");
        return javaVersion.compareTo("1.3") >= 0;
    }
}

