/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.mq.Connection;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.il.ClientIL;
import org.jboss.mq.il.ClientILService;
import org.jboss.mq.il.oil.OILClientIL;

public class OILClientILService
implements Runnable,
ClientILService {
    static Logger log = Logger.getLogger(class$org$jboss$mq$il$oil$OILClientILService != null ? class$org$jboss$mq$il$oil$OILClientILService : (class$org$jboss$mq$il$oil$OILClientILService = OILClientILService.class$("org.jboss.mq.il.oil.OILClientILService")));
    OILClientIL clientIL;
    Thread worker;
    Socket socket = null;
    private Connection connection;
    private boolean running;
    private ServerSocket serverSocket;
    static final int m_close = 2;
    static final int m_deleteTemporaryDestination = 1;
    static final int m_receive = 3;
    static final int m_pong = 4;
    static /* synthetic */ Class class$org$jboss$mq$il$oil$OILClientILService;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public ClientIL getClientIL() throws Exception {
        return this.clientIL;
    }

    public void init(Connection connection, Properties props) throws Exception {
        this.connection = connection;
        this.serverSocket = new ServerSocket(0);
        InetAddress addr = InetAddress.getLocalHost();
        String flag = props.getProperty("org.jboss.mq.il.oil.enableTcpNoDelay", "true");
        boolean enableTcpNoDelay = Boolean.valueOf(flag);
        this.clientIL = new OILClientIL(addr, this.serverSocket.getLocalPort(), enableTcpNoDelay);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean trace;
        ObjectInputStream in;
        ObjectOutputStream out;
        byte code;
        block40: {
            code = 0;
            out = null;
            in = null;
            this.socket = null;
            trace = log.isTraceEnabled();
            try {
                try {
                    if (trace) {
                        log.trace("Waiting for the server to connect to me");
                    }
                    this.serverSocket.setSoTimeout(1000);
                    do {
                        if (this.socket != null) {
                            this.socket.setSoTimeout(0);
                            out = new ObjectOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                            out.flush();
                            in = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
                            break block40;
                        }
                        try {
                            this.socket = this.serverSocket.accept();
                            if (!trace) continue;
                            log.trace("Accepted connection: " + this.socket);
                        }
                        catch (InterruptedIOException interruptedIOException) {
                        }
                        catch (IOException e) {
                            if (this.running) {
                                this.connection.asynchFailure("Error accepting connection from server in OILClientILService.", e);
                            }
                            Object var6_8 = null;
                            try {
                                this.serverSocket.close();
                                this.serverSocket = null;
                                return;
                            }
                            catch (IOException iOException) {}
                            return;
                        }
                    } while (this.running);
                    Object var6_9 = null;
                }
                catch (IOException e) {
                    this.connection.asynchFailure("Could not initialize the OILClientIL Service.", e);
                    Object var6_10 = null;
                    try {}
                    catch (IOException iOException) {}
                    this.serverSocket.close();
                    this.serverSocket = null;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                try {}
                catch (IOException iOException) {}
                this.serverSocket.close();
                this.serverSocket = null;
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            this.serverSocket.close();
            this.serverSocket = null;
            return;
        }
        Object var6_11 = null;
        try {}
        catch (IOException iOException) {}
        this.serverSocket.close();
        this.serverSocket = null;
        while (this.running) {
            block42: {
                try {
                    if (trace) {
                        log.trace("Waiting for a messgage from the server");
                    }
                    code = in.readByte();
                    if (!trace) break block42;
                    log.trace("MethodCode: " + code);
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            try {
                block9 : switch (code) {
                    case 3: {
                        int numReceives = in.readInt();
                        ReceiveRequest[] messages = new ReceiveRequest[numReceives];
                        int i = 0;
                        while (true) {
                            if (i >= numReceives) {
                                this.connection.asynchDeliver(messages);
                                break block9;
                            }
                            messages[i] = new ReceiveRequest();
                            messages[i].readExternal(in);
                            if (trace) {
                                log.trace("Receive msg: " + messages[i]);
                            }
                            ++i;
                        }
                    }
                    case 1: {
                        this.connection.asynchDeleteTemporaryDestination((SpyDestination)in.readObject());
                        break;
                    }
                    case 2: {
                        this.connection.asynchClose();
                        break;
                    }
                    case 4: {
                        this.connection.asynchPong(in.readLong());
                        break;
                    }
                    default: {
                        throw new RemoteException("Bad method code !");
                    }
                }
                try {
                    out.writeByte(0);
                    out.flush();
                }
                catch (IOException e) {
                    this.connection.asynchFailure("Connection failure", e);
                    return;
                }
            }
            catch (Exception e) {
                if (!this.running) break;
                try {
                    log.error(e);
                    out.writeByte(1);
                    out.writeObject(e);
                    out.reset();
                    out.flush();
                }
                catch (IOException e2) {
                    this.connection.asynchFailure("Connection failure", e2);
                    return;
                }
            }
        }
        try {
            if (trace) {
                log.trace("Closing receiver connections.");
            }
            out.close();
            in.close();
            this.socket.close();
            this.socket = null;
            return;
        }
        catch (IOException e) {
            this.connection.asynchFailure("Connection failure", e);
            return;
        }
    }

    public void start() throws Exception {
        this.running = true;
        this.worker = new Thread(Connection.threadGroup, this, "OILClientILService");
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public void stop() throws Exception {
        this.running = false;
        this.worker.interrupt();
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

