/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.RemoteException;
import org.jboss.logging.Logger;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.il.ClientIL;

public class OILClientIL
implements ClientIL,
Serializable {
    private static Logger log = Logger.getLogger(class$org$jboss$mq$il$oil$OILClientIL != null ? class$org$jboss$mq$il$oil$OILClientIL : (class$org$jboss$mq$il$oil$OILClientIL = OILClientIL.class$("org.jboss.mq.il.oil.OILClientIL")));
    static final int m_close = 2;
    static final int m_deleteTemporaryDestination = 1;
    static final int m_receive = 3;
    static final int m_pong = 4;
    private InetAddress addr;
    private int port;
    private boolean enableTcpNoDelay;
    private transient ObjectInputStream in;
    private transient ObjectOutputStream out;
    private transient Socket socket;
    static /* synthetic */ Class class$org$jboss$mq$il$oil$OILClientIL;

    OILClientIL(InetAddress addr, int port) {
        this(addr, port, true);
    }

    OILClientIL(InetAddress addr, int port, boolean enableTcpNoDelay) {
        this.addr = addr;
        this.port = port;
        this.enableTcpNoDelay = enableTcpNoDelay;
    }

    protected void checkSocket() throws Exception {
        if (this.socket == null) {
            this.createConnection();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() throws Exception {
        this.checkSocket();
        this.out.writeByte(2);
        this.waitAnswer();
    }

    protected void createConnection() throws RemoteException {
        try {
            log.debug("ConnectionReceiverOILClient is connecting to: " + this.addr.getHostAddress() + ":" + this.port);
            this.socket = new Socket(this.addr, this.port);
            this.socket.setTcpNoDelay(this.enableTcpNoDelay);
            this.out = new ObjectOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.out.flush();
            this.in = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (Exception e) {
            log.debug(e);
            throw new RemoteException("Cannot connect to the ConnectionReceiver/Server");
        }
    }

    public synchronized void deleteTemporaryDestination(SpyDestination dest) throws Exception {
        this.checkSocket();
        this.out.writeByte(1);
        this.out.writeObject(dest);
        this.waitAnswer();
    }

    public synchronized void pong(long serverTime) throws Exception {
        this.checkSocket();
        this.out.writeByte(4);
        this.out.writeLong(serverTime);
        this.waitAnswer();
    }

    public synchronized void receive(ReceiveRequest[] messages) throws Exception {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Checking socket");
        }
        this.checkSocket();
        if (trace) {
            log.trace("Writing request");
        }
        this.out.writeByte(3);
        this.out.writeInt(messages.length);
        int i = 0;
        while (i < messages.length) {
            messages[i].writeExternal(this.out);
            ++i;
        }
        if (trace) {
            log.trace("Waiting for awnser");
        }
        this.waitAnswer();
        if (trace) {
            log.trace("Done");
        }
    }

    protected void waitAnswer() throws Exception {
        block6: {
            RemoteException throwException = null;
            try {
                this.out.reset();
                this.out.flush();
                byte val = this.in.readByte();
                switch (val) {
                    case 1: {
                        Exception e = (Exception)this.in.readObject();
                        throwException = new RemoteException("", e);
                        break;
                    }
                    default: {
                        if (throwException == null) break block6;
                    }
                }
            }
            catch (IOException e) {
                throw new RemoteException("Cannot contact the remote object", e);
            }
            if (throwException == null) break block6;
            throw throwException;
        }
    }
}

