/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.cluster.transport.udp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Category;
import org.jboss.mq.cluster.transport.InvalidConfigurationException;
import org.jboss.mq.cluster.transport.InvalidStateException;
import org.jboss.mq.cluster.transport.NodeId;
import org.jboss.mq.cluster.transport.Transport;
import org.jboss.mq.cluster.transport.TransportListener;
import org.jboss.mq.cluster.transport.udp.Datagram;
import org.jboss.mq.cluster.transport.udp.UDPAdminStream;
import org.jboss.mq.cluster.transport.udp.UDPNodeId;
import org.jboss.mq.cluster.transport.udp.UDPStream;

public class UDPTransport
implements Transport {
    UDPStream broadcastStream = new UDPStream();
    UDPStream pointStream = new UDPStream();
    UDPAdminStream adminStream = new UDPAdminStream();
    UDPNodeId clusterId = new UDPNodeId();
    UDPNodeId nodeId = new UDPNodeId();
    boolean started = false;
    volatile long stopSendsTill = 0L;
    int maxFragmentSize = 1024;
    private TransportListener transportListener;
    static Category cat = Category.getInstance((Class)(class$org$jboss$mq$cluster$transport$udp$UDPTransport != null ? class$org$jboss$mq$cluster$transport$udp$UDPTransport : (class$org$jboss$mq$cluster$transport$udp$UDPTransport = UDPTransport.class$("org.jboss.mq.cluster.transport.udp.UDPTransport"))));
    static /* synthetic */ Class class$org$jboss$mq$cluster$transport$udp$UDPTransport;

    public UDPTransport() {
        this.broadcastStream.transport = this;
        this.broadcastStream.setName("Broadcast");
        this.pointStream.transport = this;
        this.pointStream.setName("Point");
        this.adminStream.transport = this;
    }

    public void adminSend(UDPNodeId dest, Object message) throws IOException, InterruptedException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(message);
        os.close();
        byte[] data = bos.toByteArray();
        Datagram dg = new Datagram(data.length, 0, this.nodeId, 0, 5, data, 0, data.length);
        dg.setId(this.adminStream.getNextDatagramId());
        cat.debug((Object)("[" + this + "] Sending admin datagram: " + dg.getId()));
        DatagramPacket packet = new DatagramPacket(dg.data, dg.data.length, dest.address, dest.adminPort);
        this.adminStream.socket.send(packet);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public synchronized void close() throws InterruptedException {
    }

    void datagramArrived(Datagram dg) throws InterruptedException {
        cat.debug((Object)("[" + this + "] A datagram arrived"));
        if (dg.isMessageFlagsSet(4)) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(dg.getData());
                ObjectInputStream is = new ObjectInputStream(bais);
                Object o = is.readObject();
                is.close();
                if (o instanceof ResendAdminDatagram) {
                    ResendAdminDatagram radg = (ResendAdminDatagram)o;
                    int i = 0;
                    while (i < radg.datagramIds.length) {
                        cat.debug((Object)("[" + this + "] RESEND REQUEST ARRIVED: " + radg.datagramIds[i]));
                        this.resendDatagram(dg.getSenderId(), radg.datagramIds[i], radg.broadcast);
                        ++i;
                    }
                } else if (o instanceof ResendErrorAdminDatagram) {
                    ResendErrorAdminDatagram readg = (ResendErrorAdminDatagram)o;
                    cat.debug((Object)("[" + this + "] RESEND REQUEST FAILED: " + readg.datagramId));
                    if (readg.broadcast) {
                        this.broadcastStream.removeFromDatagramStream(dg.getSenderId(), readg.datagramId);
                    } else {
                        this.pointStream.removeFromDatagramStream(dg.getSenderId(), readg.datagramId);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            byte[] data;
            if (!this.transportListener.isListeningOn(dg.getTopicId())) {
                return;
            }
            if (dg.getFragmentCount(this.maxFragmentSize) == 1) {
                data = dg.getData();
            } else {
                data = new byte[dg.getLength()];
                int dataPos = 0;
                Datagram f = dg;
                while (f != null) {
                    int i = dataPos;
                    int j = 17;
                    while (j < f.data.length) {
                        data[i] = f.data[j];
                        ++i;
                        ++j;
                    }
                    dataPos += f.data.length - 17;
                    f = f.nextFragment;
                }
            }
            this.transportListener.messageArrivedEvent(dg.getTopicId(), dg.getSenderId(), data);
        }
    }

    public NodeId getLocalNodeId() {
        return this.nodeId;
    }

    void requestResend(UDPNodeId nodeId, Vector messageIds, boolean broadcast) {
        int MAX_RESEND_ARRAY_SIZE = 100;
        int[] msgs = new int[messageIds.size() < MAX_RESEND_ARRAY_SIZE ? messageIds.size() : MAX_RESEND_ARRAY_SIZE];
        int i = 0;
        while (i < msgs.length) {
            msgs[i] = (Integer)messageIds.elementAt(i);
            ++i;
        }
        cat.debug((Object)("[" + this + "] SENDING RESEND REQUEST: " + messageIds));
        ResendAdminDatagram m = new ResendAdminDatagram(msgs, broadcast);
        try {
            this.adminSend(nodeId, m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void resendDatagram(UDPNodeId requestor, int messageId, boolean broadcast) throws InterruptedException, IOException {
        Datagram dg;
        this.slowDownSendRate();
        if (broadcast) {
            dg = this.broadcastStream.getFromSentCache(messageId);
            if (dg != null) {
                cat.debug((Object)("[" + this + "] BROADCAST RESEND REQUEST SERVICED: " + messageId));
                this.send(dg, false);
                return;
            }
            cat.debug((Object)("[" + this + "] BROADCAST RESEND REQUEST NOT SERVICED (not in cache): " + messageId));
        } else {
            dg = this.pointStream.getFromSentCache(messageId);
            if (dg != null) {
                cat.debug((Object)("[" + this + "] POINT RESEND REQUEST SERVICED: " + messageId));
                this.send(requestor, dg, false);
                return;
            }
            cat.debug((Object)("[" + this + "] POINT RESEND REQUEST NOT SERVICED (not in cache): " + messageId));
        }
        ResendErrorAdminDatagram error = new ResendErrorAdminDatagram(messageId, broadcast);
        this.adminSend(requestor, error);
    }

    public void send(NodeId dest, short channelId, byte[] data, boolean droppable, boolean keepOrder) throws IOException, InterruptedException {
        int length = data.length;
        short fragmentId = 0;
        byte msgFlags = 0;
        if (droppable) {
            msgFlags = (byte)(msgFlags | 1);
        }
        if (keepOrder) {
            msgFlags = (byte)(msgFlags | 2);
        }
        Datagram firstFragment = null;
        Datagram lastFragment = null;
        long waitLeft = this.stopSendsTill - System.currentTimeMillis();
        while (waitLeft > 0L) {
            Thread.sleep(waitLeft);
            waitLeft = this.stopSendsTill - System.currentTimeMillis();
        }
        while (fragmentId * this.maxFragmentSize < length) {
            Datagram dg = length - fragmentId * this.maxFragmentSize > this.maxFragmentSize ? new Datagram(length, fragmentId, this.nodeId, channelId, msgFlags, data, fragmentId * this.maxFragmentSize, this.maxFragmentSize) : new Datagram(length, fragmentId, this.nodeId, channelId, msgFlags, data, fragmentId * this.maxFragmentSize, length - fragmentId * this.maxFragmentSize);
            fragmentId = (short)(fragmentId + 1);
            if (firstFragment == null) {
                firstFragment = lastFragment = dg;
                continue;
            }
            lastFragment.nextFragment = dg;
            lastFragment = dg;
        }
        if (dest == null) {
            this.send(firstFragment);
        } else {
            this.send((UDPNodeId)dest, firstFragment);
        }
    }

    synchronized void send(Datagram dg) throws InterruptedException, IOException {
        this.send(dg, true);
    }

    synchronized void send(Datagram dg, boolean setDatagramId) throws InterruptedException, IOException {
        int id = 0;
        if (setDatagramId) {
            id = this.broadcastStream.getNextDatagramId();
            dg.setId(id);
        }
        this.broadcastStream.addToSentCache(dg);
        cat.debug((Object)("[" + this + "] Sending Broadcast datagram: " + dg.getId()));
        while (dg != null) {
            if (setDatagramId) {
                dg.setId(id);
            }
            DatagramPacket packet = new DatagramPacket(dg.data, dg.data.length, this.clusterId.address, this.clusterId.port);
            this.broadcastStream.socket.send(packet);
            dg = dg.nextFragment;
        }
    }

    synchronized void send(UDPNodeId dest, Datagram dg) throws InterruptedException, IOException {
        this.send(dest, dg, true);
    }

    synchronized void send(UDPNodeId dest, Datagram dg, boolean setDatagramId) throws InterruptedException, IOException {
        int id = 0;
        if (setDatagramId) {
            id = this.broadcastStream.getNextDatagramId();
            dg.setId(id);
        }
        this.pointStream.addToSentCache(dg);
        cat.debug((Object)("[" + this + "] Sending Point datagram: " + dg.getId()));
        while (dg != null) {
            if (setDatagramId) {
                dg.setId(id);
            }
            DatagramPacket packet = new DatagramPacket(dg.data, dg.data.length, dest.address, dest.port);
            this.pointStream.socket.send(packet);
            dg = dg.nextFragment;
        }
    }

    public void send(short channelId, byte[] data, boolean droppable, boolean keepOrder) throws IOException, InterruptedException {
        this.send(null, channelId, data, droppable, keepOrder);
    }

    public synchronized void setProperties(Properties t) throws InvalidConfigurationException, InvalidStateException {
        if (this.started) {
            throw new InvalidStateException("Transport is allready started");
        }
        String transportMode = t.getProperty("TransportMode");
        String groupString = t.getProperty("Group");
        String portString = t.getProperty("Port");
        String nodeInterfaceString = t.getProperty("NodeInterface");
        String nodePortString = t.getProperty("NodePort");
        if (transportMode == null) {
            throw new InvalidConfigurationException("TransportMode property not set");
        }
        if (transportMode.equals("Multicast")) {
            if (portString == null) {
                throw new InvalidConfigurationException("Port property not set");
            }
            if (groupString == null) {
                throw new InvalidConfigurationException("Group property not set");
            }
            try {
                DatagramSocket pointSocket;
                InetAddress group = InetAddress.getByName(groupString);
                int port = Integer.parseInt(portString);
                MulticastSocket broadcastSocket = new MulticastSocket(port);
                broadcastSocket.joinGroup(group);
                this.nodeId.address = nodeInterfaceString != null ? InetAddress.getByName(nodeInterfaceString) : InetAddress.getLocalHost();
                broadcastSocket.setInterface(this.nodeId.address);
                if (nodePortString != null) {
                    this.nodeId.port = Integer.parseInt(nodePortString);
                    pointSocket = new DatagramSocket(this.nodeId.port);
                } else {
                    pointSocket = new DatagramSocket();
                    this.nodeId.port = pointSocket.getLocalPort();
                }
                DatagramSocket adminSocket = new DatagramSocket();
                this.nodeId.adminPort = adminSocket.getLocalPort();
                cat.debug((Object)("[" + this + "] Local NodeId: " + this.nodeId));
                this.clusterId.address = group;
                this.clusterId.port = port;
                this.broadcastStream.socket = broadcastSocket;
                this.pointStream.socket = pointSocket;
                this.adminStream.socket = adminSocket;
            }
            catch (IOException e) {
                throw new InvalidConfigurationException("Ip group of the Group property was invalid: " + e.getMessage());
            }
        } else {
            throw new InvalidConfigurationException("TransportMode property invalid");
        }
    }

    public void setTransportListener(TransportListener c) {
        this.transportListener = c;
    }

    public void slowDownSendRate() {
        this.stopSendsTill = System.currentTimeMillis() + 1000L;
    }

    public synchronized void start() throws InvalidStateException {
        if (this.broadcastStream.socket == null) {
            throw new InvalidStateException("The transport properties have not been set yet.");
        }
        this.started = true;
        this.broadcastStream.start();
        this.pointStream.start();
        this.adminStream.start();
    }

    public synchronized void stop() throws InterruptedException {
        this.broadcastStream.stop();
        this.pointStream.stop();
        this.adminStream.stop();
        this.started = false;
    }

    static class ResendAdminDatagram
    implements Serializable {
        int[] datagramIds;
        boolean broadcast;

        ResendAdminDatagram(int[] j, boolean b) {
            this.datagramIds = j;
            this.broadcast = b;
        }
    }

    static class ResendErrorAdminDatagram
    implements Serializable {
        int datagramId;
        boolean broadcast;

        ResendErrorAdminDatagram(int j, boolean b) {
            this.datagramId = j;
            this.broadcast = b;
        }
    }
}

