/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.cluster.transport.udp;

import org.jboss.mq.cluster.transport.SerializerUtil;
import org.jboss.mq.cluster.transport.udp.UDPNodeId;

class Datagram {
    byte[] data;
    UDPNodeId senderId;
    Datagram nextFragment;
    public static final byte DROPPABLE_FLAG = 1;
    public static final byte KEEP_ORDER_FLAG = 2;
    public static final byte ADMIN_FLAG = 4;
    static final int ID_OFFSET = 0;
    static final int LENGTH_OFFSET = 4;
    static final int FRAGMENT_ID_OFFSET = 8;
    static final int SENDER_ID_OFFSET = 10;
    static final int TOPIC_ID_OFFSET = 14;
    static final byte MESSAGE_FLAGS_OFFSET = 16;
    static final int HEADER_SIZE = 17;

    Datagram(int length, short fragmentId, UDPNodeId senderId, short topic, byte messageFlags, byte[] payload, int offset, int len) {
        this.data = new byte[len + 17];
        SerializerUtil.writeIntTo(length, this.data, 4);
        SerializerUtil.writeShortTo(fragmentId, this.data, 8);
        senderId.writeToByteArray(this.data, 10);
        SerializerUtil.writeShortTo(topic, this.data, 14);
        this.data[16] = messageFlags;
        int i = 17;
        int j = offset;
        while (i < this.data.length) {
            this.data[i] = payload[j];
            ++i;
            ++j;
        }
    }

    Datagram(byte[] datagram, int length) {
        this.data = new byte[length];
        int i = 0;
        while (i < length) {
            this.data[i] = datagram[i];
            ++i;
        }
    }

    byte[] getData() {
        byte[] newData = new byte[this.data.length - 17];
        int i = 0;
        int j = 17;
        while (j < this.data.length) {
            newData[i] = this.data[j];
            ++i;
            ++j;
        }
        return newData;
    }

    int getFragmentCount(int maxFragmentSize) {
        return this.getLength() / maxFragmentSize + (this.getLength() % maxFragmentSize == 0 ? 0 : 1);
    }

    short getFragmentId() {
        return SerializerUtil.readShortFrom(this.data, 8);
    }

    int getId() {
        return SerializerUtil.readIntFrom(this.data, 0);
    }

    int getLength() {
        return SerializerUtil.readIntFrom(this.data, 4);
    }

    byte getMessageFlags() {
        return this.data[16];
    }

    UDPNodeId getSenderId() {
        if (this.senderId != null) {
            return this.senderId;
        }
        UDPNodeId t = new UDPNodeId();
        t.readFromByteArray(this.data, 10);
        this.senderId = t;
        return t;
    }

    short getTopicId() {
        return SerializerUtil.readShortFrom(this.data, 14);
    }

    boolean isMessageFlagsSet(int flags) {
        return (this.data[16] & flags) == flags;
    }

    void setId(int id) {
        SerializerUtil.writeIntTo(id, this.data, 0);
    }
}

