/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.util.LinkedList;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.transaction.xa.XAException;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyConsumer;
import org.jboss.mq.SpyEncapsulatedMessage;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpySession;
import org.jboss.mq.Subscription;

public class SpyMessageConsumer
implements MessageConsumer,
SpyConsumer,
Runnable {
    static Logger log = Logger.getLogger(class$org$jboss$mq$SpyMessageConsumer != null ? class$org$jboss$mq$SpyMessageConsumer : (class$org$jboss$mq$SpyMessageConsumer = SpyMessageConsumer.class$("org.jboss.mq.SpyMessageConsumer")));
    static int listenerCount;
    public SpySession session;
    public Subscription subscription = new Subscription();
    protected boolean closed;
    protected Object stateLock = new Object();
    protected boolean receiving = false;
    protected boolean waitingForMessage = false;
    protected boolean listening = false;
    protected Thread listenerThread = null;
    MessageListener messageListener;
    LinkedList messages;
    boolean sessionConsumer;
    boolean trace;
    static /* synthetic */ Class class$org$jboss$mq$SpyMessageConsumer;

    SpyMessageConsumer(SpySession s, boolean sessionConsumer) {
        this.session = s;
        this.sessionConsumer = sessionConsumer;
        this.messageListener = null;
        this.closed = false;
        this.messages = new LinkedList();
        this.trace = log.isTraceEnabled();
    }

    public void addMessage(SpyMessage message) throws JMSException {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            if (this.closed) {
                log.debug("WARNING: NACK issued. The message consumer was closed.");
                this.session.connection.send(message.getAcknowledgementRequest(false));
                Object var3_3 = null;
                return;
            }
            if (this.subscription.accepts(message)) {
                if (this.sessionConsumer) {
                    this.sessionConsumerProcessMessage(message);
                } else if (this.waitingForMessage) {
                    if (this.trace) {
                        log.trace("addMessage: " + message);
                    }
                    this.messages.addLast(message);
                    this.messages.notifyAll();
                } else {
                    log.debug("WARNING: NACK issued. The message consumer was not waiting for a message.");
                    this.session.connection.send(message.getAcknowledgementRequest(false));
                }
            } else {
                log.debug("WARNING: NACK issued. The subscription did not accept the message");
                this.session.connection.send(message.getAcknowledgementRequest(false));
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() throws JMSException {
        log.debug("Message consumer closing.");
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            if (this.closed) {
                Object var2_2 = null;
                return;
            }
            this.closed = true;
            this.messages.notify();
        }
        if (this.listenerThread != null && !Thread.currentThread().equals(this.listenerThread)) {
            try {
                this.listenerThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.sessionConsumer) {
            this.session.removeConsumer(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Message getMessage() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            while (true) {
                try {
                    SpyMessage mes;
                    Message rc;
                    do {
                        if (this.messages.size() != 0) continue;
                        return null;
                    } while ((rc = this.preProcessMessage(mes = (SpyMessage)this.messages.removeFirst())) == null);
                    return rc;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        return this.messageListener;
    }

    public String getMessageSelector() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        return this.subscription.messageSelector;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    protected boolean isListening() {
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = this.listening;
            Object var3_3 = null;
            return bl;
        }
    }

    Message preProcessMessage(SpyMessage message) throws JMSException {
        message.session = this.session;
        if (message.isOutdated()) {
            log.debug("I dropped a message (timeout)");
            message.doAcknowledge();
            return null;
        }
        if (!this.isListening()) {
            boolean doAck;
            boolean bl = doAck = this.session.acknowledgeMode == 1 || this.session.acknowledgeMode == 3;
            if (this.session.transacted) {
                this.session.connection.spyXAResourceManager.ackMessage(this.session.currentTransactionId, message);
            } else if (doAck) {
                message.doAcknowledge();
            } else {
                this.session.addUnacknowledgedMessage(message);
            }
            if (message instanceof SpyEncapsulatedMessage) {
                return ((SpyEncapsulatedMessage)message).getMessage();
            }
            return message;
        }
        return message;
    }

    /*
     * Exception decompiling
     */
    public Message receive() throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 4[TRYBLOCK]], but top level block is 31[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Message receive(long timeOut) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK], 3[TRYBLOCK]], but top level block is 36[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Message receiveNoWait() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            if (this.listening) {
                throw new JMSException("A message listener is already registered");
            }
            this.receiving = true;
        }
        Object object2 = this.messages;
        synchronized (object2) {
            Message message = this.getMessage();
            if (message != null) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.receiving = false;
                }
                object = message;
                Object var3_5 = null;
                return object;
            }
        }
        SpyMessage msg = this.session.connection.receive(this.subscription, -1L);
        object2 = this.stateLock;
        synchronized (object2) {
            this.receiving = false;
        }
        if (msg == null) {
            return null;
        }
        return this.preProcessMessage(msg);
    }

    public void run() {
        SpyMessage mes = null;
        try {
            while (true) {
                boolean doAck;
                MessageListener thisListener;
                Object object;
                block26: {
                    block29: {
                        if (mes != null) break block26;
                        LinkedList linkedList = this.messages;
                        synchronized (linkedList) {
                            block30: {
                                block28: {
                                    block27: {
                                        if (!this.closed) break block27;
                                        this.waitingForMessage = false;
                                        break block28;
                                    }
                                    mes = this.session.connection.receive(this.subscription, 0L);
                                    if (mes != null) break block29;
                                    this.waitingForMessage = true;
                                    while (this.messages.isEmpty() && !this.closed) {
                                        try {
                                            this.messages.wait();
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    if (!this.closed) break block30;
                                    this.waitingForMessage = false;
                                }
                                object = null;
                                break;
                            }
                            mes = (SpyMessage)this.messages.removeFirst();
                            this.waitingForMessage = false;
                        }
                    }
                    if (this.trace) {
                        log.trace("Recevied msg: " + mes);
                    }
                    mes.session = this.session;
                    if (!mes.isOutdated()) continue;
                    if (this.trace) {
                        log.trace("Droping expired msg: " + mes);
                    }
                    mes.doAcknowledge();
                    mes = null;
                    continue;
                }
                object = this.stateLock;
                synchronized (object) {
                    if (!this.isListening()) {
                        if (mes != null) {
                            this.session.connection.send(mes.getAcknowledgementRequest(false));
                        }
                        this.listenerThread = null;
                        mes = null;
                        Object var4_6 = null;
                        break;
                    }
                    thisListener = this.messageListener;
                }
                SpyMessage message = mes;
                if (mes instanceof SpyEncapsulatedMessage) {
                    message = ((SpyEncapsulatedMessage)mes).getMessage();
                }
                if (this.session.transacted) {
                    this.session.connection.spyXAResourceManager.ackMessage(this.session.currentTransactionId, mes);
                }
                try {
                    this.session.addUnacknowledgedMessage(mes);
                    thisListener.onMessage((Message)message);
                }
                catch (RuntimeException runtimeException) {
                    log.warn("Message listener " + thisListener + " threw a RuntimeException.");
                }
                boolean bl = doAck = this.session.acknowledgeMode == 1 || this.session.acknowledgeMode == 3;
                if (!this.session.transacted && doAck) {
                    mes.doAcknowledge();
                }
                mes = null;
            }
        }
        catch (JMSException e) {
            log.warn("Message consumer closing due to error in listening thread.", e);
            try {
                this.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void sessionConsumerProcessMessage(SpyMessage message) throws JMSException {
        MessageListener thisListener;
        message.session = this.session;
        if (message.isOutdated()) {
            log.debug("I dropped a message (timeout)");
            message.doAcknowledge();
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            thisListener = this.messageListener;
        }
        Object anonymousTXID = null;
        if (this.session.transacted) {
            if (this.session.currentTransactionId == null) {
                this.session.currentTransactionId = anonymousTXID = this.session.connection.spyXAResourceManager.startTx();
            }
            this.session.connection.spyXAResourceManager.ackMessage(this.session.currentTransactionId, message);
        }
        if (thisListener != null) {
            SpyMessage mes = message;
            if (message instanceof SpyEncapsulatedMessage) {
                mes = ((SpyEncapsulatedMessage)message).getMessage();
            }
            thisListener.onMessage((Message)mes);
        }
        if (this.session.transacted) {
            if (anonymousTXID != null && this.session.currentTransactionId == anonymousTXID) {
                try {
                    try {
                        this.session.connection.spyXAResourceManager.endTx(anonymousTXID, true);
                        this.session.connection.spyXAResourceManager.rollback(anonymousTXID);
                    }
                    catch (XAException e) {
                        log.error("Could not rollback", e);
                    }
                    Object var5_7 = null;
                    this.session.currentTransactionId = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.session.currentTransactionId = null;
                    throw throwable;
                }
                throw new SpyJMSException("Messaged delivery was not controled by a Transaction Manager");
            }
        } else if (this.session.acknowledgeMode == 1 || this.session.acknowledgeMode == 3) {
            message.doAcknowledge();
        }
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            boolean oldListening = this.listening;
            this.listening = listener != null;
            this.messageListener = listener;
            if (!this.sessionConsumer && this.listening && !oldListening && this.listenerThread == null) {
                int id = 0;
                Class clazz = class$org$jboss$mq$SpyMessageConsumer != null ? class$org$jboss$mq$SpyMessageConsumer : (class$org$jboss$mq$SpyMessageConsumer = SpyMessageConsumer.class$("org.jboss.mq.SpyMessageConsumer"));
                synchronized (clazz) {
                    id = listenerCount++;
                }
                String threadName = "MessageListenerThread#" + id + " - " + this.subscription.destination.getName();
                this.listenerThread = new Thread((Runnable)this, threadName);
                if (this.trace) {
                    log.trace(String.valueOf(String.valueOf(this)) + ".setMessageListener=" + this.messageListener + ", thread=" + this.listenerThread);
                }
                this.listenerThread.start();
            }
        }
    }

    public String toString() {
        return "SpyMessageConsumer:" + this.subscription.destination;
    }
}

