/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.DurableSubcriptionID;
import org.jboss.mq.SpyBytesMessage;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyEncapsulatedMessage;
import org.jboss.mq.SpyMapMessage;
import org.jboss.mq.SpyObjectMessage;
import org.jboss.mq.SpySession;
import org.jboss.mq.SpyStreamMessage;
import org.jboss.mq.SpyTextMessage;

public class SpyMessage
implements Serializable,
Message,
Comparable,
Externalizable {
    public static final int DEFAULT_DELIVERY_MODE = 2;
    public static final int DEFAULT_PRIORITY = 4;
    public static final int DEFAULT_TIME_TO_LIVE = 0;
    private Destination jmsDestination = null;
    private int jmsDeliveryMode = -1;
    private long jmsExpiration = 0L;
    private int jmsPriority = -1;
    private String jmsMessageID = null;
    private long jmsTimeStamp = 0L;
    private boolean jmsCorrelationID = true;
    private String jmsCorrelationIDString = null;
    private byte[] jmsCorrelationIDbyte = null;
    private Destination jmsReplyTo = null;
    private String jmsType = null;
    private boolean jmsRedelivered = false;
    private Hashtable prop = new Hashtable();
    public boolean propReadWrite = true;
    public boolean msgReadOnly = false;
    public String producerClientId;
    public DurableSubcriptionID durableSubscriberID = null;
    public transient SpySession session;
    public transient long messageId;
    public transient Object persistData;
    public transient int routeToSubscriber;
    private static final long serialVersionUID = 467206190892964404L;
    protected static final byte OBJECT_MESS = 1;
    protected static final byte BYTES_MESS = 2;
    protected static final byte MAP_MESS = 3;
    protected static final byte TEXT_MESS = 4;
    protected static final byte STREAM_MESS = 5;
    protected static final byte ENCAP_MESS = 6;
    protected static final byte SPY_MESS = 7;
    protected static final byte TEXT_MESS_V2 = 8;
    protected static final int BYTE = 0;
    protected static final int SHORT = 1;
    protected static final int INT = 2;
    protected static final int LONG = 3;
    protected static final int FLOAT = 4;
    protected static final int DOUBLE = 5;
    protected static final int BOOLEAN = 6;
    protected static final int STRING = 7;
    protected static final int OBJECT = 8;
    protected static final int NULL = 9;
    protected static final int V2_MSG_INDICATOR = 10;

    void CheckPropertyName(String name) throws JMSException {
        if (name.regionMatches(false, 0, "JMS_", 0, 4)) {
            throw new JMSException("Bad property name");
        }
        if (name.regionMatches(false, 0, "JMSX", 0, 4)) {
            if (name.equals("JMSXGroupId")) {
                return;
            }
            if (name.equals("JMSXGroupSeq")) {
                return;
            }
            throw new JMSException("Bad property name");
        }
    }

    public void acknowledge() throws JMSException {
        if (this.session == null) {
            throw new JMSException("This message was not recieved from the provider");
        }
        if (this.session.acknowledgeMode == 2) {
            this.doAcknowledge();
        }
    }

    public void clearBody() throws JMSException {
        this.msgReadOnly = false;
    }

    public void clearProperties() throws JMSException {
        this.prop = new Hashtable();
        this.propReadWrite = true;
    }

    public int compareTo(Object o) {
        SpyMessage sm = (SpyMessage)o;
        if (this.jmsPriority > sm.jmsPriority) {
            return -1;
        }
        if (this.jmsPriority < sm.jmsPriority) {
            return 1;
        }
        return (int)(this.messageId - sm.messageId);
    }

    public void copyProps(SpyMessage original) throws JMSException {
        try {
            this.setJMSCorrelationID(original.getJMSCorrelationID());
        }
        catch (JMSException jMSException) {
            this.setJMSCorrelationIDAsBytes(original.getJMSCorrelationIDAsBytes());
        }
        this.setJMSDeliveryMode(original.getJMSDeliveryMode());
        this.setJMSDestination(original.getJMSDestination());
        this.setJMSExpiration(original.getJMSExpiration());
        this.setJMSMessageID(original.getJMSMessageID());
        this.setJMSPriority(original.getJMSPriority());
        this.setJMSRedelivered(original.getJMSRedelivered());
        this.setJMSReplyTo(original.getJMSReplyTo());
        this.setJMSTimestamp(original.getJMSTimestamp());
        this.setJMSType(original.getJMSType());
        Enumeration en = original.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            this.prop.put(key, original.prop.get(key));
        }
        this.propReadWrite = original.propReadWrite;
        this.msgReadOnly = original.msgReadOnly;
        this.producerClientId = original.producerClientId;
        if (original.durableSubscriberID != null) {
            this.durableSubscriberID = new DurableSubcriptionID(original.durableSubscriberID.clientID, original.durableSubscriberID.subscriptionName);
        }
    }

    public void doAcknowledge() throws JMSException {
        if (this.session.closed) {
            throw new IllegalStateException("Session is closed.");
        }
        this.session.doAcknowledge(this, this.getAcknowledgementRequest(true));
    }

    public void doNegAcknowledge() throws JMSException {
        if (this.session.closed) {
            throw new IllegalStateException("Session is closed.");
        }
        this.session.doAcknowledge(this, this.getAcknowledgementRequest(false));
    }

    public AcknowledgementRequest getAcknowledgementRequest(boolean isAck) throws JMSException {
        AcknowledgementRequest item = new AcknowledgementRequest();
        item.destination = this.jmsDestination;
        item.messageID = this.jmsMessageID;
        item.isAck = isAck;
        item.subscriberId = this.routeToSubscriber;
        return item;
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.prop.get(name);
        if (value == null) {
            return Boolean.valueOf(null);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value = this.prop.get(name);
        if (value == null) {
            return Byte.valueOf(null);
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object value = this.prop.get(name);
        if (value == null) {
            return Double.valueOf(null);
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public float getFloatProperty(String name) throws JMSException {
        Object value = this.prop.get(name);
        if (value == null) {
            return Float.valueOf(null).floatValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public int getIntProperty(String name) throws JMSException {
        Object value = this.prop.get(name);
        if (value == null) {
            return Integer.valueOf(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public String getJMSCorrelationID() throws JMSException {
        if (!this.jmsCorrelationID) {
            throw new JMSException("JMSCorrelationID is an array");
        }
        return this.jmsCorrelationIDString;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (this.jmsCorrelationID) {
            throw new JMSException("JMSCorrelationID is a string");
        }
        return this.jmsCorrelationIDbyte;
    }

    public int getJMSDeliveryMode() {
        return this.jmsDeliveryMode;
    }

    public Destination getJMSDestination() {
        return this.jmsDestination;
    }

    public long getJMSExpiration() {
        return this.jmsExpiration;
    }

    public String getJMSMessageID() {
        return this.jmsMessageID;
    }

    public int getJMSPriority() {
        return this.jmsPriority;
    }

    public boolean getJMSRedelivered() {
        return this.jmsRedelivered;
    }

    public Destination getJMSReplyTo() {
        return this.jmsReplyTo;
    }

    public long getJMSTimestamp() {
        return this.jmsTimeStamp;
    }

    public String getJMSType() {
        return this.jmsType;
    }

    public long getLongProperty(String name) throws JMSException {
        Object value = this.prop.get(name);
        if (value == null) {
            return Long.valueOf(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public Object getObjectProperty(String name) throws JMSException {
        Object value = this.prop.get(name);
        return value;
    }

    public Enumeration getPropertyNames() throws JMSException {
        return this.prop.keys();
    }

    public short getShortProperty(String name) throws JMSException {
        Object value = this.prop.get(name);
        if (value == null) {
            return Short.valueOf(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public String getStringProperty(String name) throws JMSException {
        Object value = this.prop.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return ((Boolean)value).toString();
        }
        if (value instanceof Byte) {
            return ((Byte)value).toString();
        }
        if (value instanceof Short) {
            return ((Short)value).toString();
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value instanceof Long) {
            return ((Long)value).toString();
        }
        if (value instanceof Float) {
            return ((Float)value).toString();
        }
        if (value instanceof Double) {
            return ((Double)value).toString();
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public boolean isOutdated() {
        if (this.jmsExpiration == 0L) {
            return false;
        }
        long ts = System.currentTimeMillis();
        return this.jmsExpiration < ts;
    }

    public SpyMessage myClone() throws JMSException {
        SpyMessage result = new SpyMessage();
        result.copyProps(this);
        return result;
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.prop.containsKey(name);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jmsDestination = SpyDestination.readDest(in);
        this.jmsDeliveryMode = in.readInt();
        this.jmsExpiration = in.readLong();
        this.jmsPriority = in.readInt();
        this.jmsMessageID = SpyMessage.readString(in);
        this.jmsTimeStamp = in.readLong();
        this.jmsCorrelationID = in.readBoolean();
        this.jmsCorrelationIDString = SpyMessage.readString(in);
        int length = in.readInt();
        if (length < 0) {
            this.jmsCorrelationIDbyte = null;
        } else {
            this.jmsCorrelationIDbyte = new byte[length];
            in.readFully(this.jmsCorrelationIDbyte);
        }
        this.jmsReplyTo = SpyDestination.readDest(in);
        this.jmsType = SpyMessage.readString(in);
        this.jmsRedelivered = in.readBoolean();
        this.propReadWrite = in.readBoolean();
        this.msgReadOnly = in.readBoolean();
        this.producerClientId = SpyMessage.readString(in);
        this.prop = new Hashtable();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            String key = in.readUTF();
            byte type = in.readByte();
            Object value = null;
            switch (type) {
                case 0: {
                    value = new Byte(in.readByte());
                    break;
                }
                case 1: {
                    value = new Short(in.readShort());
                    break;
                }
                case 2: {
                    value = new Integer(in.readInt());
                    break;
                }
                case 3: {
                    value = new Long(in.readLong());
                    break;
                }
                case 4: {
                    value = new Float(in.readFloat());
                    break;
                }
                case 5: {
                    value = new Double(in.readDouble());
                    break;
                }
                case 6: {
                    value = new Boolean(in.readBoolean());
                    break;
                }
                case 7: {
                    value = in.readUTF();
                    break;
                }
                default: {
                    value = in.readObject();
                }
            }
            this.prop.put(key, value);
            ++i;
        }
    }

    public static SpyMessage readMessage(ObjectInput in) throws IOException {
        SpyMessage message = null;
        byte type = in.readByte();
        switch (type) {
            case 1: {
                message = new SpyObjectMessage();
                break;
            }
            case 2: {
                message = new SpyBytesMessage();
                break;
            }
            case 3: {
                message = new SpyMapMessage();
                break;
            }
            case 5: {
                message = new SpyStreamMessage();
                break;
            }
            case 4: 
            case 8: {
                message = new SpyTextMessage();
                break;
            }
            case 6: {
                message = new SpyEncapsulatedMessage();
                break;
            }
            default: {
                message = new SpyMessage();
            }
        }
        try {
            message.readExternal(in);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Class not found when reading in spy message.");
        }
        return message;
    }

    private static String readString(ObjectInput in) throws IOException {
        byte b = in.readByte();
        if (b == 9) {
            return null;
        }
        return in.readUTF();
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.CheckPropertyName(name);
        if (!this.propReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.prop.put(name, new Boolean(value));
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.CheckPropertyName(name);
        if (!this.propReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.prop.put(name, new Byte(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.CheckPropertyName(name);
        if (!this.propReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.prop.put(name, new Double(value));
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.CheckPropertyName(name);
        if (!this.propReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.prop.put(name, new Float(value));
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.CheckPropertyName(name);
        if (!this.propReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.prop.put(name, new Integer(value));
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.jmsCorrelationID = true;
        this.jmsCorrelationIDString = correlationID;
        this.jmsCorrelationIDbyte = null;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.jmsCorrelationID = false;
        this.jmsCorrelationIDbyte = (byte[])correlationID.clone();
        this.jmsCorrelationIDString = null;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.jmsDeliveryMode = deliveryMode;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.jmsDestination = destination;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.jmsExpiration = expiration;
    }

    public void setJMSMessageID(String id) throws JMSException {
        this.jmsMessageID = id;
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.jmsPriority = priority;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.jmsRedelivered = redelivered;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.jmsReplyTo = replyTo;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.jmsTimeStamp = timestamp;
    }

    public void setJMSType(String type) throws JMSException {
        this.jmsType = type;
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.CheckPropertyName(name);
        if (!this.propReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.prop.put(name, new Long(value));
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.CheckPropertyName(name);
        if (!this.propReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        if (value instanceof Boolean) {
            this.prop.put(name, value);
        } else if (value instanceof Byte) {
            this.prop.put(name, value);
        } else if (value instanceof Short) {
            this.prop.put(name, value);
        } else if (value instanceof Integer) {
            this.prop.put(name, value);
        } else if (value instanceof Long) {
            this.prop.put(name, value);
        } else if (value instanceof Float) {
            this.prop.put(name, value);
        } else if (value instanceof Double) {
            this.prop.put(name, value);
        } else if (value instanceof String) {
            this.prop.put(name, value);
        } else {
            throw new MessageFormatException("Invalid object type");
        }
    }

    public void setReadOnlyMode() {
        this.propReadWrite = false;
        this.msgReadOnly = true;
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.CheckPropertyName(name);
        if (!this.propReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.prop.put(name, new Short(value));
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.CheckPropertyName(name);
        if (!this.propReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.prop.put(name, value);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SpyDestination.writeDest(out, this.jmsDestination);
        out.writeInt(this.jmsDeliveryMode);
        out.writeLong(this.jmsExpiration);
        out.writeInt(this.jmsPriority);
        SpyMessage.writeString(out, this.jmsMessageID);
        out.writeLong(this.jmsTimeStamp);
        out.writeBoolean(this.jmsCorrelationID);
        SpyMessage.writeString(out, this.jmsCorrelationIDString);
        if (this.jmsCorrelationIDbyte == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.jmsCorrelationIDbyte.length);
            out.write(this.jmsCorrelationIDbyte);
        }
        SpyDestination.writeDest(out, this.jmsReplyTo);
        SpyMessage.writeString(out, this.jmsType);
        out.writeBoolean(this.jmsRedelivered);
        out.writeBoolean(this.propReadWrite);
        out.writeBoolean(this.msgReadOnly);
        SpyMessage.writeString(out, this.producerClientId);
        Set keys = this.prop.keySet();
        out.writeInt(keys.size());
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            out.writeUTF(key);
            Object value = this.prop.get(key);
            if (value == null) {
                out.writeByte(8);
                out.writeObject(value);
                continue;
            }
            if (value instanceof String) {
                out.writeByte(7);
                out.writeUTF((String)value);
                continue;
            }
            if (value instanceof Integer) {
                out.writeByte(2);
                out.writeInt((Integer)value);
                continue;
            }
            if (value instanceof Boolean) {
                out.writeByte(6);
                out.writeBoolean((Boolean)value);
                continue;
            }
            if (value instanceof Byte) {
                out.writeByte(0);
                out.writeByte(((Byte)value).byteValue());
                continue;
            }
            if (value instanceof Short) {
                out.writeByte(1);
                out.writeShort(((Short)value).shortValue());
                continue;
            }
            if (value instanceof Long) {
                out.writeByte(3);
                out.writeLong((Long)value);
                continue;
            }
            if (value instanceof Float) {
                out.writeByte(4);
                out.writeFloat(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                out.writeByte(5);
                out.writeDouble((Double)value);
                continue;
            }
            out.writeByte(8);
            out.writeObject(value);
        }
    }

    public static void writeMessage(SpyMessage message, ObjectOutput out) throws IOException {
        if (message instanceof SpyEncapsulatedMessage) {
            out.writeByte(6);
        } else if (message instanceof SpyObjectMessage) {
            out.writeByte(1);
        } else if (message instanceof SpyBytesMessage) {
            out.writeByte(2);
        } else if (message instanceof SpyMapMessage) {
            out.writeByte(3);
        } else if (message instanceof SpyTextMessage) {
            SpyTextMessage tMsg = (SpyTextMessage)message;
            if (tMsg.isVersion2()) {
                out.writeByte(8);
            } else {
                out.writeByte(4);
            }
        } else if (message instanceof SpyStreamMessage) {
            out.writeByte(5);
        } else {
            out.writeByte(7);
        }
        message.writeExternal(out);
    }

    private static void writeString(ObjectOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(9);
        } else {
            out.writeByte(7);
            out.writeUTF(s);
        }
    }
}

