/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.Connection;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.il.ClientILService;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILFactory;

public class GenericConnectionFactory
implements Serializable {
    private ServerIL server;
    private Properties connectionProperties;
    public static final String SERVER_IL_FACTORY_KEY = "ServerILFactory";
    public static final String CLIENT_IL_SERVICE_KEY = "ClientILService";
    static Logger log = Logger.getLogger(class$org$jboss$mq$GenericConnectionFactory != null ? class$org$jboss$mq$GenericConnectionFactory : (class$org$jboss$mq$GenericConnectionFactory = GenericConnectionFactory.class$("org.jboss.mq.GenericConnectionFactory")));
    static /* synthetic */ Class class$org$jboss$mq$GenericConnectionFactory;

    public GenericConnectionFactory(ServerIL server, Properties props) {
        this.server = server;
        this.connectionProperties = props;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public ClientILService createClientILService(Connection connection) throws Exception {
        String clientILServiceCN = this.connectionProperties.getProperty(CLIENT_IL_SERVICE_KEY);
        ClientILService service = (ClientILService)Class.forName(clientILServiceCN).newInstance();
        service.init(connection, this.connectionProperties);
        if (log.isDebugEnabled()) {
            log.debug("Handing out ClientIL: " + clientILServiceCN);
        }
        return service;
    }

    public ServerIL createServerIL() throws JMSException {
        try {
            if (this.server == null) {
                String className = this.connectionProperties.getProperty(SERVER_IL_FACTORY_KEY);
                ServerILFactory factory = (ServerILFactory)Class.forName(className).newInstance();
                factory.init(this.connectionProperties);
                this.server = factory.getServerIL();
            }
            return this.server.cloneServerIL();
        }
        catch (Exception e) {
            log.error("Could not connect to the server", e);
            throw new SpyJMSException("Could not connect to the server", e);
        }
    }
}

