/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.naming.InitialContext;
import management.J2EEApplication;
import management.J2EEDeployer;
import management.J2EEManagement;
import management.J2EEServer;
import org.jboss.jmx.client.ConnectorFactoryImpl;
import org.jboss.jmx.interfaces.JMXConnector;
import org.jboss.management.JBossJ2EEManagedObject;
import org.jboss.management.JBossJ2EEServer;

public class JBossJ2EEManagement
extends JBossJ2EEManagedObject
implements J2EEManagement {
    private MBeanServer mLocalServer;
    private Hashtable mJNDIProperties;
    private J2EEDeployer deployer;
    private Collection mServers = new ArrayList();

    public JBossJ2EEManagement(String string, MBeanServer mBeanServer, Hashtable hashtable) throws InvalidParameterException {
        super(string);
        if (mBeanServer == null) {
            throw new InvalidParameterException("MBeanServer must be specified");
        }
        this.mLocalServer = mBeanServer;
        this.mJNDIProperties = hashtable;
    }

    public J2EEApplication[] getApplications() {
        ArrayList<J2EEApplication> arrayList = new ArrayList<J2EEApplication>();
        Iterator iterator = this.mServers.iterator();
        while (iterator.hasNext()) {
            J2EEServer j2EEServer = (J2EEServer)iterator.next();
            arrayList.addAll(Arrays.asList(j2EEServer.getApplications()));
        }
        return arrayList.toArray(new J2EEApplication[0]);
    }

    public Iterator getConnectors() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Object object;
            InitialContext initialContext;
            ObjectInstance objectInstance = null;
            ObjectName objectName = new ObjectName("DefaultDomain", "name", "ConnectorFactory");
            if (this.mJNDIProperties == null) {
                initialContext = new InitialContext();
                this.mJNDIProperties = initialContext.getEnvironment();
            }
            objectInstance = this.mLocalServer.isRegistered(objectName) ? this.mLocalServer.getObjectInstance(objectName) : this.mLocalServer.createMBean("org.jboss.jmx.client.ConnectorFactoryService", objectName);
            this.mLocalServer.invoke(objectName, "init", new Object[0], new String[0]);
            this.mLocalServer.invoke(objectName, "start", new Object[0], new String[0]);
            initialContext = new ConnectorFactoryImpl.JBossConnectorTester();
            Iterator iterator = (Iterator)this.mLocalServer.invoke(objectName, "getConnectors", new Object[]{this.mJNDIProperties, initialContext}, new String[]{"java.util.Hashtable", "org.jboss.jmx.client.ConnectorFactoryImpl$IConnectorTester"});
            while (iterator.hasNext()) {
                object = (ConnectorFactoryImpl.ConnectorName)iterator.next();
                try {
                    arrayList.add(this.mLocalServer.invoke(objectName, "createConnection", new Object[]{object}, new String[]{object.getClass().getName()}));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            iterator = arrayList.iterator();
            object = new ObjectName("Management", "service", "Collector");
            while (iterator.hasNext()) {
                JMXConnector jMXConnector = (JMXConnector)iterator.next();
                if (jMXConnector.isRegistered((ObjectName)object)) continue;
                this.mLocalServer.invoke(objectName, "removeConnection", new Object[]{jMXConnector}, new String[]{jMXConnector.getClass().getName()});
                iterator.remove();
            }
            System.out.println("Actual JBoss Servers found: " + arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList.iterator();
    }

    public J2EEDeployer getDeployer() {
        return this.deployer;
    }

    public J2EEServer[] getServers() {
        return this.mServers.toArray(new J2EEServer[0]);
    }

    public void refresh() {
        try {
            Object object;
            Iterator iterator = this.getConnectors();
            ArrayList<JBossJ2EEServer> arrayList = new ArrayList<JBossJ2EEServer>();
            while (iterator.hasNext()) {
                object = (JMXConnector)iterator.next();
                arrayList.add(new JBossJ2EEServer("J2EEServer", (JMXConnector)object));
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (JBossJ2EEServer)iterator.next();
                ((JBossJ2EEServer)object).refresh();
            }
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            runtimeMBeanException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setApplications(J2EEApplication[] j2EEApplicationArray) {
    }

    public void setDeployer(J2EEDeployer j2EEDeployer) {
        this.deployer = j2EEDeployer;
    }

    public void setServers(J2EEServer[] j2EEServerArray) {
        this.mServers = new ArrayList();
        this.mServers.addAll(Arrays.asList(j2EEServerArray));
    }
}

