/*
 * Decompiled with CFR 0.152.
 */
package test.jboss.jmx;

import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.naming.InitialContext;
import org.jboss.jmx.client.ConnectorFactoryImpl;
import org.jboss.jmx.interfaces.JMXConnector;

public class TestClient {
    private static int getUserInput(String lMessage) {
        int lReturn = -1;
        try {
            System.out.println(lMessage);
            lReturn = System.in.read();
            System.in.skip(System.in.available());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lReturn;
    }

    public static void listServices(JMXConnector pConnector) throws Exception {
        try {
            Iterator i = pConnector.queryMBeans(null, null).iterator();
            while (i.hasNext()) {
                MBeanInfo info = pConnector.getMBeanInfo(((ObjectInstance)i.next()).getObjectName());
                System.out.println("MBean: " + info.getClassName());
                MBeanAttributeInfo[] aInfos = info.getAttributes();
                int k = 0;
                while (k < aInfos.length) {
                    System.out.println("\t" + k + ". Attribute: " + aInfos[k].getName());
                    ++k;
                }
                MBeanOperationInfo[] oInfos = info.getOperations();
                int k2 = 0;
                while (k2 < oInfos.length) {
                    System.out.println("\t" + k2 + ". Operation: " + oInfos[k2].getName());
                    ++k2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            System.out.println();
            TestClient.getUserInput("Testing JMX Connector from client to server\n===========================================\n\n1. Instantiate local MBeanServer and add connector factory as first MBean to search your net\n=> hit any key to proceed");
            final MBeanServer lLocalServer = MBeanServerFactory.createMBeanServer();
            final ObjectInstance lFactoryInstance = lLocalServer.createMBean("org.jboss.jmx.client.ConnectorFactoryService", new ObjectName(lLocalServer.getDefaultDomain(), "name", "ConnectorFactory"));
            System.out.println("Found Factory: " + lFactoryInstance.getObjectName());
            lLocalServer.invoke(lFactoryInstance.getObjectName(), "init", new Object[0], new String[0]);
            lLocalServer.invoke(lFactoryInstance.getObjectName(), "start", new Object[0], new String[0]);
            TestClient.getUserInput("\n2. Lookup for all available connectors with the JNDI defined by jndi.properties\n=> hit any key to proceed");
            InitialContext lContext = null;
            try {
                lContext = new InitialContext();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Hashtable<?, ?> lProperties = lContext.getEnvironment();
            ConnectorFactoryImpl.JBossConnectorTester lTester = new ConnectorFactoryImpl.JBossConnectorTester();
            Iterator lConnectors = (Iterator)lLocalServer.invoke(lFactoryInstance.getObjectName(), "getConnectors", new Object[]{lProperties, lTester}, new String[]{lProperties.getClass().getName(), lTester.getClass().getName()});
            int lCount = 0;
            StringBuffer lMessage = new StringBuffer();
            lMessage.append("List of all available connectors on your net\n");
            lMessage.append("=========================================\n");
            Vector<ConnectorFactoryImpl.ConnectorName> lTemp = new Vector<ConnectorFactoryImpl.ConnectorName>();
            while (lConnectors.hasNext()) {
                ConnectorFactoryImpl.ConnectorName lName = (ConnectorFactoryImpl.ConnectorName)lConnectors.next();
                lTemp.addElement(lName);
                lMessage.append(" - " + lCount++ + ". connector is: " + lName + "\n");
            }
            lMessage.append("\n");
            lMessage.append("3. Select your connector by entering its number\n");
            lMessage.append("=> hit any key to proceed");
            int lChoice = TestClient.getUserInput(lMessage.toString());
            Iterator i = ((AbstractList)lTemp).iterator();
            lCount = 0;
            while (i.hasNext()) {
                if (lCount++ == lChoice) break;
            }
            final ConnectorFactoryImpl.ConnectorName lConnectorName = (ConnectorFactoryImpl.ConnectorName)i.next();
            lMessage.setLength(0);
            lMessage.append("\nYou selected connector: " + lConnectorName + "\n\n");
            TestClient.getUserInput("5. Connect to the given connector\n=> hit any key to proceed");
            JMXConnector lConnector = (JMXConnector)lLocalServer.invoke(lFactoryInstance.getObjectName(), "createConnection", new Object[]{lConnectorName}, new String[]{lConnectorName.getClass().getName()});
            TestClient.getUserInput("\n6. List all available MBeans and its attributes\n=> hit any key to proceed");
            TestClient.listServices(lConnector);
            TestClient.getUserInput("\n7. Try to add a listener to all available MBeans.\nPlease note that this will keep this test client up and running waiting\nfor an event from the server. If there is no event comming then try\nto shutdown the JBoss server.\nTo end this test client just hit <CTRL>-C\n=> hit any key to proceed");
            TestClient.registerListeners(lConnector);
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        System.err.println("Shutdown");
                        try {
                            lLocalServer.invoke(lFactoryInstance.getObjectName(), "removeConnection", new Object[]{lConnectorName}, new String[]{lConnectorName.getClass().getName()});
                            System.err.println("Shutting done");
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                });
                System.out.println("Shutdown hook added");
            }
            catch (Throwable throwable) {
                System.out.println("Could not add shutdown hook");
            }
        }
        catch (RuntimeMBeanException rme) {
            System.err.println("TestClient.main(), caught: " + rme + ", target: " + rme.getTargetException());
            rme.printStackTrace();
        }
        catch (MBeanException me) {
            System.err.println("TestClient.main(), caught: " + me + ", target: " + me.getTargetException());
            me.printStackTrace();
        }
        catch (RuntimeErrorException rte) {
            System.err.println("TestClient.main(), caught: " + rte + ", target: " + rte.getTargetError());
            rte.printStackTrace();
        }
        catch (ReflectionException re) {
            System.err.println("TestClient.main(), caught: " + re + ", target: " + re.getTargetException());
            re.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("TestClient.main(), caught: " + e);
            e.printStackTrace();
        }
    }

    public static void registerListeners(JMXConnector pConnector) throws Exception {
        try {
            Iterator i = pConnector.queryMBeans(null, null).iterator();
            int j = 0;
            while (i.hasNext()) {
                ObjectInstance lBean = (ObjectInstance)i.next();
                try {
                    pConnector.addNotificationListener(lBean.getObjectName(), new Listener(), null, (Object)new NotSerializableHandback(String.valueOf(String.valueOf(lBean.getObjectName())) + "" + j++));
                    System.out.println("Added notification listener to: " + lBean.getObjectName());
                }
                catch (RuntimeOperationsException runtimeOperationsException) {
                    System.out.println("Could not add listener to: " + lBean.getObjectName() + ", reason could be that it is not a broadcaster");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Listener
    implements NotificationListener {
        Listener() {
        }

        public void handleNotification(Notification pNotification, Object pHandback) {
            System.out.println("Got notification: " + pNotification + ", from: " + pHandback);
        }
    }

    private static class NotSerializableHandback {
        private static int miCounter = 0;
        private String mName;

        public NotSerializableHandback(String pName) {
            this.mName = String.valueOf(pName) + "[ " + miCounter++ + " ]";
        }

        public String toString() {
            return "NotSerializableHandback[ " + this.mName + " ]";
        }
    }
}

