/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.util.Date;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.log4j.NDC;
import org.jboss.logging.Logger;
import org.jboss.util.ServiceMBean;

public abstract class ServiceMBeanSupport
extends NotificationBroadcasterSupport
implements ServiceMBean,
MBeanRegistration {
    private int state;
    protected MBeanServer server;
    private int id = 0;
    protected Logger log = Logger.getLogger(this.getClass());

    public void destroy() {
        if (this.getState() != 0) {
            this.stop();
        }
        this.log.info("Destroying");
        NDC.push((String)this.getName());
        try {
            this.destroyService();
        }
        catch (Exception e) {
            this.log.error(e);
        }
        NDC.pop();
        this.log.info("Destroyed");
    }

    protected void destroyService() throws Exception {
    }

    public abstract String getName();

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name;
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return ServiceMBean.states[this.state];
    }

    public void init() throws Exception {
        this.log.info("Initializing");
        NDC.push((String)this.getName());
        try {
            try {
                this.initService();
            }
            catch (Exception e) {
                this.log.error("Initialization failed", e);
                throw e;
            }
            Object var2_2 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            NDC.pop();
            throw throwable;
        }
        NDC.pop();
        this.log.info("Initialized");
    }

    protected void initService() throws Exception {
    }

    protected int nextSequenceNumber() {
        return this.id++;
    }

    public void postDeregister() {
        this.destroy();
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.log.info("Registration is not done -> destroy");
            this.destroy();
        }
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        name = this.getObjectName(server, name);
        this.server = server;
        return name;
    }

    public void start() throws Exception {
        if (this.getState() != 0) {
            return;
        }
        this.state = 2;
        this.sendNotification(new AttributeChangeNotification(this, this.id++, new Date().getTime(), String.valueOf(this.getName()) + " starting", "State", "java.lang.Integer", new Integer(0), new Integer(2)));
        this.log.info("Starting");
        NDC.push((String)this.getName());
        try {
            try {
                this.startService();
            }
            catch (Exception e) {
                this.state = 0;
                this.sendNotification(new AttributeChangeNotification(this, this.id++, new Date().getTime(), String.valueOf(this.getName()) + " stopped", "State", "java.lang.Integer", new Integer(2), new Integer(0)));
                this.log.error("Stopped", e);
                throw e;
            }
            Object var2_2 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            NDC.pop();
            throw throwable;
        }
        NDC.pop();
        this.state = 3;
        this.sendNotification(new AttributeChangeNotification(this, this.id++, new Date().getTime(), String.valueOf(this.getName()) + " started", "State", "java.lang.Integer", new Integer(2), new Integer(3)));
        this.log.info("Started");
    }

    protected void startService() throws Exception {
    }

    public void stop() {
        if (this.getState() != 3) {
            return;
        }
        this.state = 1;
        this.sendNotification(new AttributeChangeNotification(this, this.id++, new Date().getTime(), String.valueOf(this.getName()) + " stopping", "State", "java.lang.Integer", new Integer(3), new Integer(1)));
        this.log.info("Stopping");
        NDC.push((String)this.getName());
        try {
            this.stopService();
        }
        catch (Throwable e) {
            this.log.error(e);
        }
        this.state = 0;
        this.sendNotification(new AttributeChangeNotification(this, this.id++, new Date().getTime(), String.valueOf(this.getName()) + " stopped", "State", "java.lang.Integer", new Integer(1), new Integer(0)));
        NDC.pop();
        this.log.info("Stopped");
    }

    protected void stopService() throws Exception {
    }
}

