*Set var linNum=0
*Set var triaNum=0
*Set var quadNum=0
*Set var hexaNum=0
*Set var spcInit=0
*Set var beenthere=0
#-------------------------------------------------------------------
#    I N P U T  D A T A  D E C K  G E N E R A T I O N  F O R  F E A      
#-------------------------------------------------------------------
#    D A T A  F O R M A T:      I M P A C T  VERSION 0.4.9
#                                                                        
#            developed by:      http://www.impact.sourceforge.net        
#                               Impact is an open source FEA program     
#-------------------------------------------------------------------
#    P R E P R O C E S S O R:   G i D  VERSION 7.0.1                     
#                                                                        
#               developed by:   International Center for                 
#                               Numerical Methods in Engineering         
#                               Campus Norte UPC; Gran Capitan s/n       
#                               08034 Barcelona, Spain                   
#                               http://www.gid.cimne.com                 
#-------------------------------------------------------------------
#    INTERFACE FEATURES:        - added support for most elements
#                               - Improved material deck
#                               - Contact details included in material
#                               - Trackers added
#
#    last update                  06/07/2004
#
#-------------------------------------------------------------------
#-------------------------------------------------------------------
#    T I T L E:       *GenData(1)
#    S U B T I T L E: *GenData(2)
#-------------------------------------------------------------------
#    Dimension of Analysis Model:         *ndime
#    
#    Total Number of Elements:            *nelem
#
#    Total Number of Grid Points:         *npoin
#
#    Total Number of different Materials: *nmats
#-------------------------------------------------------------------


#-------------------------------------------------------------------
#    ANALYSIS RUN TIME CONTROL
#-------------------------------------------------------------------

CONTROLS
*if(GenData(START_TIME,real)>0.)
*format "run from %10.5f to %10.5f step %9.6f"
*GenData(START_TIME,real)*GenData(END_TIME,real)*GenData(STEP_SIZE,real)
*else
*format "run from %10.5f to %10.5f"
*GenData(START_TIME,real)*GenData(END_TIME,real)
*endif
*if(GenData(PRINT_OUTPUT,real)>0.)
*format "print every %9.6f step"
*GenData(PRINT_OUTPUT,real)
*else
*messagebox ERROR: The print interval must be set (Use Problem Data -> Time Control)
*endif
*if(GenData(PRINT_TRACKER_OUTPUT,real)>0.)
*format "print tracker every %9.6f step"
*GenData(PRINT_TRACKER_OUTPUT,real)
*else
*messagebox ERROR: The tracker print interval must be set (Use Problem Data -> Time Control)
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL MATERIAL CONFIGURATION
#-------------------------------------------------------------------
*set var t=0
*loop materials
*if(strcmp(matprop(PROPERTY),"ELASTIC")==0)
*if(t==0)

MATERIALS OF TYPE ELASTIC
*set var t=1
*endif
*endif
*end materials
*loop materials
*if(strcmp(matprop(PROPERTY),"ELASTIC")==0)
*format "mat_%1i E = %10.5f RHO = %16.10f NU = %6.3f"
*matnum()*matprop(YOUNGS_MODULUS,real)*matprop(MASS_DENSITY,real)*matprop(POISSON_RATIO,real)
*endif
*end materials
*set var t=0
*loop materials
*if(strcmp(matprop(PROPERTY),"ELASTO-PLASTIC")==0)
*if(t==0)

MATERIALS OF TYPE ELASTOPLASTIC
*set var t=1
*endif
*endif
*end materials
*loop materials
*if(strcmp(matprop(PROPERTY),"ELASTO-PLASTIC")==0)
*format "mat_%1i E = %10.5f RHO = %16.10f NU = %6.3f YIELD_STRESS = %10.5f EP = %6.2f"
*matnum()*matprop(YOUNGS_MODULUS,real)*matprop(MASS_DENSITY,real)*matprop(POISSON_RATIO,real)*matprop(YIELD_STRESS,real)*matprop(HARDENING_FACTOR,real)
*endif
*end materials
*set var t=0
*loop materials
*if(strcmp(matprop(PROPERTY),"SPRING")==0)
*if(t==0)

MATERIALS OF TYPE SPRING
*set var t=1
*endif
*endif
*end materials
*loop materials
*if(strcmp(matprop(PROPERTY),"SPRING")==0)
*format "mat_%1i KX = %10.5f KY = %10.5f KZ = %10.5f KRX = %10.5f KRY = %10.5f KRZ = %10.5f CX = %10.5f CY = %10.5f CZ = %10.5f CRX = %10.5f CRY = %10.5f CRZ = %10.5f"
*matnum()*matprop(KX,real)*matprop(KY,real)*matprop(KZ,real)*matprop(KRX,real)*matprop(KRY,real)*matprop(KRZ,real)*matprop(CX,real)*matprop(CY,real)*matprop(CZ,real)*matprop(CRX,real)*matprop(CRY,real)*matprop(CRZ,real)
*endif
*end materials

#-------------------------------------------------------------------
#    ANALYSIS MODEL NODAL POINT CONFIGURATION
#-------------------------------------------------------------------

NODES
*Set cond Boundary_Condition_P *nodes *or(2,int)
*Add cond Boundary_Condition_L *nodes *or(2,int)
*Add cond Boundary_Condition_S *nodes *or(2,int)
*Add cond Rigid_Body_P *nodes *or(2,int)
*Add cond Rigid_Body_L *nodes *or(2,int)
*Add cond Rigid_Body_S *nodes *or(2,int)
*Add cond Force_Load *nodes *or(1,int)
*Add cond Dummy *nodes *or(1,int) *or(2,int)
*loop nodes
*format "%8i x = %15.8f y = %15.8f z = %15.8f"
*NodesNum*NodesCoord(1)*NodesCoord(2)*NodesCoord(3) *\
*if(cond(1,int) > 0)
*format "%1i"
constraint = Constr_*cond(1,int) *\
*endif
*if(cond(2,int) > 0)
*format "%1i"
load = Load_*cond(2,int)
*else

*endif
*end nodes

#-------------------------------------------------------------------
#    ANALYSIS MODEL ROD ELEMENT CONFIGURATION
#-------------------------------------------------------------------
*Set var linNum=0
*Set elems(linear)
*loop elems
*if(ElemsNum>0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")!=0)
*if(strcmp(matprop(1),"SPRING")!=0)
*Set var linNum=1
*endif
*endif
*endif
*end materials
*endif
*end elems
*if(linNum>0)
ELEMENTS OF TYPE Rod_2
*Set cond Pressure_Load
*Add cond Dummy
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*if(ElemsMat==0)
*messagebox - ERROR: No materials defined for the Rod elements
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")!=0)
*if(strcmp(matprop(1),"SPRING")!=0)
*Set var thick=matprop(5,real)
*Set var matset=ElemsMat
*Set var intpoint=matprop(6,int)
*format "%8i nodes = [%1i,%1i] D = %6.3f material = mat_%1i"
*ElemsNum*ElemsConec*thick*matset *\
*if(strcmp(matprop(9),"BASIC")!=0)
*if(strcmp(matprop(9),"ADVANCED")==0)
*messagebox - ERROR: Rod elements only allows OFF or BASIC contact functions
*endif
*if(strcmp(matprop(9),"ADVANCED_EDGE")==0)
*messagebox - ERROR: Rod elements only allows OFF or BASIC contact functions
*endif
*if(strcmp(matprop(9),"EDGE")==0)
*messagebox - ERROR: Rod elements only allows OFF or BASIC contact functions
*endif
contact = *matprop(9) factor = *matprop(10) friction = *matprop(11) *\
*endif

*endif
*endif
*endif
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL SPRING ELEMENT CONFIGURATION
#-------------------------------------------------------------------
*Set var linNum=0
*Set elems(linear)
*loop elems
*if(ElemsNum>0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"SPRING")==0)
*Set var linNum=1
*endif
*endif
*end materials
*endif
*end elems
*if(linNum>0)
ELEMENTS OF TYPE Beam_Spring_2
*Set cond Pressure_Load
*Add cond Dummy
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*if(ElemsMat==0)
*messagebox - ERROR: No materials defined for the Spring elements
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"SPRING")==0)
*Set var matset=ElemsMat
*format "%8i nodes = [%1i,%1i,%1i] material = mat_%1i"
*ElemsNum*ElemsConec*matprop(2)*matset *\
*if(strcmp(matprop(15),"BASIC")==0)
D = *matprop(16) contact = *matprop(15) factor = *matprop(17) friction = *matprop(18) *\
*endif

*endif
*endif
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL CONTACT LINE ELEMENT CONFIGURATION
#-------------------------------------------------------------------
*Set var linNum=0
*Set elems(linear)
*loop elems
*if(ElemsNum>0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")==0)
*Set var linNum=1
*endif
*endif
*end materials
*endif
*end elems
*if(linNum>0)
ELEMENTS OF TYPE Rod_2
*Set cond Pressure_Load
*Add cond Dummy
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*if(ElemsMat==0)
*messagebox - ERROR: No materials defined for the Rod elements
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")==0)
*Set var thick=matprop(5,real)
*Set var matset=ElemsMat
*Set var intpoint=matprop(6,int)
*format "%8i nodes = [%1i,%1i] D = %6.3f material = mat_%1i"
*ElemsNum*ElemsConec*thick*matset *\
*if(strcmp(matprop(9),"BASIC")!=0)
*if(strcmp(matprop(9),"ADVANCED")==0)
*messagebox - ERROR: Contact line elements only allows OFF or BASIC contact functions
*endif
*if(strcmp(matprop(9),"ADVANCED_EDGE")==0)
*messagebox - ERROR: Contact line elements only allows OFF or BASIC contact functions
*endif
*if(strcmp(matprop(9),"EDGE")==0)
*messagebox - ERROR: Contact line elements only allows OFF or BASIC contact functions
*endif
contact = *matprop(9)  factor = *matprop(10) friction = *matprop(11) *\
*endif

*endif
*endif
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL TRIANGULAR ELEMENT CONFIGURATION
#-------------------------------------------------------------------

*Set elems(triangle)
*loop elems
*if(ElemsNum>0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")!=0)
*Set var triaNum=1
*endif
*endif
*end materials
*endif
*end elems
*if(triaNum>0)
ELEMENTS OF TYPE shell_C0_3
*Set cond Pressure_Load
*Add cond Dummy
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*if(ElemsMat==0)
*messagebox - ERROR: No materials defined for the Triangular shell elements
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")!=0)
*Set var thick=matprop(5,real)
*Set var matset=ElemsMat
*Set var intpoint=matprop(6,int)
*format "%8i nodes = [%1i,%1i,%1i] nip = %1i t = %6.3f material = mat_%1i"
*ElemsNum*ElemsConec*intpoint*thick*matset *\
*if(strcmp(matprop(9),"BASIC")!=0)
*if(strcmp(matprop(9),"ADVANCED")==0)
*messagebox - ERROR: Triangle elements only allows OFF, BASIC or EDGE contact functions
*endif
*if(strcmp(matprop(9),"ADVANCED_EDGE")==0)
*messagebox - ERROR: Triangle elements only allows OFF, BASIC or EDGE contact functions
*endif
contact = *matprop(9) factor = *matprop(10) friction = *matprop(11) *\
*endif
*if(Cond(2,int)>0)
*format "load = Load_%1i"
*Cond(2,int)
*else

*endif
*endif
*endif
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL CONTACT TRIANGLE ELEMENT CONFIGURATION
#-------------------------------------------------------------------

*Set var triaNum=0
*Set elems(triangle)
*loop elems
*if(ElemsNum>0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")==0)
*Set var triaNum=1
*endif
*endif
*end materials
*endif
*end elems
*if(triaNum>0)
ELEMENTS OF TYPE contact_triangle
*Set cond Pressure_Load
*Add cond Dummy
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*if(ElemsMat==0)
*messagebox - ERROR: No contact_only materials defined for the Contact Triangle elements
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")==0)
*Set var thick=matprop(5,real)
*format "%8i nodes = [%1i,%1i,%1i] t = %6.3f"
*ElemsNum*ElemsConec*thick *\
*if(strcmp(matprop(9),"BASIC")!=0)
*if(strcmp(matprop(9),"ADVANCED")==0)
*messagebox - ERROR: Contact Triangle elements only allows OFF, BASIC or EDGE contact functions
*endif
*if(strcmp(matprop(9),"ADVANCED_EDGE")==0)
*messagebox - ERROR: Contact Triangle elements only allows OFF, BASIC or EDGE contact functions
*endif
contact = *matprop(9) factor = *matprop(10) friction = *matprop(11) *\
*endif

*endif
*endif
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL QUADRILATERAL ELEMENT CONFIGURATION
#-------------------------------------------------------------------

*Set elems(quadrilateral)
*loop elems
*if(ElemsNum>0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")!=0)
*Set var quadNum=1
*endif
*endif
*end materials
*endif
*end elems
*if(quadNum>0)
ELEMENTS OF TYPE shell_BT_4
*Set cond Pressure_Load
*Add cond Dummy
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*if(ElemsMat==0)
*messagebox - ERROR: No materials defined for the Quad shell elements
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*if(strcmp(matprop(1),"CONTACT_ONLY")!=0)
*Set var thick=matprop(5,real)
*Set var matset=ElemsMat
*Set var intpoint=matprop(6,int)
*if(strcmp(GenData(9),"YES")==0)
*format "%8i nodes = [%1i,%1i,%1i,%1i] nip = %1i t = %6.3f material = mat_%1i shear_factor = %4.3f mhc = %4.3f oophc = %4.3f rhc = %4.3f"
*ElemsNum*ElemsConec*intpoint*thick*matset*GenData(8,real)*GenData(10,real)*GenData(11,real)*GenData(12,real) *\
*else
*format "%8i nodes = [%1i,%1i,%1i,%1i] nip = %1i t = %6.3f material = mat_%1i shear_factor = %4.3f hourglass = off"
*ElemsNum*ElemsConec*intpoint*thick*matset*GenData(8,real) *\
*endif
*if(strcmp(matprop(9),"BASIC")!=0)
contact = *matprop(9) factor = *matprop(10) friction = *matprop(11) *\
*endif
*if(Cond(2,int)>0)
*format "load = Load_%1i"
*Cond(2,int)
*else

*endif
*endif
*endif
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL HEXAHEDRONAL ELEMENT CONFIGURATION
#-------------------------------------------------------------------

*Set elems(hexahedra)
*loop elems
*if(ElemsNum>0)
*Set var hexaNum=1
*endif
*end elems
*if(hexaNum>0)
ELEMENTS OF TYPE solid_iso_6
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*Set var matset=ElemsMat
*Set var intpoint=matprop(6,int)
*if(intpoint>1)
*Set var intpoint=8
*endif
*endif
*format "%8i nodes = [%1i,%1i,%1i,%1i,%1i,%1i,%1i,%1i] nip = %1i material = mat_%1i"
*ElemsNum*ElemsConec*intpoint*matset
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL TETRAHEDRONAL ELEMENT CONFIGURATION
#-------------------------------------------------------------------

*Set elems(tetrahedra)
*loop elems
*if(ElemsNum>0)
*Set var hexaNum=1
*endif
*end elems
*if(hexaNum>0)
ELEMENTS OF TYPE solid_iso_4
*loop elems
*if(IsQuadratic(int)==1)
*messagebox - ERROR: IMPACT supports only linear shape function
*endif
*end elems
*loop elems
*if(IsQuadratic(int)==0)
*loop materials
*if(matnum()==ElemsMat)
*Set var matset=ElemsMat
*Set var intpoint=matprop(6,int)
*if(intpoint>1)
*Set var intpoint=1
*endif
*endif
*format "%8i nodes = [%1i,%1i,%1i,%1i] nip = %1i material = mat_%1i"
*ElemsNum*ElemsConec*intpoint*matset
*end materials
*endif
*end elems
*endif

#-------------------------------------------------------------------
#    ANALYSIS MODEL BOUNDARY CONDITIONS
#-------------------------------------------------------------------
*Set cond Boundary_Condition_P *nodes
*Add cond Boundary_Condition_L *nodes
*Add cond Boundary_Condition_S *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(1,int)==i)
CONSTRAINTS OF TYPE Boundary_Condition
*endif
*end nodes
*end for
*Set cond Boundary_Condition_P *nodes
*Add cond Boundary_Condition_L *nodes
*Add cond Boundary_Condition_S *nodes
*for(i=1;i<10;i=i+1)
*set var beenthere=0
*loop nodes *OnlyInCond
*if(Cond(1,int)==i)
*if(beenthere==0)
*set var beenthere=1
*format "%1i"
Constr_*Cond(1,int) *\
*if(strcmp(Cond(4),"OFF")!=0)
ax = *Cond(4) *\
*endif
*if(strcmp(Cond(5),"OFF")!=0)
ay = *Cond(5) *\
*endif
*if(strcmp(Cond(6),"OFF")!=0)
az = *Cond(6) *\
*endif
*if(strcmp(Cond(7),"OFF")!=0)
vx = *Cond(7) *\
*endif
*if(strcmp(Cond(8),"OFF")!=0)
vy = *Cond(8) *\
*endif
*if(strcmp(Cond(9),"OFF")!=0)
vz = *Cond(9) *\
*endif
*if(strcmp(Cond(10),"OFF")!=0)
arx = *Cond(10) *\
*endif
*if(strcmp(Cond(11),"OFF")!=0)
ary = *Cond(11) *\
*endif
*if(strcmp(Cond(12),"OFF")!=0)
arz = *Cond(12) *\
*endif
*if(strcmp(Cond(13),"OFF")!=0)
vrx = *Cond(13) *\
*endif
*if(strcmp(Cond(14),"OFF")!=0)
vry = *Cond(14) *\
*endif
*if(strcmp(Cond(15),"OFF")!=0)
vrz = *Cond(15) *\
*endif

*endif
*endif
*end nodes
*end for

*Set cond Rigid_Body_P *nodes
*Add cond Rigid_Body_L *nodes
*Add cond Rigid_Body_S *nodes
*for(i=51;i<60;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(1,int)==i)
CONSTRAINTS OF TYPE Rigid_Body
*endif
*end nodes
*end for
*Set cond Rigid_Body_P *nodes
*Add cond Rigid_Body_L *nodes
*Add cond Rigid_Body_S *nodes
*for(i=51;i<60;i=i+1)
*Set var beenthere=0
*loop nodes *OnlyInCond
*if(Cond(1,int)==i)
*if(beenthere==0)
*set var beenthere=1
*format "%1i master_node = %1i"
Constr_*Cond(1,int)*Cond(3,int)
*endif
*endif
*end nodes
*end for

#-------------------------------------------------------------------
#    ANALYSIS MODEL LOADS
#-------------------------------------------------------------------

*Set cond Force_Load *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(2,int)==i)
LOADS
*endif
*end nodes
*end for
*Set cond Force_Load *nodes
*for(i=1;i<10;i=i+1)
*Set var beenthere=0
*loop nodes *OnlyInCond
*if(Cond(2,int)==i)
*if(beenthere==0)
*set var beenthere=1
*format "%1i"
Load_*Cond(2,int) *\
fx = *Cond(4) *\
fy = *Cond(5) *\
fz = *Cond(6) *\
ax = *Cond(7) *\
ay = *Cond(8) *\
az = *Cond(9) *\
mx = *Cond(10) *\
my = *Cond(11) *\
mz = *Cond(12) *\
arx = *Cond(13) *\
ary = *Cond(14) *\
arz = *Cond(15)
*endif
*endif
*end nodes
*end
*Set cond Pressure_Load *nodes
*for(i=1;i<10;i=i+1)
*Set var beenthere=0
*loop nodes *OnlyInCond
*if(Cond(2,int)==i)
*if(beenthere==0)
*set var beenthere=1
*format "%1i"
Load_*Cond(2,int) *\
p = *Cond(4)
*endif
*endif
*end nodes
*end for

#-------------------------------------------------------------------
#    TRACKERS
#-------------------------------------------------------------------
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"FORCE")==0)

TRACKERS OF TYPE NODEFORCE
*endif
*endif
*end nodes
*end for
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"FORCE")==0)
*format "%1i" *\
*Cond(3) nodes = [*NodesNum] direction = *Cond(5) filename = *Cond(6) *\
*if(strcmp(Cond(7),"YES")==0)
*format " target = [%15.8f,%15.8f,%15.8f,%15.8f]"
*Cond(8)*Cond(9)*Cond(10)*Cond(11) *\
*endif

*endif
*endif
*end nodes
*end
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"MOMENT")==0)

TRACKERS OF TYPE NODEMOMENT
*endif
*endif
*end nodes
*end for
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"MOMENT")==0)
*format "%1i" *\
*Cond(3) nodes = [*NodesNum] direction = *Cond(5) filename = *Cond(6) *\
*if(strcmp(Cond(7),"YES")==0)
*format " target = [%15.8f,%15.8f,%15.8f,%15.8f]"
*Cond(8)*Cond(9)*Cond(10)*Cond(11) *\
*endif

*endif
*endif
*end nodes
*end for
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"DISPLACEMENT")==0)

TRACKERS OF TYPE NODEDISPLACEMENT
*endif
*endif
*end nodes
*end for
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"DISPLACEMENT")==0)
*format "%1i" *\
*Cond(3) node = [*NodesNum] direction = *Cond(5) filename = *Cond(6) *\
*if(strcmp(Cond(7),"YES")==0)
*format " target = [%15.8f,%15.8f,%15.8f,%15.8f]"
*Cond(8)*Cond(9)*Cond(10)*Cond(11) *\
*endif

*endif
*endif
*end nodes
*end
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"ACCELERATION")==0)

TRACKERS OF TYPE NODEACCELERATION
*endif
*endif
*end nodes
*end for
*Set cond Tracker_point *nodes
*for(i=1;i<10;i=i+1)
*loop nodes *OnlyInCond
*if(Cond(3,int)==i)
*if(strcmp(Cond(4),"ACCELERATION")==0)
*format "%1i" *\
*Cond(3) node = [*NodesNum] direction = *Cond(5) filename = *Cond(6) *\
*if(strcmp(Cond(7),"YES")==0)
*format " target = [%15.8f,%15.8f,%15.8f,%15.8f]"
*Cond(8)*Cond(9)*Cond(10)*Cond(11) *\
*endif

*endif
*endif
*end nodes
*end
*if(strcmp(GenData(CONTACT),"YES") == 0) || *if(strcmp(GenData(INTERNAL),"YES") == 0) || *if(strcmp(GenData(EXTERNAL),"YES") == 0) || *if(strcmp(GenData(HGLASS),"YES") == 0)

TRACKERS OF TYPE ENERGY
*endif
*if(strcmp(GenData(CONTACT),"YES") == 0)
11 type = contact filename = *GenData(FILENAME_CONTACT)
*endif
*if(strcmp(GenData(INTERNAL),"YES") == 0)
12 type = internal filename = *GenData(FILENAME_INTERNAL)
*endif
*if(strcmp(GenData(EXTERNAL),"YES") == 0)
11 type = contact filename = *GenData(FILENAME_EXTERNAL)
*endif
*if(strcmp(GenData(HGLASS),"YES") == 0)
11 type = contact filename = *GenData(FILENAME_HOURGLASS)
*endif

#-------------------------------------------------------------------
#    END OF FILE
#-------------------------------------------------------------------
#-------------------------------------------------------------------
