/*
 * Decompiled with CFR 0.152.
 */
package foxtrot;

import foxtrot.AbstractWorker;
import foxtrot.EventPump;
import foxtrot.JREVersion;
import foxtrot.Job;
import foxtrot.Task;
import foxtrot.WorkerThread;
import foxtrot.pumps.ConditionalEventPump;
import foxtrot.pumps.QueueEventPump;
import foxtrot.pumps.SunJDK14ConditionalEventPump;
import javax.swing.SwingUtilities;

abstract class AbstractSyncWorker
extends AbstractWorker {
    private EventPump eventPump;

    AbstractSyncWorker() {
    }

    EventPump eventPump() {
        if (this.eventPump == null) {
            this.eventPump(this.createDefaultEventPump());
        }
        return this.eventPump;
    }

    void eventPump(EventPump eventPump) {
        if (eventPump == null) {
            throw new IllegalArgumentException("EventPump cannot be null");
        }
        this.eventPump = eventPump;
    }

    EventPump createDefaultEventPump() {
        if (JREVersion.isJRE14()) {
            return new SunJDK14ConditionalEventPump();
        }
        if (JREVersion.isJRE13()) {
            return new ConditionalEventPump();
        }
        if (JREVersion.isJRE12()) {
            return new QueueEventPump();
        }
        throw new Error("The current JRE is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object post(Task task, WorkerThread workerThread, EventPump eventPump) throws Exception {
        boolean isEventThread = SwingUtilities.isEventDispatchThread();
        if (!isEventThread && !workerThread.isWorkerThread()) {
            throw new IllegalStateException("Method post() can be called only from the AWT Event Dispatch Thread or from a worker thread");
        }
        if (isEventThread) {
            workerThread.postTask(task);
            eventPump.pumpEvents(task);
        } else {
            workerThread.runTask(task);
        }
        try {
            Object object = task.getResultOrThrow();
            return object;
        }
        finally {
            task.reset();
        }
    }

    Object post(Job job, WorkerThread workerThread, EventPump eventPump) {
        try {
            return this.post((Task)job, workerThread, eventPump);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x.toString());
        }
        catch (Error x) {
            throw x;
        }
    }
}

