/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.util;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import serpro.ppgd.gui.ConfirmacaoDialog;
import serpro.ppgd.gui.PPGDFormBuilder;
import serpro.ppgd.infraestrutura.util.BarraNavegacaoPPGD;
import serpro.ppgd.infraestrutura.util.FichaColecaoIf;
import serpro.ppgd.infraestrutura.util.PPGDFormPanel;
import serpro.ppgd.infraestrutura.util.PainelGenerico;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public abstract class PainelGenericoColecao
extends PainelGenerico
implements FichaColecaoIf {
    private final String LABEL_TITULO_EXCLUIR = "Confirma\u00e7\u00e3o de exclus\u00e3o";
    private final String LABEL_TEXTO_EXCLUIR = "<html>Voc\u00ea tem certeza de que deseja excluir o<br>registro atual?</html>";
    private Colecao colecao;
    private ObjetoNegocio objetoNegocio;
    protected BarraNavegacaoPPGD barraNavegacaoPPGD;
    private boolean isContentPanelScrollable = false;
    private FormLayout layoutPrincipal = new FormLayout("2dlu,F:P:grow,2dlu", "F:P,F:10dlu:grow");

    public PainelGenericoColecao() {
        this.setLayout((LayoutManager)this.layoutPrincipal);
        this.colecao = this.getColecao();
        this.configuraPanel();
    }

    public PainelGenericoColecao(boolean configuraLayoutPadrao, boolean configuraPainelAutomatico) {
        this.colecao = this.getColecao();
        if (configuraLayoutPadrao) {
            this.setLayout((LayoutManager)this.layoutPrincipal);
        }
        if (configuraPainelAutomatico) {
            this.configuraPanel();
        }
    }

    public PainelGenericoColecao(BarraNavegacaoPPGD barraCustomizada, boolean configuraLayoutPadrao, boolean configuraPainelAutomatico) {
        this.colecao = this.getColecao();
        this.barraNavegacaoPPGD = barraCustomizada;
        if (configuraLayoutPadrao) {
            this.setLayout((LayoutManager)this.layoutPrincipal);
        }
        if (configuraPainelAutomatico) {
            this.configuraPanel();
        }
    }

    public PainelGenericoColecao(boolean isContentPanelScrollable, boolean configuraLayoutPadrao, boolean configuraPainelAutomatico) {
        this.isContentPanelScrollable = isContentPanelScrollable;
        this.colecao = this.getColecao();
        if (configuraLayoutPadrao) {
            this.setLayout((LayoutManager)this.layoutPrincipal);
        }
        if (configuraPainelAutomatico) {
            this.configuraPanel();
        }
    }

    public PainelGenericoColecao(boolean isContentPanelScrollable, BarraNavegacaoPPGD barraCustomizada, boolean configuraLayoutPadrao, boolean configuraPainelAutomatico) {
        this.isContentPanelScrollable = isContentPanelScrollable;
        this.barraNavegacaoPPGD = barraCustomizada;
        this.colecao = this.getColecao();
        if (configuraLayoutPadrao) {
            this.setLayout((LayoutManager)this.layoutPrincipal);
        }
        if (configuraPainelAutomatico) {
            this.configuraPanel();
        }
    }

    public boolean isContentPanelScrollable() {
        return this.isContentPanelScrollable;
    }

    public void setContentPanelScrollable(boolean isContentPanelScrollable) {
        this.isContentPanelScrollable = isContentPanelScrollable;
    }

    public BarraNavegacaoPPGD getBarraNavegacaoPPGD() {
        return this.barraNavegacaoPPGD;
    }

    public void setBarraNavegacaoPPGD(BarraNavegacaoPPGD barraNavegacaoPPGD) {
        this.barraNavegacaoPPGD = barraNavegacaoPPGD;
    }

    protected boolean permiteCriacao() {
        return true;
    }

    protected void mostraPainel() {
        if (this.colecao == null || this.colecao.recuperarLista().size() == 0) {
            this.objetoNegocio = this.criaObjetoNegocio();
            this.colecao.recuperarLista().add(this.objetoNegocio);
        }
        this.objetoNegocio = (ObjetoNegocio)this.colecao.recuperarLista().get(0);
        if (this.barraNavegacaoPPGD != null) {
            this.barraNavegacaoPPGD.executaPrimeiro();
        }
    }

    protected void configuraPanel() {
        if (this.barraNavegacaoPPGD == null) {
            this.barraNavegacaoPPGD = new BarraNavegacaoPPGD(this.colecao, this){

                protected boolean permiteCriacao() {
                    return PainelGenericoColecao.this.permiteCriacao();
                }
            };
        }
        JPanel panelBN = new JPanel(new FlowLayout(1));
        panelBN.setBorder(Borders.DIALOG_BORDER);
        panelBN.add(this.barraNavegacaoPPGD);
        this.builder.setRow(1);
        this.builder.setColumn(2);
        this.builder.append((Component)panelBN);
        this.builder.setRow(2);
        this.builder.setColumn(2);
        if (this.isContentPanelScrollable) {
            this.builder.append((Component)new JScrollPane(this.buildPanel()));
        } else {
            this.builder.append((Component)this.buildPanel());
        }
        this.mostraPainel();
    }

    protected void escondePainel() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PainelGenericoColecao.this.colecao.excluirRegistrosEmBranco();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ObjetoNegocio getObjetoNegocio() {
        if (this.objetoNegocio == null) {
            this.colecao = this.getColecao();
            if (this.colecao.recuperarLista().isEmpty()) {
                this.objetoNegocio = this.criaObjetoNegocio();
                this.colecao.recuperarLista().add(this.objetoNegocio);
            } else {
                this.objetoNegocio = (ObjetoNegocio)this.colecao.recuperarLista().get(0);
            }
        }
        return this.objetoNegocio;
    }

    public PPGDFormBuilder getBuilder() {
        return null;
    }

    public final void adicionaComponentes() {
    }

    protected JPanel buildPanel() {
        PPGDFormPanel painelConteudo = new PPGDFormPanel();
        this.adicionaComponentes(painelConteudo);
        return painelConteudo;
    }

    public boolean obtemConfirmacaoExclusao(ObjetoNegocio obj) {
        int confirmacao = ConfirmacaoDialog.show((String)"Confirma\u00e7\u00e3o de exclus\u00e3o", (String)"<html>Voc\u00ea tem certeza de que deseja excluir o<br>registro atual?</html>");
        return confirmacao == 1;
    }

    protected abstract void adicionaComponentes(PPGDFormPanel var1);

    public ObjetoNegocio criaObjetoNegocio() {
        Colecao colecao = this.getColecao();
        return FabricaUtilitarios.instanciaObjetoNegocio((Class)colecao.getTipoItens(), (IdDeclaracao)colecao.getIdDeclaracao());
    }

    public abstract void mostraOutroObjetoNegocio(ObjetoNegocio var1);

    protected abstract Colecao getColecao();
}

