/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ItemOpcao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.ValidadorImpeditivoOpcao;
import serpro.ppgd.negocio.util.LogPPGD;

public class Opcao
extends Informacao {
    private String conteudo = "";
    private String C_DELIMITADOR_OPCOES = ";";
    public static String SIM = "1";
    public static String NAO = "0";
    public static String LABEL_SIM = "Sim";
    public static String LABEL_NAO = "N\u00e3o";
    public boolean selecaoMultipla = true;
    private Map opcoes = new Hashtable();
    private LinkedList listaOrdenada = new LinkedList();
    private Vector listaValidadoresImpeditivosTemporaria = new Vector();

    public Opcao() {
        super("");
    }

    public void addValidador(ValidadorIf validador) {
        if (validador instanceof ValidadorImpeditivoDefault && !(validador instanceof ValidadorImpeditivoOpcao)) {
            throw new IllegalArgumentException("O Validador adicionado n\u00e3o \u00e9 do tipo ValidadorImpeditivoOpcao.\n Fa\u00e7a com que esse herde de ValidadorImpeditivoOpcao.");
        }
        super.addValidador(validador);
    }

    public void atualizaListaValidadoresImpeditivos(String proximaOpcao) {
        Vector<ValidadorImpeditivoOpcao> lista = new Vector<ValidadorImpeditivoOpcao>();
        Iterator itValidadores = super.getListaValidadoresImpeditivos().iterator();
        while (itValidadores.hasNext()) {
            ValidadorImpeditivoOpcao val = (ValidadorImpeditivoOpcao)itValidadores.next();
            if (val.getValorCodigoOpcao().trim().equals("") || !this.getOpcoes().containsKey(val.getValorCodigoOpcao().trim()) || !proximaOpcao.equals(val.getValorCodigoOpcao())) continue;
            lista.add(val);
        }
        this.listaValidadoresImpeditivosTemporaria.clear();
        this.listaValidadoresImpeditivosTemporaria.addAll(lista);
    }

    public void ordenaListaValidadoreImpeditivos() {
        LinkedList<ValidadorImpeditivoDefault> retorno = new LinkedList<ValidadorImpeditivoDefault>();
        Iterator itValidadores = this.getListaValidadoresImpeditivos().iterator();
        while (itValidadores.hasNext()) {
            ValidadorImpeditivoDefault validador = (ValidadorImpeditivoDefault)itValidadores.next();
            if (validador.getSeveridade() == 5) {
                retorno.addFirst(validador);
                continue;
            }
            if (validador.getSeveridade() != 4) continue;
            retorno.addLast(validador);
        }
        this.listaValidadoresImpeditivosTemporaria.clear();
        this.listaValidadoresImpeditivosTemporaria.addAll(retorno);
    }

    public Vector getListaValidadoresImpeditivos() {
        return this.listaValidadoresImpeditivosTemporaria;
    }

    public void adicionaOpcao(String codigo, String descricao) {
        if (this.opcoes.containsKey(codigo)) {
            this.listaOrdenada.remove(this.opcoes.get(codigo));
        }
        ItemOpcao o = new ItemOpcao(codigo, descricao);
        this.opcoes.put(codigo, o);
        this.listaOrdenada.addLast(o);
    }

    public void adicionaOpcao(String codigo, String descricao, boolean selecionado) {
        if (this.opcoes.containsKey(codigo)) {
            this.listaOrdenada.remove(this.opcoes.get(codigo));
        }
        ItemOpcao o = new ItemOpcao(codigo, descricao, selecionado);
        this.opcoes.put(codigo, o);
        this.listaOrdenada.addLast(o);
    }

    public void addOpcao(String codigo, String descricao, boolean selecionado) {
        if (this.opcoes.containsKey(codigo)) {
            this.listaOrdenada.remove(this.opcoes.get(codigo));
        }
        ItemOpcao o = new ItemOpcao(codigo, descricao, selecionado);
        this.opcoes.put(codigo, o);
        this.listaOrdenada.addLast(o);
    }

    public String getDescricaoOpcao(String valor) {
        if (this.opcoes.containsKey(valor)) {
            return ((ItemOpcao)this.opcoes.get(valor)).getDescricao();
        }
        return "";
    }

    public String getCodigoOpcao(String descricao) {
        String retorno = "";
        Iterator it = this.opcoes.values().iterator();
        while (it.hasNext()) {
            ItemOpcao o = (ItemOpcao)it.next();
            if (!o.getDescricao().trim().equals(descricao.trim())) continue;
            return o.getCodigo();
        }
        return retorno;
    }

    public String getDescricaoOpcoes() {
        Iterator it = this.opcoes.values().iterator();
        String result = "";
        while (it.hasNext()) {
            ItemOpcao o = (ItemOpcao)it.next();
            if (!o.isSelecionado()) continue;
            if (result.equals("")) {
                result = result + o.getDescricao();
                continue;
            }
            result = result + this.C_DELIMITADOR_OPCOES + o.getDescricao();
        }
        return result;
    }

    public String getCodigoOpcoes() {
        Iterator it = this.opcoes.values().iterator();
        String result = "";
        while (it.hasNext()) {
            ItemOpcao o = (ItemOpcao)it.next();
            if (!o.isSelecionado()) continue;
            if (result.equals("")) {
                result = result + o.getCodigo();
                continue;
            }
            result = result + this.C_DELIMITADOR_OPCOES + o.getCodigo();
        }
        return result;
    }

    public Opcao(ObjetoNegocio owner, String nomeCampo) {
        super(owner, nomeCampo);
    }

    public Opcao(ObjetoNegocio owner, String nomeCampo, List listaOpcoes) {
        super(owner, nomeCampo);
        for (int i = 0; i < listaOpcoes.size(); ++i) {
            this.adicionaOpcao(((ElementoTabela)listaOpcoes.get(i)).getConteudo(0), ((ElementoTabela)listaOpcoes.get(i)).getConteudo(1));
        }
    }

    public void converteEmTipoSimNao(String descricao, boolean selecionado, String valorInicial) {
        this.adicionaOpcao(LABEL_SIM, descricao, selecionado);
        this.setConteudo(valorInicial);
    }

    public void clear() {
        this.setConteudo("");
    }

    public String asString() {
        Iterator it = this.opcoes.values().iterator();
        String result = "";
        while (it.hasNext()) {
            ItemOpcao o = (ItemOpcao)it.next();
            if (!o.isSelecionado()) continue;
            if (result.equals("")) {
                result = result + o.getCodigo();
                continue;
            }
            result = result + this.C_DELIMITADOR_OPCOES + o.getCodigo();
        }
        return result;
    }

    public String getConteudoFormatado() {
        return this.asString();
    }

    public String getConteudo() {
        return this.asString();
    }

    public void setConteudo(String codigos) {
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + String.valueOf(this.conteudo));
        String antigo = this.conteudo;
        this.clearRetornosValidacoes();
        List listCodigos = Opcao.getListByString(codigos, this.C_DELIMITADOR_OPCOES);
        this.conteudo = codigos;
        Iterator it = this.opcoes.values().iterator();
        while (it.hasNext()) {
            ItemOpcao o = (ItemOpcao)it.next();
            o.setSelecionado(listCodigos.contains(o.getCodigo().trim()));
        }
        if (this.isVazio()) {
            this.getObservadores().firePropertyChange(this.getNomeCampo(), "_", "");
        } else {
            this.disparaObservadores(antigo);
        }
    }

    public void addSelectedItem(String codigo) {
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + String.valueOf(this.conteudo));
        if (!this.isSelecaoMultipla()) {
            this.setConteudo("");
        }
        ItemOpcao item = (ItemOpcao)this.opcoes.get(codigo);
        item.setSelecionado(true);
        this.setConteudo(this.getCodigoOpcoes());
    }

    public void delSelectedItem(String codigo) {
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + String.valueOf(this.conteudo));
        ItemOpcao item = (ItemOpcao)this.opcoes.get(codigo);
        item.setSelecionado(false);
        this.setConteudo(this.getCodigoOpcoes());
    }

    public boolean isVazio() {
        return this.asString() == null || this.asString().trim().length() == 0;
    }

    public Map getOpcoes() {
        return this.opcoes;
    }

    public void setOpcoes(Map opcoes) {
        this.opcoes = opcoes;
    }

    public LinkedList getListaOrdenada() {
        return this.listaOrdenada;
    }

    public boolean isSelecaoMultipla() {
        return this.selecaoMultipla;
    }

    public void setSelecaoMultipla(boolean selecaoMultipla) {
        this.selecaoMultipla = selecaoMultipla;
    }

    public static List getListByString(String valor, String delimitador) {
        int v_idx = 1;
        String valorFragmentado = null;
        String valorTemporario = null;
        Vector<String> result = new Vector<String>();
        valorTemporario = valor;
        while (v_idx > 0) {
            v_idx = valorTemporario.indexOf(delimitador);
            valorFragmentado = v_idx >= 0 ? valorTemporario.substring(0, v_idx) : valorTemporario;
            result.add(valorFragmentado);
            valorTemporario = valorTemporario.substring(v_idx + delimitador.length(), valorTemporario.length());
        }
        return result;
    }
}

