/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.IteratorColecaoPPGD;
import serpro.ppgd.negocio.ListIteratorColecaoPPGD;
import serpro.ppgd.negocio.util.LogPPGD;

public class ListaPPGD
implements List {
    private Vector implementacao = new Vector();
    private Colecao owner;

    public ListaPPGD(Colecao owner) {
        this.owner = owner;
    }

    private void objetoInserido(Object o) {
        this.owner.objetoInserido(o);
        if (this.owner.isObservadoresListaAtivos()) {
            this.owner.getObservadoresLista().firePropertyChange("ObjetoInserido", "alterou", o);
        }
    }

    private void objetoARemover(Object o) {
        this.owner.objetoARemover(o);
        if (this.owner.isObservadoresListaAtivos()) {
            this.owner.getObservadoresLista().firePropertyChange("ObjetoAremover", "alterou", o);
        }
    }

    private void objetoRemovido(Object o) {
        this.owner.objetoRemovido(o);
        if (this.owner.isObservadoresListaAtivos()) {
            this.owner.getObservadoresLista().firePropertyChange("ObjetoRemovido", "alterou", o);
        }
    }

    private void verificaTipoInserido(Object o) {
        if (this.owner.getTipoItens() != null && !this.owner.getTipoItens().isInstance(o)) {
            String msg = "Tentativa inv\u00e1lida de inser\u00e7\u00e3o do elemento " + o + " na cole\u00e7\u00e3o " + this.owner;
            LogPPGD.erro(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private void verificaTamanho(int index) {
        if (this.owner.getTamanho() != 0 && index >= this.owner.getTamanho()) {
            String msg = "A cole\u00e7\u00e3o " + this.owner.getClass().getName() + "ultrapassou o tamanho limite de " + this.owner.getTamanho() + ", foi requerido o index " + index;
            LogPPGD.erro(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    public void add(int index, Object element) {
        this.verificaTipoInserido(element);
        this.verificaTamanho(this.size());
        this.implementacao.add(index, element);
        this.objetoInserido(element);
    }

    public boolean add(Object o) {
        this.verificaTipoInserido(o);
        this.verificaTamanho(this.size());
        if (this.implementacao.add(o)) {
            this.objetoInserido(o);
            return true;
        }
        return false;
    }

    public boolean addAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.verificaTipoInserido(i.next());
        }
        if (this.implementacao.addAll(c)) {
            i = c.iterator();
            while (i.hasNext()) {
                this.objetoInserido(i.next());
            }
            return true;
        }
        return false;
    }

    public boolean addAll(int index, Collection c) {
        Iterator i = c.iterator();
        if (c.size() + this.size() > this.owner.getTamanho()) {
            throw new IllegalArgumentException("A cole\u00e7\u00e3o ultrapassou o tamanho limite.");
        }
        while (i.hasNext()) {
            this.verificaTipoInserido(i.next());
        }
        if (this.implementacao.addAll(index, c)) {
            i = c.iterator();
            while (i.hasNext()) {
                this.objetoInserido(i.next());
            }
            return true;
        }
        return false;
    }

    public boolean addAll(Collection c, boolean rodaEventoInsercao) {
        Iterator i = c.iterator();
        if (this.owner.getTamanho() > 0 && c.size() + this.size() > this.owner.getTamanho()) {
            throw new IllegalArgumentException("A cole\u00e7\u00e3o ultrapassou o tamanho limite.");
        }
        while (i.hasNext()) {
            this.verificaTipoInserido(i.next());
        }
        if (this.implementacao.addAll(c)) {
            if (rodaEventoInsercao) {
                i = c.iterator();
                while (i.hasNext()) {
                    this.objetoInserido(i.next());
                }
            }
            return true;
        }
        return false;
    }

    public void clear() {
        Iterator i = this.implementacao.iterator();
        while (i.hasNext()) {
            this.objetoARemover(i.next());
        }
        this.implementacao.clear();
    }

    public boolean contains(Object o) {
        return this.implementacao.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.implementacao.containsAll(c);
    }

    public Object get(int index) {
        return this.implementacao.get(index);
    }

    public int indexOf(Object o) {
        return this.implementacao.indexOf(o);
    }

    public boolean isEmpty() {
        return this.implementacao.isEmpty();
    }

    public Iterator iterator() {
        return new IteratorColecaoPPGD(this.implementacao.iterator(), this.owner);
    }

    public int lastIndexOf(Object o) {
        return this.implementacao.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return new ListIteratorColecaoPPGD(this.implementacao.listIterator(), this.owner, this);
    }

    public ListIterator listIterator(int index) {
        return new ListIteratorColecaoPPGD(this.implementacao.listIterator(index), this.owner, this);
    }

    public Object remove(int index) {
        Object o = null;
        if (index >= 0 && index < this.implementacao.size()) {
            o = this.implementacao.get(index);
            this.objetoARemover(o);
        }
        Object result = this.implementacao.remove(index);
        this.objetoRemovido(o);
        return result;
    }

    public boolean remove(Object o) {
        boolean result = false;
        if (this.implementacao.contains(o)) {
            this.objetoARemover(o);
            result = this.implementacao.remove(o);
            this.objetoRemovido(o);
        }
        return result;
    }

    public boolean removeAll(Collection c) {
        Object o;
        Iterator i = c.iterator();
        boolean result = false;
        while (i.hasNext()) {
            o = i.next();
            if (!this.implementacao.contains(o)) continue;
            this.objetoARemover(o);
        }
        result = this.implementacao.removeAll(c);
        if (result) {
            i = c.iterator();
            while (i.hasNext()) {
                o = i.next();
                if (this.implementacao.contains(o)) continue;
                this.objetoRemovido(o);
            }
        }
        return result;
    }

    public boolean retainAll(Collection c) {
        Object o;
        Iterator i = this.implementacao.iterator();
        while (i.hasNext()) {
            o = i.next();
            if (c.contains(o)) continue;
            this.objetoARemover(o);
        }
        boolean result = this.implementacao.retainAll(c);
        i = this.implementacao.iterator();
        while (i.hasNext()) {
            o = i.next();
            if (c.contains(o)) continue;
            this.objetoRemovido(o);
        }
        return result;
    }

    public Object set(int index, Object element) {
        this.verificaTipoInserido(element);
        this.verificaTamanho(index);
        Object o = null;
        if (index >= 0 && index < this.implementacao.size()) {
            o = this.implementacao.get(index);
            this.objetoARemover(o);
        }
        Object res = this.implementacao.set(index, element);
        if (index >= 0 && index < this.implementacao.size()) {
            this.objetoRemovido(o);
        }
        this.owner.objetoInserido(element);
        return res;
    }

    public int size() {
        return this.implementacao.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.implementacao.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.implementacao.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.implementacao.toArray(a);
    }
}

