/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.RetornosValidacoes;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosString;

public abstract class Informacao
implements Comparable {
    public static final String VALIDO_PROPERTY = "Val-Property";
    public static final String READ_ONLY_PROPERTY = "ReadOnly";
    public static final String HABILITADO_PROPERTY = "habilitado";
    public static final String ROTULO_CHANGE_PROPERTY = "Label_Modificado";
    private String nomeCampo = "";
    private String nomeCampoCurto = "";
    private ObjetoNegocio owner;
    private String conteudo = "";
    private String ficha = "";
    private boolean readOnly = false;
    private boolean habilitado = true;
    private boolean transportado = false;
    protected String conteudoAntigo = "";
    protected boolean inicializouUltimoConteudoValido = false;
    private String ultimoConteudoValido = "";
    private Vector listaValidadores;
    private Vector listaValidadoresImpeditivos = new Vector();
    private RetornosValidacoes retornoTodasValidacoes = new RetornosValidacoes();
    private PropertyChangeSupport observadores = new PropertyChangeSupport(this);
    private boolean observadoresAtivos = true;
    private boolean validadoresAtivos = true;
    private boolean atributoPersistente = true;

    public Informacao() {
    }

    public Informacao(ObjetoNegocio owner, String nomeCampo) {
        this();
        this.setOwner(owner);
        this.setNomeCampo(nomeCampo);
        this.setNomeCampoAlternativo(nomeCampo);
        LogPPGD.debug("Campo [" + nomeCampo + "] criado como objeto " + this.getClass().getName() + ".");
    }

    public Informacao(String nomeCampo) {
        this();
        this.setNomeCampo(nomeCampo);
        this.setNomeCampoAlternativo(nomeCampo);
        LogPPGD.debug("Campo [" + nomeCampo + "] criado como objeto " + this.getClass().getName() + ".");
    }

    public void setConteudo(String conteudo) {
        if (!this.inicializouUltimoConteudoValido) {
            this.inicializouUltimoConteudoValido = true;
            this.ultimoConteudoValido = conteudo;
        }
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + conteudo);
        String antigo = this.asString();
        this.clearRetornosValidacoes();
        this.conteudo = conteudo;
        if (this.isVazio()) {
            this.ultimoConteudoValido = "";
        }
        this.disparaObservadores(antigo);
    }

    public abstract String getConteudoFormatado();

    public String toString() {
        return this.getConteudoFormatado();
    }

    public String asString() {
        return this.conteudo;
    }

    public boolean isVazio() {
        return this.asString() == null || UtilitariosString.retiraMascara(this.asString().trim()).length() == 0;
    }

    public int compareTo(Object o) {
        return this.asString().compareTo(o.toString());
    }

    public void clear() {
        this.setConteudo("");
    }

    public String getNomeCampo() {
        return this.nomeCampo;
    }

    public void setNomeCampo(String nomeCampo) {
        String nomeAntigo = this.getNomeCampo();
        this.nomeCampo = nomeCampo;
        this.getObservadores().firePropertyChange(ROTULO_CHANGE_PROPERTY, nomeAntigo, this.getNomeCampo());
    }

    public void addValidador(ValidadorIf validador) {
        if (this.listaValidadores == null) {
            this.listaValidadores = new Vector();
        }
        if (validador instanceof ValidadorImpeditivoDefault) {
            this.listaValidadoresImpeditivos.add(validador);
        } else {
            this.listaValidadores.add(validador);
        }
        validador.setInformacao(this);
        validador.setRetornosValidacoes(this.retornoTodasValidacoes);
    }

    public boolean isValido() {
        return this.retornoTodasValidacoes.isTodosValidos();
    }

    public RetornoValidacao getPrimeiroRetornoValidacaoMaisSevero() {
        return this.retornoTodasValidacoes.getPrimeiroRetornoValidacaoMaisSevero();
    }

    public void clearRetornosValidacoes() {
        this.retornoTodasValidacoes.clear();
    }

    public RetornosValidacoes validar() {
        LogPPGD.debug("Valida\u00e7\u00e3o de " + this.getNomeCampo() + " [=" + this.toString() + "]");
        this.retornoTodasValidacoes.clear();
        if (this.listaValidadores != null && this.isValidadoresAtivos()) {
            Iterator validadores = this.listaValidadores.iterator();
            while (validadores.hasNext()) {
                ((ValidadorIf)validadores.next()).validar();
            }
        }
        if (this.isValido() && this.getRetornoTodasValidacoes().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade() != 4) {
            this.setUltimoConteudoValido(this.asString());
        }
        return this.retornoTodasValidacoes;
    }

    public ObjetoNegocio getOwner() {
        return this.owner;
    }

    public void setOwner(ObjetoNegocio owner) {
        this.owner = owner;
    }

    public PropertyChangeSupport getObservadores() {
        return this.observadores;
    }

    public void addObservador(Observador observador) {
        this.observadores.addPropertyChangeListener(observador);
    }

    public void addObservador(String nomePropriedade, Observador observador) {
        this.observadores.addPropertyChangeListener(nomePropriedade, observador);
    }

    public void removeObservador(Observador observador) {
        this.observadores.removePropertyChangeListener(observador);
    }

    public void removeObservador(String nomePropriedade, Observador observador) {
        this.observadores.removePropertyChangeListener(nomePropriedade, observador);
    }

    public void disparaObservadores() {
        if (this.isVazio()) {
            this.disparaObservadores("");
            return;
        }
        this.disparaObservadores("_");
    }

    protected void disparaObservadores(Object aConteudoAntigo) {
        if (aConteudoAntigo != null && !aConteudoAntigo.equals("-")) {
            this.setConteudoAntigo((String)aConteudoAntigo);
        }
        LogPPGD.debug("Chamando observadores de " + this.getNomeCampo() + " [=" + this.toString() + "]");
        if (this.isObservadoresAtivos()) {
            this.getObservadores().firePropertyChange(this.getNomeCampo(), aConteudoAntigo, this.asString());
        }
    }

    public boolean isObservadoresAtivos() {
        return this.observadoresAtivos;
    }

    public void setObservadoresAtivos(boolean b) {
        this.observadoresAtivos = b;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean b) {
        LogPPGD.debug(this.getNomeCampo() + "." + "readOnly" + " = " + String.valueOf(b));
        boolean readOnlyAntigo = this.readOnly;
        this.readOnly = b;
        if (this.isObservadoresAtivos() && readOnlyAntigo != this.readOnly) {
            this.getObservadores().firePropertyChange(READ_ONLY_PROPERTY, !b, b);
        }
    }

    public String getFicha() {
        return this.ficha;
    }

    public void setFicha(String string) {
        this.ficha = string;
    }

    public RetornosValidacoes getRetornoTodasValidacoes() {
        return this.retornoTodasValidacoes;
    }

    public void setRetornoTodasValidacoes(RetornosValidacoes retornoTodasValidacoes) {
        this.retornoTodasValidacoes = retornoTodasValidacoes;
    }

    public Vector getListaValidadores() {
        return this.listaValidadores;
    }

    public void setNomeCampoAlternativo(String nomeCampoCurto) {
        this.nomeCampoCurto = nomeCampoCurto;
    }

    public String getNomeCampoCurto() {
        return this.nomeCampoCurto;
    }

    public void setHabilitado(boolean aHabilitado) {
        LogPPGD.debug(this.getNomeCampo() + "." + "isHabilitado" + " = " + String.valueOf(aHabilitado));
        this.habilitado = aHabilitado;
        if (this.isObservadoresAtivos()) {
            this.getObservadores().firePropertyChange(HABILITADO_PROPERTY, !aHabilitado, aHabilitado);
        }
        this.habilitado = aHabilitado;
    }

    public void sinalizaValidoEdit() {
        this.getObservadores().firePropertyChange(VALIDO_PROPERTY, "Invalido", "Valido");
    }

    public boolean isHabilitado() {
        return this.habilitado;
    }

    public boolean isTransportado() {
        return this.transportado;
    }

    public void setTransportado(boolean transportado) {
        this.transportado = transportado;
    }

    public String getConteudoAntigo() {
        return this.conteudoAntigo;
    }

    public void setConteudoAntigo(String valorAntigo) {
        if (!valorAntigo.equals(this.asString())) {
            this.conteudoAntigo = valorAntigo;
        }
    }

    public void removeObservadores(Class[] pTipoClasses) throws ClassNotFoundException {
        PropertyChangeListener[] observadores = this.getObservadores().getPropertyChangeListeners();
        for (int i = 0; i < observadores.length; ++i) {
            String nomeClasse = observadores[i].getClass().getName();
            Class<?> classeBase = null;
            classeBase = nomeClasse.indexOf("$") != -1 ? Class.forName(nomeClasse.substring(0, nomeClasse.indexOf("$"))) : observadores[i].getClass();
            if (!this.comparaClass(pTipoClasses, classeBase)) continue;
            this.getObservadores().removePropertyChangeListener(observadores[i]);
        }
    }

    private boolean comparaClass(Class[] pTipoClasses, Class tipoProcurado) {
        for (int tipoClasse = 0; tipoClasse < pTipoClasses.length; ++tipoClasse) {
            if (!pTipoClasses[tipoClasse].isAssignableFrom(tipoProcurado)) continue;
            return true;
        }
        return false;
    }

    public void removeObservadoresAnonimosDesnecessarios(Class pClasse) throws ClassNotFoundException {
        PropertyChangeListener[] observadores = this.getObservadores().getPropertyChangeListeners();
        for (int i = 0; i < observadores.length; ++i) {
            Class<?> classeBase;
            String nomeClasse = observadores[i].getClass().getName();
            if (nomeClasse.indexOf("$") == -1 || !pClasse.isAssignableFrom(classeBase = Class.forName(nomeClasse.substring(0, nomeClasse.indexOf("$"))))) continue;
            this.getObservadores().removePropertyChangeListener(observadores[i]);
        }
    }

    public boolean isValidadoresAtivos() {
        return this.validadoresAtivos;
    }

    public void setValidadoresAtivos(boolean validadoresAtivos) {
        this.validadoresAtivos = validadoresAtivos;
    }

    public void setUltimoConteudoValido(String ultimoConteudoValido) {
        this.ultimoConteudoValido = ultimoConteudoValido;
    }

    public String getUltimoConteudoValido() {
        return this.ultimoConteudoValido;
    }

    public Vector getListaValidadoresImpeditivos() {
        return this.listaValidadoresImpeditivos;
    }

    public void ordenaListaValidadoreImpeditivos() {
        LinkedList<ValidadorImpeditivoDefault> auxListaImpeditivos = new LinkedList<ValidadorImpeditivoDefault>();
        LinkedList<ValidadorImpeditivoDefault> auxListaOkCancelar = new LinkedList<ValidadorImpeditivoDefault>();
        Iterator itValidadores = this.getListaValidadoresImpeditivos().iterator();
        while (itValidadores.hasNext()) {
            ValidadorImpeditivoDefault validador = (ValidadorImpeditivoDefault)itValidadores.next();
            if (validador.getSeveridade() == 5) {
                auxListaImpeditivos.add(validador);
                continue;
            }
            if (validador.getSeveridade() != 4) continue;
            auxListaOkCancelar.add(validador);
        }
        auxListaImpeditivos.addAll(auxListaOkCancelar);
        this.listaValidadoresImpeditivos.clear();
        this.listaValidadoresImpeditivos.addAll(auxListaImpeditivos);
    }

    public boolean isAtributoPersistente() {
        return this.atributoPersistente;
    }

    public void setAtributoPersistente(boolean atributoPersistente) {
        this.atributoPersistente = atributoPersistente;
    }
}

