/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.List;
import java.util.Vector;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class Codigo
extends Informacao {
    private List colecao;
    private boolean isSimples = false;
    private int colunaFiltro = -1;
    public static final String REINICIADO = "ComboReiniciado";

    public Codigo() {
        this(null, "", new Vector());
    }

    public Codigo(String nomeCampo) {
        this(null, nomeCampo, new Vector());
    }

    public Codigo(ObjetoNegocio owner, String nomeCampo, List colecao) {
        super(owner, nomeCampo);
        this.colecao = colecao;
    }

    public Codigo(ObjetoNegocio owner, String nomeCampo, List colecao, boolean aIsSimples) {
        super(owner, nomeCampo);
        this.colecao = colecao;
        this.setSimples(aIsSimples);
    }

    public String getConteudoFormatado() {
        return this.asString();
    }

    public void setConteudo(int valor) {
        this.setConteudo(String.valueOf(valor));
    }

    public int asInteger() {
        try {
            return Integer.parseInt(this.getConteudoFormatado());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean existeElementoTabela(int col, String param) {
        ElementoTabela e = this.retornaElementoTabela(col, param);
        return e != null;
    }

    public ElementoTabela retornaElementoTabela(int col, String param) {
        for (int i = 0; i < this.colecao.size(); ++i) {
            ElementoTabela elementoTabela = (ElementoTabela)this.colecao.get(i);
            if (!elementoTabela.getConteudo(col).equalsIgnoreCase(param)) continue;
            return elementoTabela;
        }
        return null;
    }

    public List getColecaoElementoTabela() {
        return this.colecao;
    }

    public void setColecaoElementoTabela(List colecao) {
        this.colecao = colecao;
        this.getObservadores().firePropertyChange(REINICIADO, "1", "2");
        if (this.getIndiceElementoTabela() == -1) {
            this.clear();
        }
    }

    public ElementoTabela getElementoTabela(int i) {
        if (i == -1) {
            return null;
        }
        return (ElementoTabela)this.colecao.get(i);
    }

    public ElementoTabela getElementoTabela() {
        int i = this.getIndiceElementoTabela();
        if (i == -1) {
            return null;
        }
        return (ElementoTabela)this.colecao.get(i);
    }

    public int getIndiceElementoTabela() {
        if (this.colecao != null) {
            for (int i = 0; i < this.colecao.size(); ++i) {
                ElementoTabela elementoTabela = (ElementoTabela)this.colecao.get(i);
                if (!elementoTabela.getConteudo(0).toString().equalsIgnoreCase(this.getConteudoFormatado())) continue;
                return i;
            }
        }
        return -1;
    }

    public String getConteudoAtual(int coluna) {
        ElementoTabela elementoTabela = this.getElementoTabela();
        if (elementoTabela != null) {
            return elementoTabela.getConteudo(coluna).toString();
        }
        return "";
    }

    public String getDescricaoDefault() {
        String descricao;
        ElementoTabela elementoTabela = this.getElementoTabela();
        if (elementoTabela != null && elementoTabela.size() > 2 && (descricao = elementoTabela.getConteudo(1)) != null) {
            return descricao;
        }
        return "";
    }

    public boolean isSimples() {
        return this.isSimples;
    }

    public void setSimples(boolean isSimples) {
        this.isSimples = isSimples;
    }

    public int getColunaFiltro() {
        return this.colunaFiltro;
    }

    public void setColunaFiltro(int colunaFiltro) {
        this.colunaFiltro = colunaFiltro;
    }
}

