/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import serpro.ppgd.gui.table.ColumnGroup;
import serpro.ppgd.gui.table.GroupableTableColumnModel;
import serpro.ppgd.gui.table.GroupableTableHeader;

public class GroupableTableHeaderUI
extends BasicTableHeaderUI {
    protected Vector paintedGroups = new Vector();

    public void paint(Graphics g, JComponent c) {
        Rectangle clipBounds = g.getClipBounds();
        GroupableTableColumnModel cm = (GroupableTableColumnModel)this.header.getColumnModel();
        if (cm == null) {
            return;
        }
        ((GroupableTableHeader)this.header).setColumnMargin();
        int column = 0;
        Dimension size = this.header.getSize();
        Rectangle cellRect = new Rectangle(0, 0, size.width, size.height);
        Hashtable<ColumnGroup, Rectangle> h = new Hashtable<ColumnGroup, Rectangle>();
        int columnMargin = cm.getColumnMargin();
        Enumeration<TableColumn> columns = cm.getColumns();
        while (columns.hasMoreElements()) {
            cellRect.height = size.height;
            cellRect.y = 0;
            TableColumn aColumn = columns.nextElement();
            Iterator colGrpIter = cm.getColumnGroups(aColumn);
            if (colGrpIter != null) {
                int groupHeight = 0;
                while (colGrpIter.hasNext()) {
                    ColumnGroup cGroup = (ColumnGroup)colGrpIter.next();
                    Rectangle groupRect = (Rectangle)h.get(cGroup);
                    if (groupRect == null) {
                        groupRect = new Rectangle(cellRect);
                        Dimension d = cGroup.getSize(this.header.getTable());
                        groupRect.width = d.width;
                        groupRect.height = d.height;
                        h.put(cGroup, groupRect);
                    }
                    if (!this.paintedGroups.contains(cGroup)) {
                        this.paintCell(g, groupRect, cGroup);
                        this.paintedGroups.add(cGroup);
                    }
                    cellRect.height = size.height - (groupHeight += groupRect.height);
                    cellRect.y = groupHeight;
                }
            }
            cellRect.width = aColumn.getWidth();
            if (cellRect.intersects(clipBounds)) {
                this.paintCell(g, cellRect, column);
            }
            cellRect.x += cellRect.width;
            ++column;
        }
        this.paintedGroups.clear();
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        Component component = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private void paintCell(Graphics g, Rectangle cellRect, ColumnGroup cGroup) {
        TableCellRenderer renderer = cGroup.getHeaderRenderer();
        Component component = renderer.getTableCellRendererComponent(this.header.getTable(), cGroup.getHeaderValue(), false, false, -1, -1);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private int getHeaderHeight() {
        int height = 0;
        GroupableTableColumnModel columnModel = (GroupableTableColumnModel)this.header.getColumnModel();
        int column = 0;
        while (column < columnModel.getColumnCount()) {
            TableColumn aColumn = columnModel.getColumn(column);
            TableCellRenderer renderer = aColumn.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.header.getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, column);
            int cHeight = comp.getPreferredSize().height;
            Iterator iter = columnModel.getColumnGroups(aColumn);
            if (iter != null) {
                while (iter.hasNext()) {
                    ColumnGroup cGroup = (ColumnGroup)iter.next();
                    cHeight += cGroup.getSize((JTable)this.header.getTable()).height;
                }
            }
            height = Math.max(height, cHeight);
            ++column;
        }
        return height;
    }

    private Dimension createHeaderSize(long width) {
        TableColumnModel columnModel = this.header.getColumnModel();
        if ((width += (long)(columnModel.getColumnMargin() * columnModel.getColumnCount())) > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }

    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> columns = this.header.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn aColumn = columns.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSize(width);
    }
}

