/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.pendencia;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.table.DefaultTableCellRenderer;
import serpro.ppgd.gui.FabricaGUI;
import serpro.ppgd.gui.pendencia.LinhaPendencia;
import serpro.ppgd.gui.pendencia.SelecionarPendencia;
import serpro.ppgd.gui.pendencia.TableModelPendencia;
import serpro.ppgd.gui.table.JTableEx;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.UtilitariosString;

public class EditTablePendencia
extends JTableEx {
    protected TableModelPendencia tableModel = null;
    protected int linhaDoMouseOver = -1;

    public EditTablePendencia(TableModelPendencia pTableModel) {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.tableModel = pTableModel;
        this.setModel(this.tableModel);
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer();
        renderer.setHorizontalAlignment(2);
        this.configuraLayout();
        this.addMouseListener(new SelecionarPendencia(this){

            protected void selecaoCampoPendente(Pendencia pPendencia) {
                FabricaGUI.mudaCursor(EditTablePendencia.this, 0);
                SwingUtilities.getRoot(EditTablePendencia.this).setVisible(false);
                EditTablePendencia.this.selecionaPendencia(pPendencia);
            }
        });
        int i = 0;
        while (i < this.getColumnCount()) {
            this.getColumnModel().getColumn(i).setPreferredWidth(this.tableModel.getTamColunas()[i]);
            ++i;
        }
        this.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (column == 1 && row == EditTablePendencia.this.linhaDoMouseOver && this.getText().trim().length() != 0) {
                    EditTablePendencia.this.formataTextoDaPendenciaOnMouseOver(this);
                    return this;
                }
                EditTablePendencia.this.formataTextoDaPendencia(this);
                return this;
            }
        });
        this.setAutoResizeMode(0);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent me) {
                Pendencia p;
                EditTablePendencia.this.setToolTipText("");
                int lin = EditTablePendencia.this.rowAtPoint(new Point(me.getX(), me.getY()));
                int col = EditTablePendencia.this.columnAtPoint(new Point(me.getX(), me.getY()));
                if (col == 1 && lin != -1 && (p = EditTablePendencia.this.tableModel.getPendenciaAt(lin)) != null && p.getSeveridade() != 0) {
                    EditTablePendencia.this.onMouseOverDaPendencia();
                    EditTablePendencia.this.linhaDoMouseOver = lin;
                    EditTablePendencia.this.setToolTipText("<HTML><B><LEFT>" + UtilitariosString.insereQuebraDeLinha((String)p.getMsg(), (int)40, (String)"<BR>") + "</LEFT></B></HTML>");
                    EditTablePendencia.this.repaint();
                    return;
                }
                EditTablePendencia.this.linhaDoMouseOver = -1;
                EditTablePendencia.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                EditTablePendencia.this.linhaDoMouseOver = -1;
                EditTablePendencia.this.setCursor(Cursor.getPredefinedCursor(0));
                EditTablePendencia.this.repaint();
            }
        });
    }

    public Object getValueAt(int row, int column) {
        Object retorno = super.getValueAt(row, column);
        if (column == 1) {
            LinhaPendencia linhaPendencia = ((TableModelPendencia)this.getModel()).getLinhaPendenciaAt(row);
            if (linhaPendencia != null && linhaPendencia.getSeveridade() != 0) {
                String texto = (String)retorno;
                JLabel lbl = new JLabel(texto);
                if (this.getRowHeight() < lbl.getPreferredSize().height) {
                    this.setRowHeight(row, lbl.getPreferredSize().height + lbl.getPreferredSize().height / 2);
                }
            } else if (linhaPendencia != null && linhaPendencia.getSeveridade() == 0) {
                String texto = (String)retorno;
                JLabel lbl = new JLabel(texto);
                if (this.getRowHeight() < lbl.getPreferredSize().height) {
                    this.setRowHeight(row, lbl.getPreferredSize().height + lbl.getPreferredSize().height / 4);
                }
            }
        }
        return retorno;
    }

    protected void configuraLayout() {
    }

    protected void onMouseOverDaPendencia() {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    protected void formataTextoDaPendenciaOnMouseOver(JLabel pLblTexto) {
    }

    protected void formataTextoDaPendencia(JLabel pLblTexto) {
    }

    public void selecionaPendencia(Pendencia pPendencia) {
    }
}

