/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import serpro.ppgd.gui.EditMascara;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.util.UtilitariosString;

public class EditNI
extends EditMascara
implements FocusListener {
    private static String maskara = "**************";
    private static String maskaraCPF = "***.***.***-**";
    private static String maskaraCNPJ = "**.***.***/****-**";
    private static String caracteresValidos = "0123456789 ";

    public EditNI() {
        this((Informacao)new NI(null, "NI"));
    }

    public EditNI(Informacao campo) {
        this.aplicaMascaraCorrespondente(campo);
        this.setAssociaInformacao(campo);
        this.setCaracteresValidos(caracteresValidos);
        this.getComponenteEditor().addFocusListener(this);
    }

    public void setarMascaraCPF() {
        this.getInformacao().setConteudo(this.getInformacao().asString().trim());
        this.setMascara(maskaraCPF);
        this.setCaracteresValidos(caracteresValidos);
    }

    public void setarMascaraCNPJ() {
        this.setMascara(maskaraCNPJ);
        this.setCaracteresValidos(caracteresValidos);
    }

    public void focusLost(FocusEvent e) {
        this.aplicaMascaraCorrespondente(this.getInformacao());
    }

    private void aplicaMascaraCorrespondente(Informacao campo) {
        if (campo.asString().length() == 11) {
            this.setarMascaraCPF();
        } else if (campo.asString().length() == 14) {
            this.setarMascaraCNPJ();
        } else {
            this.setMascara(maskara);
        }
    }

    public void focusGained(FocusEvent e) {
        String txt = UtilitariosString.retiraMascara((String)this.componente.getText());
        this.setMascara(maskara);
        this.setCaracteresValidos(caracteresValidos);
        this.componente.setText(txt);
    }
}

